/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.ui.core.internal.RedirectHandler;
import com.adyen.checkout.ui.core.internal.util.CustomTabsLauncher;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0003J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0016\u0010\u0018\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/adyen/checkout/ui/core/internal/DefaultRedirectHandler;", "Lcom/adyen/checkout/ui/core/internal/RedirectHandler;", "()V", "onRedirectListener", "Ljava/lang/ref/WeakReference;", "Lkotlin/Function0;", "", "launchBrowser", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "launchNative", "launchNativeApi30", "launchNativeBeforeApi30", "launchUriRedirect", "url", "", "launchWithCustomTabs", "parseRedirectResult", "Lorg/json/JSONObject;", "data", "removeOnRedirectListener", "setOnRedirectListener", "listener", "Companion", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDefaultRedirectHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultRedirectHandler.kt\ncom/adyen/checkout/ui/core/internal/DefaultRedirectHandler\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n16#2,17:203\n16#2,17:223\n16#2,17:248\n16#2,17:265\n16#2,17:282\n16#2,17:299\n16#2,17:316\n16#2,17:333\n16#2,17:350\n16#2,17:367\n16#2,17:384\n1#3:220\n216#4,2:221\n1557#5:240\n1628#5,3:241\n1557#5:244\n1628#5,3:245\n*S KotlinDebug\n*F\n+ 1 DefaultRedirectHandler.kt\ncom/adyen/checkout/ui/core/internal/DefaultRedirectHandler\n*L\n32#1:203,17\n78#1:223,17\n115#1:248,17\n125#1:265,17\n128#1:282,17\n144#1:299,17\n147#1:316,17\n156#1:333,17\n158#1:350,17\n177#1:367,17\n180#1:384,17\n57#1:221,2\n98#1:240\n98#1:241,3\n105#1:244\n105#1:245,3\n*E\n"})
public final class DefaultRedirectHandler
implements RedirectHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private WeakReference<Function0<Unit>> onRedirectListener;
    @NotNull
    private static final String PAYLOAD_PARAMETER = "payload";
    @NotNull
    private static final String REDIRECT_RESULT_PARAMETER = "redirectResult";
    @NotNull
    private static final String PAYMENT_RESULT_PARAMETER = "PaRes";
    @NotNull
    private static final String MD_PARAMETER = "MD";
    @NotNull
    private static final String QUERY_STRING_RESULT = "returnUrlQueryString";

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JSONObject parseRedirectResult(@Nullable Uri data) {
        Object extractedParams;
        String it;
        DefaultRedirectHandler defaultRedirectHandler = this;
        Object level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog((AdyenLogLevel)level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            Object object = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "parseRedirectResult - " + data;
            adyenLogger.log((AdyenLogLevel)object, string2, string3, throwable$iv);
        }
        if (data == null) {
            throw new CheckoutException("Received a null redirect Uri", null, 2, null);
        }
        Object $this$parseRedirectResult_u24lambda_u245 = level$iv = new HashMap();
        boolean bl = false;
        String string4 = data.getQueryParameter(PAYLOAD_PARAMETER);
        if (string4 != null) {
            it = string4;
            boolean bl2 = false;
            ((HashMap)$this$parseRedirectResult_u24lambda_u245).put(PAYLOAD_PARAMETER, it);
        }
        String string5 = data.getQueryParameter(REDIRECT_RESULT_PARAMETER);
        if (string5 != null) {
            it = string5;
            boolean bl3 = false;
            ((HashMap)$this$parseRedirectResult_u24lambda_u245).put(REDIRECT_RESULT_PARAMETER, it);
        }
        String string6 = data.getQueryParameter(PAYMENT_RESULT_PARAMETER);
        if (string6 != null) {
            String paymentResult = string6;
            boolean bl4 = false;
            String string7 = data.getQueryParameter(MD_PARAMETER);
            if (string7 != null) {
                String md = string7;
                boolean bl5 = false;
                ((HashMap)$this$parseRedirectResult_u24lambda_u245).put(PAYMENT_RESULT_PARAMETER, paymentResult);
                ((HashMap)$this$parseRedirectResult_u24lambda_u245).put(MD_PARAMETER, md);
            }
        }
        if (((HashMap)(extractedParams = level$iv)).isEmpty()) {
            String string8 = data.getEncodedQuery();
            if (string8 != null) {
                String it2 = string8;
                boolean bl6 = false;
                ((HashMap)extractedParams).put(QUERY_STRING_RESULT, it2);
            }
        }
        if (((HashMap)extractedParams).isEmpty()) {
            throw new CheckoutException("Error parsing redirect result, could not find any query parameters", null, 2, null);
        }
        try {
            Object $this$parseRedirectResult_u24lambda_u248 = level$iv = new JSONObject();
            boolean bl7 = false;
            Map $this$forEach$iv = (Map)extractedParams;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it3 = element$iv = iterator.next();
                boolean bl8 = false;
                $this$parseRedirectResult_u24lambda_u248.put((String)it3.getKey(), it3.getValue());
            }
            return level$iv;
        }
        catch (JSONException e) {
            throw new CheckoutException("Error creating redirect result.", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void launchUriRedirect(@NotNull Context context, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = url;
        if (charSequence == null || charSequence.length() == 0) {
            throw new ComponentException("Redirect URL is empty.", null, 2, null);
        }
        Uri uri = Uri.parse((String)url);
        Intrinsics.checkNotNull((Object)uri);
        if (this.launchNative(context, uri) || this.launchWithCustomTabs(context, uri) || this.launchBrowser(context, uri)) {
            Function0 function0 = this.onRedirectListener;
            if (function0 != null && (function0 = (Function0)function0.get()) != null) {
                function0.invoke();
            }
            return;
        }
        DefaultRedirectHandler defaultRedirectHandler = this;
        AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "Could not launch url";
            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
        }
        throw new ComponentException("Launching redirect failed.", null, 2, null);
    }

    private final boolean launchNative(Context context, Uri uri) {
        return Build.VERSION.SDK_INT >= 30 ? this.launchNativeApi30(context, uri) : this.launchNativeBeforeApi30(context, uri);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean launchNativeBeforeApi30(Context context, Uri uri) {
        boolean bl;
        String outerClassName$iv;
        DefaultRedirectHandler $this$adyenLog_u24default$iv;
        DefaultRedirectHandler throwable$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        PackageManager pm = context.getPackageManager();
        Intent intent = new Intent().setAction("android.intent.action.VIEW").addCategory("android.intent.category.BROWSABLE").setData(Uri.fromParts((String)"http", (String)"", null));
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setData(...)");
        Intent browserActivityIntent = intent;
        List list = pm.queryIntentActivities(browserActivityIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryIntentActivities(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator<T> it;
            ResolveInfo resolveInfo = (ResolveInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(((ResolveInfo)it).resolvePackageName);
        }
        Set genericResolvedSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Intent intent2 = new Intent("android.intent.action.VIEW", uri).addCategory("android.intent.category.BROWSABLE");
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"addCategory(...)");
        Intent specializedActivityIntent = intent2;
        List list2 = pm.queryIntentActivities(specializedActivityIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"queryIntentActivities(...)");
        Object $this$map$iv2 = list2;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResolveInfo resolveInfo = (ResolveInfo)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(it.resolvePackageName);
        }
        Set resolvedSpecializedSet = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
        resolvedSpecializedSet.removeAll(genericResolvedSet);
        if (resolvedSpecializedSet.isEmpty()) {
            $this$map$iv2 = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                collection = AdyenLogger.Companion.getLogger();
                boolean bl4 = false;
                String string3 = "launchNativeBeforeApi30 - could not find native app to redirect with";
                collection.log(adyenLogLevel, string2, string3, (Throwable)((Object)throwable$iv));
            }
            return false;
        }
        specializedActivityIntent.addFlags(0x10000000);
        try {
            context.startActivity(specializedActivityIntent);
            $this$adyenLog_u24default$iv = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                collection = AdyenLogger.Companion.getLogger();
                boolean bl5 = false;
                String string5 = "launchNativeBeforeApi30 - redirect successful with native app";
                collection.log(adyenLogLevel, string4, string5, (Throwable)((Object)throwable$iv));
            }
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            throwable$iv = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv2 = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv2;
                String fullClassName$iv = $this$adyenLog_u24default$iv2.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv2 = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string6 = tag$iv = "CO." + (((CharSequence)outerClassName$iv2).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv2, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                collection = AdyenLogger.Companion.getLogger();
                boolean bl6 = false;
                String string7 = "launchNativeBeforeApi30 - could not find native app to redirect with";
                collection.log(adyenLogLevel, string6, string7, throwable$iv2);
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=30)
    private final boolean launchNativeApi30(Context context, Uri uri) {
        boolean bl;
        Intent intent = new Intent("android.intent.action.VIEW", uri).addCategory("android.intent.category.BROWSABLE").addFlags(0x10000400);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"addFlags(...)");
        Intent nativeAppIntent = intent;
        try {
            context.startActivity(nativeAppIntent);
            DefaultRedirectHandler defaultRedirectHandler = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl2 = false;
                String string3 = "launchNativeApi30 - redirect successful with native app";
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            DefaultRedirectHandler throwable$iv = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv2 = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl3 = false;
                String string5 = "launchNativeApi30 - could not find native app to redirect with";
                adyenLogger.log(adyenLogLevel, string4, string5, throwable$iv2);
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean launchWithCustomTabs(Context context, Uri uri) {
        boolean isLaunched = CustomTabsLauncher.INSTANCE.launchCustomTab(context, uri);
        if (isLaunched) {
            DefaultRedirectHandler defaultRedirectHandler = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string3 = "launchWithCustomTabs - redirect successful with custom tabs";
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
        } else {
            DefaultRedirectHandler $this$adyenLog_u24default$iv = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string5 = "launchWithCustomTabs - device doesn't support custom tabs or chrome is disabled";
                adyenLogger.log(adyenLogLevel, string4, string5, throwable$iv);
            }
        }
        return isLaunched;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean launchBrowser(Context context, Uri uri) {
        boolean bl;
        try {
            Intent intent = new Intent().setAction("android.intent.action.VIEW").addCategory("android.intent.category.BROWSABLE").addFlags(0x10000000).setData(uri);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setData(...)");
            Intent browserActivityIntent = intent;
            context.startActivity(browserActivityIntent);
            DefaultRedirectHandler defaultRedirectHandler = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl2 = false;
                String string3 = "launchBrowser - redirect successful with browser";
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            DefaultRedirectHandler level$iv = this;
            AdyenLogLevel level$iv2 = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv2)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv2;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl3 = false;
                String string5 = "launchBrowser - could not do redirect on browser or there's no browser";
                adyenLogger.log(adyenLogLevel, string4, string5, throwable$iv);
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public void setOnRedirectListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.onRedirectListener = new WeakReference<Function0<Unit>>(listener);
    }

    @Override
    public void removeOnRedirectListener() {
        WeakReference<Function0<Unit>> weakReference = this.onRedirectListener;
        if (weakReference != null) {
            weakReference.clear();
        }
        this.onRedirectListener = null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/ui/core/internal/DefaultRedirectHandler$Companion;", "", "()V", "MD_PARAMETER", "", "PAYLOAD_PARAMETER", "PAYMENT_RESULT_PARAMETER", "QUERY_STRING_RESULT", "REDIRECT_RESULT_PARAMETER", "ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

