/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.util;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.ui.core.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0004H\u0003J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/ui/core/internal/util/ThemeUtil;", "", "()V", "getAttributeColor", "", "context", "Landroid/content/Context;", "attributeColor", "getPrimaryThemeColor", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ThemeUtil {
    @NotNull
    public static final ThemeUtil INSTANCE = new ThemeUtil();

    private ThemeUtil() {
    }

    @ColorInt
    public final int getPrimaryThemeColor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getAttributeColor(context, R.attr.colorPrimary);
    }

    @ColorInt
    private final int getAttributeColor(Context context, @AttrRes int attributeColor) {
        TypedValue typedValue = new TypedValue();
        int[] nArray = new int[]{attributeColor};
        TypedArray typedArray = context.obtainStyledAttributes(typedValue.data, nArray);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        int color = typedArray2.getColor(0, 0);
        typedArray2.recycle();
        return color;
    }
}

