/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.util;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.ui.core.internal.util.ThemeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/adyen/checkout/ui/core/internal/util/PdfOpener;", "", "()V", "open", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "", "url", "", "openInBrowser", "openInCustomTab", "openInExternalApp", "Companion", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PdfOpener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = LogUtil.getTag();

    public final void open(@NotNull Context context, @NotNull String url) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Uri uri = Uri.parse((String)url);
        Intrinsics.checkNotNull((Object)uri);
        if (this.open(context, uri)) {
            return;
        }
        if (this.openInBrowser(context, uri)) {
            return;
        }
        Logger.e((String)TAG, (String)("Couldn't open pdf with url: " + uri));
        throw new IllegalStateException(("Couldn't open pdf with url: " + uri).toString());
    }

    private final boolean open(Context context, Uri uri) {
        return Build.VERSION.SDK_INT >= 30 ? (this.openInExternalApp(context, uri) ? true : this.openInCustomTab(context, uri)) : this.openInCustomTab(context, uri);
    }

    private final boolean openInExternalApp(Context context, Uri uri) {
        boolean bl;
        Intent intent;
        Intent $this$openInExternalApp_u24lambda_u240 = intent = new Intent();
        boolean bl2 = false;
        $this$openInExternalApp_u24lambda_u240.setAction("android.intent.action.VIEW");
        $this$openInExternalApp_u24lambda_u240.setDataAndType(uri, "application/pdf");
        Intent nativeAppIntent = intent;
        try {
            context.startActivity(nativeAppIntent);
            Logger.d((String)TAG, (String)"Successfully opened pdf in external app");
            bl = true;
        }
        catch (ActivityNotFoundException ex) {
            Logger.d((String)TAG, (String)"Couldn't open pdf in external app", (Throwable)ex);
            bl = false;
        }
        return bl;
    }

    private final boolean openInCustomTab(Context context, Uri uri) {
        boolean bl;
        CustomTabColorSchemeParams customTabColorSchemeParams = new CustomTabColorSchemeParams.Builder().setToolbarColor(ThemeUtil.INSTANCE.getPrimaryThemeColor(context)).build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabColorSchemeParams, (String)"build(...)");
        CustomTabColorSchemeParams defaultColors = customTabColorSchemeParams;
        try {
            new CustomTabsIntent.Builder().setShowTitle(true).setDefaultColorSchemeParams(defaultColors).build().launchUrl(context, uri);
            Logger.d((String)TAG, (String)"Successfully opened pdf in custom tab");
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            Logger.d((String)TAG, (String)"Couldn't open pdf in custom tab", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final boolean openInBrowser(Context context, Uri uri) {
        boolean bl;
        try {
            Intent intent = new Intent().setAction("android.intent.action.VIEW").addCategory("android.intent.category.BROWSABLE").addFlags(0x10000000).setData(uri);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setData(...)");
            Intent browserActivityIntent = intent;
            context.startActivity(browserActivityIntent);
            Logger.d((String)TAG, (String)"Successfully opened pdf in browser");
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            Logger.d((String)TAG, (String)"Couldn't open pdf in browser", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/ui/core/internal/util/PdfOpener$Companion;", "", "()V", "TAG", "", "ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

