/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.util;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.internal.util.AmountExtensionsKt;
import com.adyen.checkout.components.core.internal.util.CurrencyUtils;
import com.adyen.checkout.ui.core.R;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0003\u0010\u000b\u001a\u00020\f2\b\b\u0003\u0010\r\u001a\u00020\f2\b\b\u0003\u0010\u000e\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"Lcom/adyen/checkout/ui/core/internal/util/PayButtonFormatter;", "", "()V", "getPayButtonText", "", "amount", "Lcom/adyen/checkout/components/core/Amount;", "locale", "Ljava/util/Locale;", "localizedContext", "Landroid/content/Context;", "emptyAmountStringResId", "", "zeroAmountStringResId", "positiveAmountStringResId", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PayButtonFormatter {
    @NotNull
    public static final PayButtonFormatter INSTANCE = new PayButtonFormatter();

    private PayButtonFormatter() {
    }

    @NotNull
    public final String getPayButtonText(@Nullable Amount amount, @NotNull Locale locale, @NotNull Context localizedContext, @StringRes int emptyAmountStringResId, @StringRes int zeroAmountStringResId, @StringRes int positiveAmountStringResId) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        if (amount == null) {
            String string3 = localizedContext.getString(emptyAmountStringResId);
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        } else if (AmountExtensionsKt.isZero((Amount)amount)) {
            String string4 = localizedContext.getString(zeroAmountStringResId);
            Intrinsics.checkNotNull((Object)string4);
            string2 = string4;
        } else {
            Object[] objectArray = new Object[]{CurrencyUtils.INSTANCE.formatAmount(amount, locale)};
            String string5 = localizedContext.getString(positiveAmountStringResId, objectArray);
            Intrinsics.checkNotNull((Object)string5);
            string2 = string5;
        }
        return string2;
    }

    public static /* synthetic */ String getPayButtonText$default(PayButtonFormatter payButtonFormatter, Amount amount, Locale locale, Context context, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n = R.string.pay_button;
        }
        if ((n4 & 0x10) != 0) {
            n2 = R.string.confirm_preauthorization;
        }
        if ((n4 & 0x20) != 0) {
            n3 = R.string.pay_button_with_value;
        }
        return payButtonFormatter.getPayButtonText(amount, locale, context, n, n2, n3);
    }
}

