/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;
import com.adyen.checkout.ui.core.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0001*B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0015J\u0018\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0014R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010\u0015\u00a8\u0006+"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/RoundCornerImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "", "borderEnabled", "getBorderEnabled", "()Z", "setBorderEnabled", "(Z)V", "", "radius", "getRadius", "()F", "setRadius", "(F)V", "strokeColor", "getStrokeColor", "()I", "setStrokeColor", "(I)V", "strokePaint", "Landroid/graphics/Paint;", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "applyAttrs", "", "typedArrayAttrs", "Landroid/content/res/TypedArray;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "Companion", "ui-core_release"})
public final class RoundCornerImageView
extends AppCompatImageView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paint strokePaint;
    private float radius;
    private float strokeWidth;
    private int strokeColor;
    private boolean borderEnabled;
    public static final float DEFAULT_RADIUS = 9.0f;
    public static final int DEFAULT_STROKE_COLOR = -16777216;
    public static final float DEFAULT_STROKE_WIDTH = 4.0f;

    @JvmOverloads
    public RoundCornerImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.strokePaint = new Paint();
        this.borderEnabled = true;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RoundCornerImageView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArrayAttrs = typedArray;
        this.applyAttrs(typedArrayAttrs);
    }

    public /* synthetic */ RoundCornerImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float value) {
        this.radius = value;
        this.invalidate();
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(float value) {
        this.strokeWidth = value;
        this.invalidate();
    }

    public final int getStrokeColor() {
        return this.strokeColor;
    }

    public final void setStrokeColor(int value) {
        this.strokeColor = value;
        this.invalidate();
    }

    public final boolean getBorderEnabled() {
        return this.borderEnabled;
    }

    public final void setBorderEnabled(boolean value) {
        this.borderEnabled = value;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyAttrs(TypedArray typedArrayAttrs) {
        try {
            this.setStrokeColor(typedArrayAttrs.getColor(R.styleable.RoundCornerImageView_adyenStrokeColor, -16777216));
            this.setStrokeWidth(typedArrayAttrs.getDimension(R.styleable.RoundCornerImageView_adyenStrokeWidth, 4.0f));
            this.setRadius(typedArrayAttrs.getDimension(R.styleable.RoundCornerImageView_adyenRadius, 9.0f));
        }
        finally {
            typedArrayAttrs.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec + (int)this.strokeWidth * 2, heightMeasureSpec + (int)this.strokeWidth * 2);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.borderEnabled) {
            super.onDraw(canvas);
            return;
        }
        RectF rect = new RectF(this.strokeWidth / (float)2, this.strokeWidth / (float)2, (float)this.getWidth() - this.strokeWidth / (float)2, (float)this.getHeight() - this.strokeWidth / (float)2);
        this.strokePaint.reset();
        if (this.strokeWidth > 0.0f) {
            this.strokePaint.setStyle(Paint.Style.STROKE);
            this.strokePaint.setAntiAlias(true);
            this.strokePaint.setColor(this.strokeColor);
            this.strokePaint.setStrokeWidth(this.strokeWidth);
            canvas.drawRoundRect(rect, this.radius, this.radius, this.strokePaint);
        }
        Path path = new Path();
        path.addRoundRect(rect, this.radius, this.radius, Path.Direction.CW);
        canvas.clipPath(path);
        super.onDraw(canvas);
    }

    @JvmOverloads
    public RoundCornerImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public RoundCornerImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/RoundCornerImageView$Companion;", "", "()V", "DEFAULT_RADIUS", "", "DEFAULT_STROKE_COLOR", "", "DEFAULT_STROKE_WIDTH", "ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

