/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.ui.view;

import android.content.Context;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.adyen.checkout.components.core.internal.ui.model.Validation;
import com.adyen.checkout.ui.core.R;
import com.adyen.checkout.ui.core.internal.ui.AddressDelegate;
import com.adyen.checkout.ui.core.internal.ui.AddressSpecification;
import com.adyen.checkout.ui.core.internal.ui.SimpleTextListAdapter;
import com.adyen.checkout.ui.core.internal.ui.model.AddressInputModel;
import com.adyen.checkout.ui.core.internal.ui.model.AddressListItem;
import com.adyen.checkout.ui.core.internal.ui.model.AddressOutputData;
import com.adyen.checkout.ui.core.internal.ui.view.AddressFormInput;
import com.adyen.checkout.ui.core.internal.ui.view.AdyenTextInputEditText;
import com.adyen.checkout.ui.core.internal.util.ViewExtensionsKt;
import com.google.android.material.textfield.TextInputLayout;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010?\u001a\u00020@2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010A\u001a\u00020BJ\u000e\u0010C\u001a\u00020@2\u0006\u0010D\u001a\u00020EJ\u0017\u0010F\u001a\u00020@2\b\u0010G\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010HJ\u0017\u0010I\u001a\u00020@2\b\u0010G\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010HJ\u0010\u0010J\u001a\u00020@2\u0006\u0010G\u001a\u00020\u0007H\u0002J\u0010\u0010K\u001a\u00020@2\u0006\u0010L\u001a\u00020\u0013H\u0002J\b\u0010M\u001a\u00020@H\u0002J\u0017\u0010N\u001a\u00020@2\b\u0010G\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010HJ\u000e\u0010O\u001a\u00020@2\u0006\u0010'\u001a\u00020\u0003J\u0017\u0010P\u001a\u00020@2\b\u0010G\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010HJ\u0017\u0010Q\u001a\u00020@2\b\u0010G\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010HJ\u0017\u0010R\u001a\u00020@2\b\u0010G\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010HJ\u0017\u0010S\u001a\u00020@2\b\u0010G\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010HJ\u0010\u0010T\u001a\u00020@2\u0006\u0010U\u001a\u00020\u0013H\u0002J\u0010\u0010V\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u000e\u0010W\u001a\u00020@2\u0006\u0010X\u001a\u00020EJ\u0016\u0010Y\u001a\u00020@2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00110[H\u0002J\u0016\u0010\\\u001a\u00020@2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00110[H\u0002R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u0016\u0010 \u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019R\u0016\u0010\"\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u0014\u0010$\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0016\u0010-\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010,R\u0016\u0010/\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010,R\u0016\u00101\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010,R\u0016\u00103\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010,R\u0016\u00105\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010,R\u0016\u00107\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010,R\u0016\u00109\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010,R\u0014\u0010;\u001a\u00020<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\u00a8\u0006^"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/view/AddressFormInput;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "autoCompleteTextViewCountry", "Landroid/widget/AutoCompleteTextView;", "getAutoCompleteTextViewCountry", "()Landroid/widget/AutoCompleteTextView;", "autoCompleteTextViewState", "getAutoCompleteTextViewState", "countryAdapter", "Lcom/adyen/checkout/ui/core/internal/ui/SimpleTextListAdapter;", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressListItem;", "currentSpec", "Lcom/adyen/checkout/ui/core/internal/ui/AddressSpecification;", "delegate", "Lcom/adyen/checkout/ui/core/internal/ui/AddressDelegate;", "editTextApartmentSuite", "Lcom/adyen/checkout/ui/core/internal/ui/view/AdyenTextInputEditText;", "getEditTextApartmentSuite", "()Lcom/adyen/checkout/ui/core/internal/ui/view/AdyenTextInputEditText;", "editTextCity", "getEditTextCity", "editTextHouseNumber", "getEditTextHouseNumber", "editTextPostalCode", "getEditTextPostalCode", "editTextProvinceTerritory", "getEditTextProvinceTerritory", "editTextStreet", "getEditTextStreet", "formContainer", "getFormContainer", "()Landroid/widget/LinearLayout;", "localizedContext", "statesAdapter", "textInputLayoutApartmentSuite", "Lcom/google/android/material/textfield/TextInputLayout;", "getTextInputLayoutApartmentSuite", "()Lcom/google/android/material/textfield/TextInputLayout;", "textInputLayoutCity", "getTextInputLayoutCity", "textInputLayoutCountry", "getTextInputLayoutCountry", "textInputLayoutHouseNumber", "getTextInputLayoutHouseNumber", "textInputLayoutPostalCode", "getTextInputLayoutPostalCode", "textInputLayoutProvinceTerritory", "getTextInputLayoutProvinceTerritory", "textInputLayoutState", "getTextInputLayoutState", "textInputLayoutStreet", "getTextInputLayoutStreet", "textViewHeader", "Landroid/widget/TextView;", "getTextViewHeader", "()Landroid/widget/TextView;", "attachDelegate", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "highlightValidationErrors", "isErrorFocusedPreviously", "", "initApartmentSuiteInput", "styleResId", "(Ljava/lang/Integer;)V", "initCityInput", "initCountryInput", "initForm", "addressSpecification", "initHeader", "initHouseNumberInput", "initLocalizedContext", "initPostalCodeInput", "initProvinceTerritoryInput", "initStatesInput", "initStreetInput", "populateFormFields", "specification", "subscribeCountryAndStateList", "updateAddressHint", "isOptional", "updateCountries", "countryList", "", "updateStates", "stateList", "ui-core_release"})
@SourceDebugExtension(value={"SMAP\nAddressFormInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddressFormInput.kt\ncom/adyen/checkout/ui/core/internal/ui/view/AddressFormInput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,466:1\n288#2,2:467\n288#2,2:469\n1#3:471\n*S KotlinDebug\n*F\n+ 1 AddressFormInput.kt\ncom/adyen/checkout/ui/core/internal/ui/view/AddressFormInput\n*L\n211#1:467,2\n222#1:469,2\n*E\n"})
public final class AddressFormInput
extends LinearLayout {
    private Context localizedContext;
    private AddressDelegate delegate;
    @Nullable
    private AddressSpecification currentSpec;
    @NotNull
    private SimpleTextListAdapter<AddressListItem> countryAdapter;
    @NotNull
    private SimpleTextListAdapter<AddressListItem> statesAdapter;

    @JvmOverloads
    public AddressFormInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        AutoCompleteTextView autoCompleteTextView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.countryAdapter = new SimpleTextListAdapter(context);
        this.statesAdapter = new SimpleTextListAdapter(context);
        this.setOrientation(1);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        LayoutInflater.from((Context)context).inflate(R.layout.address_form_input, (ViewGroup)this, true);
        AutoCompleteTextView $this$_init__u24lambda_u241 = autoCompleteTextView = this.getAutoCompleteTextViewCountry();
        boolean bl = false;
        $this$_init__u24lambda_u241.setInputType(0);
        $this$_init__u24lambda_u241.setAdapter((ListAdapter)this.countryAdapter);
        $this$_init__u24lambda_u241.setOnItemClickListener((arg_0, arg_1, arg_2, arg_3) -> AddressFormInput.lambda$1$lambda$0(this, arg_0, arg_1, arg_2, arg_3));
    }

    public /* synthetic */ AddressFormInput(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final TextView getTextViewHeader() {
        View view = this.getRootView().findViewById(R.id.textView_header);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return (TextView)view;
    }

    private final LinearLayout getFormContainer() {
        View view = this.getRootView().findViewById(R.id.linearLayout_formContainer);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return (LinearLayout)view;
    }

    private final AutoCompleteTextView getAutoCompleteTextViewCountry() {
        View view = this.getRootView().findViewById(R.id.autoCompleteTextView_country);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return (AutoCompleteTextView)view;
    }

    private final AutoCompleteTextView getAutoCompleteTextViewState() {
        return (AutoCompleteTextView)this.getRootView().findViewById(R.id.autoCompleteTextView_state);
    }

    private final AdyenTextInputEditText getEditTextStreet() {
        return (AdyenTextInputEditText)this.getRootView().findViewById(R.id.editText_street);
    }

    private final AdyenTextInputEditText getEditTextHouseNumber() {
        return (AdyenTextInputEditText)this.getRootView().findViewById(R.id.editText_houseNumber);
    }

    private final AdyenTextInputEditText getEditTextApartmentSuite() {
        return (AdyenTextInputEditText)this.getRootView().findViewById(R.id.editText_apartmentSuite);
    }

    private final AdyenTextInputEditText getEditTextPostalCode() {
        return (AdyenTextInputEditText)this.getFormContainer().findViewById(R.id.editText_postalCode);
    }

    private final AdyenTextInputEditText getEditTextCity() {
        return (AdyenTextInputEditText)this.getRootView().findViewById(R.id.editText_city);
    }

    private final AdyenTextInputEditText getEditTextProvinceTerritory() {
        return (AdyenTextInputEditText)this.getRootView().findViewById(R.id.editText_provinceTerritory);
    }

    private final TextInputLayout getTextInputLayoutCountry() {
        return (TextInputLayout)this.getRootView().findViewById(R.id.textInputLayout_country);
    }

    private final TextInputLayout getTextInputLayoutStreet() {
        return (TextInputLayout)this.getRootView().findViewById(R.id.textInputLayout_street);
    }

    private final TextInputLayout getTextInputLayoutHouseNumber() {
        return (TextInputLayout)this.getRootView().findViewById(R.id.textInputLayout_houseNumber);
    }

    private final TextInputLayout getTextInputLayoutApartmentSuite() {
        return (TextInputLayout)this.getRootView().findViewById(R.id.textInputLayout_apartmentSuite);
    }

    private final TextInputLayout getTextInputLayoutPostalCode() {
        return (TextInputLayout)this.getFormContainer().findViewById(R.id.textInputLayout_postalCode);
    }

    private final TextInputLayout getTextInputLayoutCity() {
        return (TextInputLayout)this.getRootView().findViewById(R.id.textInputLayout_city);
    }

    private final TextInputLayout getTextInputLayoutProvinceTerritory() {
        return (TextInputLayout)this.getRootView().findViewById(R.id.textInputLayout_provinceTerritory);
    }

    private final TextInputLayout getTextInputLayoutState() {
        return (TextInputLayout)this.getRootView().findViewById(R.id.textInputLayout_state);
    }

    public final void attachDelegate(@NotNull AddressDelegate delegate, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.delegate = delegate;
        this.subscribeCountryAndStateList(coroutineScope);
    }

    private final void subscribeCountryAndStateList(CoroutineScope coroutineScope) {
        AddressDelegate addressDelegate = this.delegate;
        if (addressDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            addressDelegate = null;
        }
        FlowKt.launchIn((Flow)FlowKt.onEach(addressDelegate.getAddressOutputDataFlow(), (Function2)((Function2)new Function2<AddressOutputData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AddressFormInput this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AddressOutputData addressOutputData = (AddressOutputData)this.L$0;
                        AddressFormInput.access$updateCountries(this.this$0, addressOutputData.getCountryOptions());
                        AddressFormInput.access$updateStates(this.this$0, addressOutputData.getStateOptions());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull AddressOutputData p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    public final void initLocalizedContext(@NotNull Context localizedContext) {
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        this.localizedContext = localizedContext;
    }

    public final void highlightValidationErrors(boolean isErrorFocusedPreviously) {
        block44: {
            Validation provinceTerritoryValidation;
            AddressDelegate addressDelegate;
            Validation cityValidation;
            AddressDelegate addressDelegate2;
            Validation postalCodeValidation;
            AddressDelegate addressDelegate3;
            Validation apartmentSuiteValidation;
            AddressDelegate addressDelegate4;
            Validation houseNumberValidation;
            AddressDelegate addressDelegate5;
            Validation streetValidation;
            AddressDelegate addressDelegate6;
            Validation countryValidation;
            boolean isErrorFocused = isErrorFocusedPreviously;
            AddressDelegate addressDelegate7 = this.delegate;
            if (addressDelegate7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate7 = null;
            }
            if ((countryValidation = addressDelegate7.getAddressOutputData().getCountry().getValidation()) instanceof Validation.Invalid) {
                if (!isErrorFocused) {
                    isErrorFocused = true;
                    TextInputLayout textInputLayout = this.getTextInputLayoutCountry();
                    if (textInputLayout != null) {
                        textInputLayout.requestFocus();
                    }
                }
                TextInputLayout textInputLayout = this.getTextInputLayoutCountry();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    String string2 = context.getString(((Validation.Invalid)countryValidation).getReason());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                    ViewExtensionsKt.showError(textInputLayout, string2);
                }
            }
            if ((addressDelegate6 = this.delegate) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate6 = null;
            }
            if ((streetValidation = addressDelegate6.getAddressOutputData().getStreet().getValidation()) instanceof Validation.Invalid) {
                if (!isErrorFocused) {
                    isErrorFocused = true;
                    TextInputLayout textInputLayout = this.getTextInputLayoutStreet();
                    if (textInputLayout != null) {
                        textInputLayout.requestFocus();
                    }
                }
                TextInputLayout textInputLayout = this.getTextInputLayoutStreet();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    String string3 = context.getString(((Validation.Invalid)streetValidation).getReason());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                    ViewExtensionsKt.showError(textInputLayout, string3);
                }
            }
            if ((addressDelegate5 = this.delegate) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate5 = null;
            }
            if ((houseNumberValidation = addressDelegate5.getAddressOutputData().getHouseNumberOrName().getValidation()) instanceof Validation.Invalid) {
                if (!isErrorFocused) {
                    isErrorFocused = true;
                    TextInputLayout textInputLayout = this.getTextInputLayoutHouseNumber();
                    if (textInputLayout != null) {
                        textInputLayout.requestFocus();
                    }
                }
                TextInputLayout textInputLayout = this.getTextInputLayoutHouseNumber();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    String string4 = context.getString(((Validation.Invalid)houseNumberValidation).getReason());
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                    ViewExtensionsKt.showError(textInputLayout, string4);
                }
            }
            if ((addressDelegate4 = this.delegate) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate4 = null;
            }
            if ((apartmentSuiteValidation = addressDelegate4.getAddressOutputData().getApartmentSuite().getValidation()) instanceof Validation.Invalid) {
                if (!isErrorFocused) {
                    isErrorFocused = true;
                    TextInputLayout textInputLayout = this.getTextInputLayoutApartmentSuite();
                    if (textInputLayout != null) {
                        textInputLayout.requestFocus();
                    }
                }
                TextInputLayout textInputLayout = this.getTextInputLayoutApartmentSuite();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    String string5 = context.getString(((Validation.Invalid)apartmentSuiteValidation).getReason());
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
                    ViewExtensionsKt.showError(textInputLayout, string5);
                }
            }
            if ((addressDelegate3 = this.delegate) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate3 = null;
            }
            if ((postalCodeValidation = addressDelegate3.getAddressOutputData().getPostalCode().getValidation()) instanceof Validation.Invalid) {
                if (!isErrorFocused) {
                    isErrorFocused = true;
                    TextInputLayout textInputLayout = this.getTextInputLayoutPostalCode();
                    if (textInputLayout != null) {
                        textInputLayout.requestFocus();
                    }
                }
                TextInputLayout textInputLayout = this.getTextInputLayoutPostalCode();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    String string6 = context.getString(((Validation.Invalid)postalCodeValidation).getReason());
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(...)");
                    ViewExtensionsKt.showError(textInputLayout, string6);
                }
            }
            if ((addressDelegate2 = this.delegate) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate2 = null;
            }
            if ((cityValidation = addressDelegate2.getAddressOutputData().getCity().getValidation()) instanceof Validation.Invalid) {
                if (!isErrorFocused) {
                    isErrorFocused = true;
                    TextInputLayout textInputLayout = this.getTextInputLayoutCity();
                    if (textInputLayout != null) {
                        textInputLayout.requestFocus();
                    }
                }
                TextInputLayout textInputLayout = this.getTextInputLayoutCity();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    String string7 = context.getString(((Validation.Invalid)cityValidation).getReason());
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getString(...)");
                    ViewExtensionsKt.showError(textInputLayout, string7);
                }
            }
            if ((addressDelegate = this.delegate) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            if (!((provinceTerritoryValidation = addressDelegate.getAddressOutputData().getStateOrProvince().getValidation()) instanceof Validation.Invalid)) break block44;
            if (!isErrorFocused) {
                isErrorFocused = true;
                TextInputLayout textInputLayout = this.getTextInputLayoutProvinceTerritory();
                if (textInputLayout != null) {
                    textInputLayout.requestFocus();
                }
                TextInputLayout textInputLayout2 = this.getTextInputLayoutState();
                if (textInputLayout2 != null) {
                    textInputLayout2.requestFocus();
                }
            }
            TextInputLayout textInputLayout = this.getTextInputLayoutProvinceTerritory();
            if (textInputLayout != null) {
                Context context = this.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                String string8 = context.getString(((Validation.Invalid)provinceTerritoryValidation).getReason());
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getString(...)");
                ViewExtensionsKt.showError(textInputLayout, string8);
            }
            TextInputLayout textInputLayout3 = this.getTextInputLayoutState();
            if (textInputLayout3 != null) {
                Context context = this.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                String string9 = context.getString(((Validation.Invalid)provinceTerritoryValidation).getReason());
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getString(...)");
                ViewExtensionsKt.showError(textInputLayout3, string9);
            }
        }
    }

    private final void updateCountries(List<AddressListItem> countryList) {
        AddressListItem selectedCountry;
        Object v0;
        block2: {
            this.countryAdapter.setItems(countryList);
            Iterable $this$firstOrNull$iv = countryList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AddressListItem it = (AddressListItem)element$iv;
                boolean bl = false;
                if (!it.getSelected()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        AddressListItem addressListItem = selectedCountry = (AddressListItem)v0;
        AddressSpecification selectedSpecification = AddressSpecification.Companion.fromString(addressListItem != null ? addressListItem.getCode() : null);
        if (selectedSpecification != this.currentSpec) {
            this.currentSpec = selectedSpecification;
            AddressListItem addressListItem2 = selectedCountry;
            this.getAutoCompleteTextViewCountry().setText((CharSequence)(addressListItem2 != null ? addressListItem2.getName() : null));
            this.populateFormFields(selectedSpecification);
        }
    }

    private final void updateStates(List<AddressListItem> stateList) {
        block6: {
            boolean didStateChange;
            AddressDelegate addressDelegate;
            Object v0;
            block5: {
                this.statesAdapter.setItems(stateList);
                Iterable $this$firstOrNull$iv = stateList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AddressListItem it = (AddressListItem)element$iv;
                    boolean bl = false;
                    if (!it.getSelected()) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            AddressListItem addressListItem = v0;
            if (addressListItem == null) break block6;
            AddressListItem it = addressListItem;
            boolean bl = false;
            AutoCompleteTextView autoCompleteTextView = this.getAutoCompleteTextViewState();
            if (autoCompleteTextView != null) {
                autoCompleteTextView.setText((CharSequence)it.getName());
            }
            if ((addressDelegate = this.delegate) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            boolean bl2 = didStateChange = !Intrinsics.areEqual((Object)addressDelegate.getAddressOutputData().getStateOrProvince().getValue(), (Object)it.getCode());
            if (didStateChange) {
                AddressDelegate addressDelegate2 = this.delegate;
                if (addressDelegate2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                    addressDelegate2 = null;
                }
                addressDelegate2.updateAddressInputData((Function1<? super AddressInputModel, Unit>)((Function1)new Function1<AddressInputModel, Unit>(it){
                    final /* synthetic */ AddressListItem $it;
                    {
                        this.$it = $it;
                        super(1);
                    }

                    public final void invoke(@NotNull AddressInputModel $this$updateAddressInputData) {
                        Intrinsics.checkNotNullParameter((Object)$this$updateAddressInputData, (String)"$this$updateAddressInputData");
                        $this$updateAddressInputData.setStateOrProvince(this.$it.getCode());
                    }
                }));
            }
        }
    }

    private final void populateFormFields(AddressSpecification specification) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[specification.ordinal()]) {
            case 1: {
                n = R.layout.address_form_br;
                break;
            }
            case 2: {
                n = R.layout.address_form_ca;
                break;
            }
            case 3: {
                n = R.layout.address_form_gb;
                break;
            }
            case 4: {
                n = R.layout.address_form_us;
                break;
            }
            case 5: {
                n = R.layout.address_form_default;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int layoutResId = n;
        boolean hadFocus = this.hasFocus();
        this.getFormContainer().removeAllViews();
        LayoutInflater.from((Context)this.getContext()).inflate(layoutResId, (ViewGroup)this.getFormContainer(), true);
        this.initForm(specification);
        if (hadFocus) {
            this.requestFocus();
        }
    }

    private final void initForm(AddressSpecification addressSpecification) {
        this.initHeader();
        this.initCountryInput(addressSpecification.getCountry$ui_core_release().getStyleResId());
        AddressSpecification.AddressFieldSpec addressFieldSpec = addressSpecification.getStreet$ui_core_release();
        AddressDelegate addressDelegate = this.delegate;
        if (addressDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            addressDelegate = null;
        }
        this.initStreetInput(addressFieldSpec.getStyleResId(addressDelegate.getAddressOutputData().isOptional()));
        AddressSpecification.AddressFieldSpec addressFieldSpec2 = addressSpecification.getHouseNumber$ui_core_release();
        AddressDelegate addressDelegate2 = this.delegate;
        if (addressDelegate2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            addressDelegate2 = null;
        }
        this.initHouseNumberInput(addressFieldSpec2.getStyleResId(addressDelegate2.getAddressOutputData().isOptional()));
        AddressSpecification.AddressFieldSpec addressFieldSpec3 = addressSpecification.getApartmentSuite$ui_core_release();
        AddressDelegate addressDelegate3 = this.delegate;
        if (addressDelegate3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            addressDelegate3 = null;
        }
        this.initApartmentSuiteInput(addressFieldSpec3.getStyleResId(addressDelegate3.getAddressOutputData().isOptional()));
        AddressSpecification.AddressFieldSpec addressFieldSpec4 = addressSpecification.getPostalCode$ui_core_release();
        AddressDelegate addressDelegate4 = this.delegate;
        if (addressDelegate4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            addressDelegate4 = null;
        }
        this.initPostalCodeInput(addressFieldSpec4.getStyleResId(addressDelegate4.getAddressOutputData().isOptional()));
        AddressSpecification.AddressFieldSpec addressFieldSpec5 = addressSpecification.getCity$ui_core_release();
        AddressDelegate addressDelegate5 = this.delegate;
        if (addressDelegate5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            addressDelegate5 = null;
        }
        this.initCityInput(addressFieldSpec5.getStyleResId(addressDelegate5.getAddressOutputData().isOptional()));
        AddressSpecification.AddressFieldSpec addressFieldSpec6 = addressSpecification.getStateProvince$ui_core_release();
        AddressDelegate addressDelegate6 = this.delegate;
        if (addressDelegate6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            addressDelegate6 = null;
        }
        this.initProvinceTerritoryInput(addressFieldSpec6.getStyleResId(addressDelegate6.getAddressOutputData().isOptional()));
        AddressSpecification.AddressFieldSpec addressFieldSpec7 = addressSpecification.getStateProvince$ui_core_release();
        AddressDelegate addressDelegate7 = this.delegate;
        if (addressDelegate7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            addressDelegate7 = null;
        }
        this.initStatesInput(addressFieldSpec7.getStyleResId(addressDelegate7.getAddressOutputData().isOptional()));
    }

    private final void initHeader() {
        TextView textView = this.getTextViewHeader();
        Context context = this.localizedContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context = null;
        }
        ViewExtensionsKt.setLocalizedTextFromStyle$default(textView, R.style.AdyenCheckout_AddressForm_HeaderTextAppearance, context, false, 4, null);
    }

    private final void initCountryInput(int styleResId) {
        block1: {
            TextInputLayout textInputLayout = this.getTextInputLayoutCountry();
            if (textInputLayout == null) break block1;
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, styleResId, context);
        }
    }

    private final void initStreetInput(Integer styleResId) {
        block4: {
            AdyenTextInputEditText adyenTextInputEditText;
            Integer n = styleResId;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutStreet();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            AdyenTextInputEditText adyenTextInputEditText2 = this.getEditTextStreet();
            if (adyenTextInputEditText2 == null) break block4;
            AdyenTextInputEditText $this$initStreetInput_u24lambda_u248 = adyenTextInputEditText = adyenTextInputEditText2;
            boolean bl = false;
            AddressDelegate addressDelegate = this.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            $this$initStreetInput_u24lambda_u248.setText((CharSequence)addressDelegate.getAddressOutputData().getStreet().getValue());
            $this$initStreetInput_u24lambda_u248.setOnChangeListener(arg_0 -> AddressFormInput.initStreetInput$lambda$8$lambda$6(this, arg_0));
            $this$initStreetInput_u24lambda_u248.setOnFocusChangeListener((arg_0, arg_1) -> AddressFormInput.initStreetInput$lambda$8$lambda$7(this, arg_0, arg_1));
        }
    }

    private final void initHouseNumberInput(Integer styleResId) {
        block4: {
            AdyenTextInputEditText adyenTextInputEditText;
            Integer n = styleResId;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutHouseNumber();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            AdyenTextInputEditText adyenTextInputEditText2 = this.getEditTextHouseNumber();
            if (adyenTextInputEditText2 == null) break block4;
            AdyenTextInputEditText $this$initHouseNumberInput_u24lambda_u2412 = adyenTextInputEditText = adyenTextInputEditText2;
            boolean bl = false;
            AddressDelegate addressDelegate = this.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            $this$initHouseNumberInput_u24lambda_u2412.setText((CharSequence)addressDelegate.getAddressOutputData().getHouseNumberOrName().getValue());
            $this$initHouseNumberInput_u24lambda_u2412.setOnChangeListener(arg_0 -> AddressFormInput.initHouseNumberInput$lambda$12$lambda$10(this, arg_0));
            $this$initHouseNumberInput_u24lambda_u2412.setOnFocusChangeListener((arg_0, arg_1) -> AddressFormInput.initHouseNumberInput$lambda$12$lambda$11(this, arg_0, arg_1));
        }
    }

    private final void initApartmentSuiteInput(Integer styleResId) {
        block4: {
            AdyenTextInputEditText adyenTextInputEditText;
            Integer n = styleResId;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutApartmentSuite();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            AdyenTextInputEditText adyenTextInputEditText2 = this.getEditTextApartmentSuite();
            if (adyenTextInputEditText2 == null) break block4;
            AdyenTextInputEditText $this$initApartmentSuiteInput_u24lambda_u2416 = adyenTextInputEditText = adyenTextInputEditText2;
            boolean bl = false;
            AddressDelegate addressDelegate = this.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            $this$initApartmentSuiteInput_u24lambda_u2416.setText((CharSequence)addressDelegate.getAddressOutputData().getApartmentSuite().getValue());
            $this$initApartmentSuiteInput_u24lambda_u2416.setOnChangeListener(arg_0 -> AddressFormInput.initApartmentSuiteInput$lambda$16$lambda$14(this, arg_0));
            $this$initApartmentSuiteInput_u24lambda_u2416.setOnFocusChangeListener((arg_0, arg_1) -> AddressFormInput.initApartmentSuiteInput$lambda$16$lambda$15(this, arg_0, arg_1));
        }
    }

    private final void initPostalCodeInput(Integer styleResId) {
        block4: {
            AdyenTextInputEditText adyenTextInputEditText;
            Integer n = styleResId;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutPostalCode();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            AdyenTextInputEditText adyenTextInputEditText2 = this.getEditTextPostalCode();
            if (adyenTextInputEditText2 == null) break block4;
            AdyenTextInputEditText $this$initPostalCodeInput_u24lambda_u2420 = adyenTextInputEditText = adyenTextInputEditText2;
            boolean bl = false;
            AddressDelegate addressDelegate = this.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            $this$initPostalCodeInput_u24lambda_u2420.setText((CharSequence)addressDelegate.getAddressOutputData().getPostalCode().getValue());
            $this$initPostalCodeInput_u24lambda_u2420.setOnChangeListener(arg_0 -> AddressFormInput.initPostalCodeInput$lambda$20$lambda$18(this, arg_0));
            $this$initPostalCodeInput_u24lambda_u2420.setOnFocusChangeListener((arg_0, arg_1) -> AddressFormInput.initPostalCodeInput$lambda$20$lambda$19(this, arg_0, arg_1));
        }
    }

    private final void initCityInput(Integer styleResId) {
        block4: {
            AdyenTextInputEditText adyenTextInputEditText;
            Integer n = styleResId;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutCity();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            AdyenTextInputEditText adyenTextInputEditText2 = this.getEditTextCity();
            if (adyenTextInputEditText2 == null) break block4;
            AdyenTextInputEditText $this$initCityInput_u24lambda_u2424 = adyenTextInputEditText = adyenTextInputEditText2;
            boolean bl = false;
            AddressDelegate addressDelegate = this.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            $this$initCityInput_u24lambda_u2424.setText((CharSequence)addressDelegate.getAddressOutputData().getCity().getValue());
            $this$initCityInput_u24lambda_u2424.setOnChangeListener(arg_0 -> AddressFormInput.initCityInput$lambda$24$lambda$22(this, arg_0));
            $this$initCityInput_u24lambda_u2424.setOnFocusChangeListener((arg_0, arg_1) -> AddressFormInput.initCityInput$lambda$24$lambda$23(this, arg_0, arg_1));
        }
    }

    private final void initProvinceTerritoryInput(Integer styleResId) {
        block4: {
            AdyenTextInputEditText adyenTextInputEditText;
            Integer n = styleResId;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutProvinceTerritory();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            AdyenTextInputEditText adyenTextInputEditText2 = this.getEditTextProvinceTerritory();
            if (adyenTextInputEditText2 == null) break block4;
            AdyenTextInputEditText $this$initProvinceTerritoryInput_u24lambda_u2428 = adyenTextInputEditText = adyenTextInputEditText2;
            boolean bl = false;
            AddressDelegate addressDelegate = this.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            $this$initProvinceTerritoryInput_u24lambda_u2428.setText((CharSequence)addressDelegate.getAddressOutputData().getStateOrProvince().getValue());
            $this$initProvinceTerritoryInput_u24lambda_u2428.setOnChangeListener(arg_0 -> AddressFormInput.initProvinceTerritoryInput$lambda$28$lambda$26(this, arg_0));
            $this$initProvinceTerritoryInput_u24lambda_u2428.setOnFocusChangeListener((arg_0, arg_1) -> AddressFormInput.initProvinceTerritoryInput$lambda$28$lambda$27(this, arg_0, arg_1));
        }
    }

    private final void initStatesInput(Integer styleResId) {
        block3: {
            AutoCompleteTextView autoCompleteTextView;
            Integer n = styleResId;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutState();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            AutoCompleteTextView autoCompleteTextView2 = this.getAutoCompleteTextViewState();
            if (autoCompleteTextView2 == null) break block3;
            AutoCompleteTextView $this$initStatesInput_u24lambda_u2431 = autoCompleteTextView = autoCompleteTextView2;
            boolean bl = false;
            AddressListItem addressListItem = this.statesAdapter.getItem((Function1<AddressListItem, Boolean>)((Function1)initStatesInput.2.1.INSTANCE));
            $this$initStatesInput_u24lambda_u2431.setText((CharSequence)(addressListItem != null ? addressListItem.getName() : null));
            $this$initStatesInput_u24lambda_u2431.setInputType(0);
            $this$initStatesInput_u24lambda_u2431.setAdapter((ListAdapter)this.statesAdapter);
            $this$initStatesInput_u24lambda_u2431.setOnItemClickListener((arg_0, arg_1, arg_2, arg_3) -> AddressFormInput.initStatesInput$lambda$31$lambda$30(this, arg_0, arg_1, arg_2, arg_3));
        }
    }

    public final void updateAddressHint(boolean isOptional) {
        block21: {
            Integer statesStyleResId;
            Integer provinceTerritoryStyleResId;
            Integer cityStyleResId;
            Integer postalCodeStyleResId;
            Integer apartmentSuiteStyleResId;
            Integer houseNumberStyleResId;
            Integer streetStyleResId;
            AddressDelegate addressDelegate = this.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            AddressSpecification spec = AddressSpecification.Companion.fromString((String)addressDelegate.getAddressOutputData().getCountry().getValue());
            Integer n = streetStyleResId = spec.getStreet$ui_core_release().getStyleResId(isOptional);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutStreet();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            Integer n2 = houseNumberStyleResId = spec.getHouseNumber$ui_core_release().getStyleResId(isOptional);
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutHouseNumber();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            Integer n3 = apartmentSuiteStyleResId = spec.getApartmentSuite$ui_core_release().getStyleResId(isOptional);
            if (n3 != null) {
                int it = ((Number)n3).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutApartmentSuite();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            Integer n4 = postalCodeStyleResId = spec.getPostalCode$ui_core_release().getStyleResId(isOptional);
            if (n4 != null) {
                int it = ((Number)n4).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutPostalCode();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            Integer n5 = cityStyleResId = spec.getCity$ui_core_release().getStyleResId(isOptional);
            if (n5 != null) {
                int it = ((Number)n5).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutCity();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            Integer n6 = provinceTerritoryStyleResId = spec.getStateProvince$ui_core_release().getStyleResId(isOptional);
            if (n6 != null) {
                int it = ((Number)n6).intValue();
                boolean bl = false;
                TextInputLayout textInputLayout = this.getTextInputLayoutProvinceTerritory();
                if (textInputLayout != null) {
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
                }
            }
            Integer n7 = statesStyleResId = spec.getStateProvince$ui_core_release().getStyleResId(isOptional);
            if (n7 == null) break block21;
            int it = ((Number)n7).intValue();
            boolean bl = false;
            TextInputLayout textInputLayout = this.getTextInputLayoutState();
            if (textInputLayout != null) {
                Context context = this.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                ViewExtensionsKt.setLocalizedHintFromStyle(textInputLayout, it, context);
            }
        }
    }

    @JvmOverloads
    public AddressFormInput(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AddressFormInput(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void lambda$1$lambda$0(AddressFormInput this$0, AdapterView adapterView, View view, int position, long l) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            String selectedCountryCode = ((AddressListItem)this$0.countryAdapter.getItem(position)).getCode();
            AddressDelegate addressDelegate = this$0.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            if (!Intrinsics.areEqual((Object)addressDelegate.getAddressOutputData().getCountry().getValue(), (Object)selectedCountryCode)) {
                AddressDelegate addressDelegate2 = this$0.delegate;
                if (addressDelegate2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                    addressDelegate2 = null;
                }
                addressDelegate2.updateAddressInputData((Function1<? super AddressInputModel, Unit>)((Function1)new Function1<AddressInputModel, Unit>(selectedCountryCode){
                    final /* synthetic */ String $selectedCountryCode;
                    {
                        this.$selectedCountryCode = $selectedCountryCode;
                        super(1);
                    }

                    public final void invoke(@NotNull AddressInputModel $this$updateAddressInputData) {
                        Intrinsics.checkNotNullParameter((Object)$this$updateAddressInputData, (String)"$this$updateAddressInputData");
                        $this$updateAddressInputData.reset();
                        $this$updateAddressInputData.setCountry(this.$selectedCountryCode);
                    }
                }));
                this$0.populateFormFields(AddressSpecification.Companion.fromString(selectedCountryCode));
            }
            TextInputLayout textInputLayout = this$0.getTextInputLayoutCountry();
            if (textInputLayout == null) break block3;
            ViewExtensionsKt.hideError(textInputLayout);
        }
    }

    private static final void initStreetInput$lambda$8$lambda$6(AddressFormInput this$0, Editable it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AddressDelegate addressDelegate = this$0.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            addressDelegate.updateAddressInputData((Function1<? super AddressInputModel, Unit>)((Function1)new Function1<AddressInputModel, Unit>(it){
                final /* synthetic */ Editable $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull AddressInputModel $this$updateAddressInputData) {
                    Intrinsics.checkNotNullParameter((Object)$this$updateAddressInputData, (String)"$this$updateAddressInputData");
                    $this$updateAddressInputData.setStreet(this.$it.toString());
                }
            }));
            TextInputLayout textInputLayout = this$0.getTextInputLayoutStreet();
            if (textInputLayout == null) break block1;
            ViewExtensionsKt.hideError(textInputLayout);
        }
    }

    private static final void initStreetInput$lambda$8$lambda$7(AddressFormInput this$0, View view, boolean hasFocus) {
        block4: {
            Validation validation;
            block3: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                AddressDelegate addressDelegate = this$0.delegate;
                if (addressDelegate == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                    addressDelegate = null;
                }
                validation = addressDelegate.getAddressOutputData().getStreet().getValidation();
                if (!hasFocus) break block3;
                TextInputLayout textInputLayout = this$0.getTextInputLayoutStreet();
                if (textInputLayout == null) break block4;
                ViewExtensionsKt.hideError(textInputLayout);
                break block4;
            }
            if (!(validation instanceof Validation.Invalid)) break block4;
            TextInputLayout textInputLayout = this$0.getTextInputLayoutStreet();
            if (textInputLayout != null) {
                Context context = this$0.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                String string2 = context.getString(((Validation.Invalid)validation).getReason());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                ViewExtensionsKt.showError(textInputLayout, string2);
            }
        }
    }

    private static final void initHouseNumberInput$lambda$12$lambda$10(AddressFormInput this$0, Editable it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AddressDelegate addressDelegate = this$0.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            addressDelegate.updateAddressInputData((Function1<? super AddressInputModel, Unit>)((Function1)new Function1<AddressInputModel, Unit>(it){
                final /* synthetic */ Editable $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull AddressInputModel $this$updateAddressInputData) {
                    Intrinsics.checkNotNullParameter((Object)$this$updateAddressInputData, (String)"$this$updateAddressInputData");
                    $this$updateAddressInputData.setHouseNumberOrName(this.$it.toString());
                }
            }));
            TextInputLayout textInputLayout = this$0.getTextInputLayoutHouseNumber();
            if (textInputLayout == null) break block1;
            ViewExtensionsKt.hideError(textInputLayout);
        }
    }

    private static final void initHouseNumberInput$lambda$12$lambda$11(AddressFormInput this$0, View view, boolean hasFocus) {
        block4: {
            Validation validation;
            block3: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                AddressDelegate addressDelegate = this$0.delegate;
                if (addressDelegate == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                    addressDelegate = null;
                }
                validation = addressDelegate.getAddressOutputData().getHouseNumberOrName().getValidation();
                if (!hasFocus) break block3;
                TextInputLayout textInputLayout = this$0.getTextInputLayoutHouseNumber();
                if (textInputLayout == null) break block4;
                ViewExtensionsKt.hideError(textInputLayout);
                break block4;
            }
            if (!(validation instanceof Validation.Invalid)) break block4;
            TextInputLayout textInputLayout = this$0.getTextInputLayoutHouseNumber();
            if (textInputLayout != null) {
                Context context = this$0.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                String string2 = context.getString(((Validation.Invalid)validation).getReason());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                ViewExtensionsKt.showError(textInputLayout, string2);
            }
        }
    }

    private static final void initApartmentSuiteInput$lambda$16$lambda$14(AddressFormInput this$0, Editable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AddressDelegate addressDelegate = this$0.delegate;
        if (addressDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            addressDelegate = null;
        }
        addressDelegate.updateAddressInputData((Function1<? super AddressInputModel, Unit>)((Function1)new Function1<AddressInputModel, Unit>(it){
            final /* synthetic */ Editable $it;
            {
                this.$it = $it;
                super(1);
            }

            public final void invoke(@NotNull AddressInputModel $this$updateAddressInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateAddressInputData, (String)"$this$updateAddressInputData");
                $this$updateAddressInputData.setApartmentSuite(this.$it.toString());
            }
        }));
    }

    private static final void initApartmentSuiteInput$lambda$16$lambda$15(AddressFormInput this$0, View view, boolean hasFocus) {
        block4: {
            Validation validation;
            block3: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                AddressDelegate addressDelegate = this$0.delegate;
                if (addressDelegate == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                    addressDelegate = null;
                }
                validation = addressDelegate.getAddressOutputData().getApartmentSuite().getValidation();
                if (!hasFocus) break block3;
                TextInputLayout textInputLayout = this$0.getTextInputLayoutApartmentSuite();
                if (textInputLayout == null) break block4;
                ViewExtensionsKt.hideError(textInputLayout);
                break block4;
            }
            if (!(validation instanceof Validation.Invalid)) break block4;
            TextInputLayout textInputLayout = this$0.getTextInputLayoutApartmentSuite();
            if (textInputLayout != null) {
                Context context = this$0.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                String string2 = context.getString(((Validation.Invalid)validation).getReason());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                ViewExtensionsKt.showError(textInputLayout, string2);
            }
        }
    }

    private static final void initPostalCodeInput$lambda$20$lambda$18(AddressFormInput this$0, Editable it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AddressDelegate addressDelegate = this$0.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            addressDelegate.updateAddressInputData((Function1<? super AddressInputModel, Unit>)((Function1)new Function1<AddressInputModel, Unit>(it){
                final /* synthetic */ Editable $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull AddressInputModel $this$updateAddressInputData) {
                    Intrinsics.checkNotNullParameter((Object)$this$updateAddressInputData, (String)"$this$updateAddressInputData");
                    $this$updateAddressInputData.setPostalCode(this.$it.toString());
                }
            }));
            TextInputLayout textInputLayout = this$0.getTextInputLayoutPostalCode();
            if (textInputLayout == null) break block1;
            ViewExtensionsKt.hideError(textInputLayout);
        }
    }

    private static final void initPostalCodeInput$lambda$20$lambda$19(AddressFormInput this$0, View view, boolean hasFocus) {
        block4: {
            Validation validation;
            block3: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                AddressDelegate addressDelegate = this$0.delegate;
                if (addressDelegate == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                    addressDelegate = null;
                }
                validation = addressDelegate.getAddressOutputData().getPostalCode().getValidation();
                if (!hasFocus) break block3;
                TextInputLayout textInputLayout = this$0.getTextInputLayoutPostalCode();
                if (textInputLayout == null) break block4;
                ViewExtensionsKt.hideError(textInputLayout);
                break block4;
            }
            if (!(validation instanceof Validation.Invalid)) break block4;
            TextInputLayout textInputLayout = this$0.getTextInputLayoutPostalCode();
            if (textInputLayout != null) {
                Context context = this$0.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                String string2 = context.getString(((Validation.Invalid)validation).getReason());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                ViewExtensionsKt.showError(textInputLayout, string2);
            }
        }
    }

    private static final void initCityInput$lambda$24$lambda$22(AddressFormInput this$0, Editable it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AddressDelegate addressDelegate = this$0.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            addressDelegate.updateAddressInputData((Function1<? super AddressInputModel, Unit>)((Function1)new Function1<AddressInputModel, Unit>(it){
                final /* synthetic */ Editable $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull AddressInputModel $this$updateAddressInputData) {
                    Intrinsics.checkNotNullParameter((Object)$this$updateAddressInputData, (String)"$this$updateAddressInputData");
                    $this$updateAddressInputData.setCity(this.$it.toString());
                }
            }));
            TextInputLayout textInputLayout = this$0.getTextInputLayoutCity();
            if (textInputLayout == null) break block1;
            ViewExtensionsKt.hideError(textInputLayout);
        }
    }

    private static final void initCityInput$lambda$24$lambda$23(AddressFormInput this$0, View view, boolean hasFocus) {
        block4: {
            Validation validation;
            block3: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                AddressDelegate addressDelegate = this$0.delegate;
                if (addressDelegate == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                    addressDelegate = null;
                }
                validation = addressDelegate.getAddressOutputData().getCity().getValidation();
                if (!hasFocus) break block3;
                TextInputLayout textInputLayout = this$0.getTextInputLayoutCity();
                if (textInputLayout == null) break block4;
                ViewExtensionsKt.hideError(textInputLayout);
                break block4;
            }
            if (!(validation instanceof Validation.Invalid)) break block4;
            TextInputLayout textInputLayout = this$0.getTextInputLayoutCity();
            if (textInputLayout != null) {
                Context context = this$0.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                String string2 = context.getString(((Validation.Invalid)validation).getReason());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                ViewExtensionsKt.showError(textInputLayout, string2);
            }
        }
    }

    private static final void initProvinceTerritoryInput$lambda$28$lambda$26(AddressFormInput this$0, Editable it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AddressDelegate addressDelegate = this$0.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            addressDelegate.updateAddressInputData((Function1<? super AddressInputModel, Unit>)((Function1)new Function1<AddressInputModel, Unit>(it){
                final /* synthetic */ Editable $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull AddressInputModel $this$updateAddressInputData) {
                    Intrinsics.checkNotNullParameter((Object)$this$updateAddressInputData, (String)"$this$updateAddressInputData");
                    $this$updateAddressInputData.setStateOrProvince(this.$it.toString());
                }
            }));
            TextInputLayout textInputLayout = this$0.getTextInputLayoutProvinceTerritory();
            if (textInputLayout == null) break block1;
            ViewExtensionsKt.hideError(textInputLayout);
        }
    }

    private static final void initProvinceTerritoryInput$lambda$28$lambda$27(AddressFormInput this$0, View view, boolean hasFocus) {
        block4: {
            Validation validation;
            block3: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                AddressDelegate addressDelegate = this$0.delegate;
                if (addressDelegate == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                    addressDelegate = null;
                }
                validation = addressDelegate.getAddressOutputData().getStateOrProvince().getValidation();
                if (!hasFocus) break block3;
                TextInputLayout textInputLayout = this$0.getTextInputLayoutProvinceTerritory();
                if (textInputLayout == null) break block4;
                ViewExtensionsKt.hideError(textInputLayout);
                break block4;
            }
            if (!(validation instanceof Validation.Invalid)) break block4;
            TextInputLayout textInputLayout = this$0.getTextInputLayoutProvinceTerritory();
            if (textInputLayout != null) {
                Context context = this$0.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                String string2 = context.getString(((Validation.Invalid)validation).getReason());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                ViewExtensionsKt.showError(textInputLayout, string2);
            }
        }
    }

    private static final void initStatesInput$lambda$31$lambda$30(AddressFormInput this$0, AdapterView adapterView, View view, int position, long l) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            AddressDelegate addressDelegate = this$0.delegate;
            if (addressDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                addressDelegate = null;
            }
            addressDelegate.updateAddressInputData((Function1<? super AddressInputModel, Unit>)((Function1)new Function1<AddressInputModel, Unit>(this$0, position){
                final /* synthetic */ AddressFormInput this$0;
                final /* synthetic */ int $position;
                {
                    this.this$0 = $receiver;
                    this.$position = $position;
                    super(1);
                }

                public final void invoke(@NotNull AddressInputModel $this$updateAddressInputData) {
                    Intrinsics.checkNotNullParameter((Object)$this$updateAddressInputData, (String)"$this$updateAddressInputData");
                    $this$updateAddressInputData.setStateOrProvince(((AddressListItem)AddressFormInput.access$getStatesAdapter$p(this.this$0).getItem(this.$position)).getCode());
                }
            }));
            TextInputLayout textInputLayout = this$0.getTextInputLayoutState();
            if (textInputLayout == null) break block1;
            ViewExtensionsKt.hideError(textInputLayout);
        }
    }

    public static final /* synthetic */ void access$updateCountries(AddressFormInput $this, List countryList) {
        $this.updateCountries(countryList);
    }

    public static final /* synthetic */ void access$updateStates(AddressFormInput $this, List stateList) {
        $this.updateStates(stateList);
    }

    public static final /* synthetic */ SimpleTextListAdapter access$getStatesAdapter$p(AddressFormInput $this) {
        return $this.statesAdapter;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AddressSpecification.values().length];
            try {
                nArray[AddressSpecification.BR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressSpecification.CA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressSpecification.GB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressSpecification.US.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressSpecification.DEFAULT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

