/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.LinearLayout;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.ui.core.databinding.CountryViewBinding;
import com.adyen.checkout.ui.core.internal.ui.CountryFilter;
import com.adyen.checkout.ui.core.internal.ui.CountryViewHolder;
import com.adyen.checkout.ui.core.internal.ui.model.CountryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\rH\u0016J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/adyen/checkout/ui/core/internal/ui/CountryAdapter;", "Landroid/widget/BaseAdapter;", "Landroid/widget/Filterable;", "context", "Landroid/content/Context;", "localizedContext", "(Landroid/content/Context;Landroid/content/Context;)V", "countries", "", "Lcom/adyen/checkout/ui/core/internal/ui/model/CountryModel;", "countryFilter", "Lcom/adyen/checkout/ui/core/internal/ui/CountryFilter;", "getCount", "", "getFilter", "Landroid/widget/Filter;", "getItem", "position", "getItemId", "", "getView", "Landroid/view/View;", "convertView", "parent", "Landroid/view/ViewGroup;", "setItems", "", "", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CountryAdapter
extends BaseAdapter
implements Filterable {
    @NotNull
    private final Context context;
    @NotNull
    private final Context localizedContext;
    @NotNull
    private final List<CountryModel> countries;
    @NotNull
    private final CountryFilter countryFilter;

    public CountryAdapter(@NotNull Context context, @NotNull Context localizedContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        this.context = context;
        this.localizedContext = localizedContext;
        this.countries = new ArrayList();
        this.countryFilter = new CountryFilter(this.countries);
    }

    public final void setItems(@NotNull List<CountryModel> countries) {
        Intrinsics.checkNotNullParameter(countries, (String)"countries");
        this.countries.clear();
        this.countries.addAll((Collection<CountryModel>)countries);
        this.notifyDataSetChanged();
    }

    @NotNull
    public View getView(int position, @Nullable View convertView, @Nullable ViewGroup parent) {
        View view = null;
        CountryViewHolder viewHolder = null;
        CountryViewBinding binding = null;
        if (convertView == null) {
            CountryViewBinding countryViewBinding = CountryViewBinding.inflate(LayoutInflater.from((Context)this.context), parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)countryViewBinding, (String)"inflate(...)");
            binding = countryViewBinding;
            LinearLayout linearLayout = binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"getRoot(...)");
            view = (View)linearLayout;
            viewHolder = new CountryViewHolder(binding);
            ((LinearLayout)view).setTag((Object)viewHolder);
        } else {
            view = convertView;
            Object object = view.getTag();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.adyen.checkout.ui.core.internal.ui.CountryViewHolder");
            viewHolder = (CountryViewHolder)((Object)object);
        }
        viewHolder.bindItem(this.getItem(position));
        return view;
    }

    public int getCount() {
        return this.countries.size();
    }

    @NotNull
    public CountryModel getItem(int position) {
        return this.countries.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    @NotNull
    public Filter getFilter() {
        return this.countryFilter;
    }
}

