/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal.test;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.ui.core.internal.data.api.AddressRepository;
import com.adyen.checkout.ui.core.internal.data.model.AddressItem;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/adyen/checkout/ui/core/internal/test/TestAddressRepository;", "Lcom/adyen/checkout/ui/core/internal/data/api/AddressRepository;", "()V", "_countriesFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "Lcom/adyen/checkout/ui/core/internal/data/model/AddressItem;", "_statesFlow", "countriesFlow", "Lkotlinx/coroutines/flow/Flow;", "getCountriesFlow", "()Lkotlinx/coroutines/flow/Flow;", "shouldReturnError", "", "getShouldReturnError", "()Z", "setShouldReturnError", "(Z)V", "statesFlow", "getStatesFlow", "getCountryList", "", "shopperLocale", "Ljava/util/Locale;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getStateList", "countryCode", "", "Companion", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.TESTS})
public final class TestAddressRepository
implements AddressRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean shouldReturnError;
    @NotNull
    private final MutableSharedFlow<List<AddressItem>> _statesFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, null, (int)5, null);
    @NotNull
    private final Flow<List<AddressItem>> statesFlow = (Flow)this._statesFlow;
    @NotNull
    private final MutableSharedFlow<List<AddressItem>> _countriesFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, null, (int)5, null);
    @NotNull
    private final Flow<List<AddressItem>> countriesFlow = (Flow)this._countriesFlow;
    @NotNull
    private static final List<AddressItem> COUNTRIES;
    @NotNull
    private static final List<AddressItem> STATES;

    public final boolean getShouldReturnError() {
        return this.shouldReturnError;
    }

    public final void setShouldReturnError(boolean bl) {
        this.shouldReturnError = bl;
    }

    @Override
    @NotNull
    public Flow<List<AddressItem>> getStatesFlow() {
        return this.statesFlow;
    }

    @Override
    @NotNull
    public Flow<List<AddressItem>> getCountriesFlow() {
        return this.countriesFlow;
    }

    @Override
    public void getStateList(@NotNull Locale shopperLocale, @Nullable String countryCode, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)shopperLocale, (String)"shopperLocale");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        List<AddressItem> states = this.shouldReturnError ? CollectionsKt.emptyList() : STATES;
        this._statesFlow.tryEmit(states);
    }

    @Override
    public void getCountryList(@NotNull Locale shopperLocale, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)shopperLocale, (String)"shopperLocale");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        List<AddressItem> countries = this.shouldReturnError ? CollectionsKt.emptyList() : COUNTRIES;
        this._countriesFlow.tryEmit(countries);
    }

    static {
        AddressItem[] addressItemArray = new AddressItem[]{new AddressItem("AU", "Australia"), new AddressItem("BH", "Bahrain"), new AddressItem("BE", "Belgium"), new AddressItem("BR", "Brazil"), new AddressItem("NL", "Netherlands"), new AddressItem("US", "The United States of America")};
        COUNTRIES = CollectionsKt.listOf((Object[])addressItemArray);
        addressItemArray = new AddressItem[]{new AddressItem("CA", "California"), new AddressItem("FL", "Florida"), new AddressItem("MS", "Mississippi"), new AddressItem("BR", "Brazil"), new AddressItem("NY", "New York")};
        STATES = CollectionsKt.listOf((Object[])addressItemArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/adyen/checkout/ui/core/internal/test/TestAddressRepository$Companion;", "", "()V", "COUNTRIES", "", "Lcom/adyen/checkout/ui/core/internal/data/model/AddressItem;", "getCOUNTRIES", "()Ljava/util/List;", "STATES", "getSTATES", "ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<AddressItem> getCOUNTRIES() {
            return COUNTRIES;
        }

        @NotNull
        public final List<AddressItem> getSTATES() {
            return STATES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

