/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ui.core.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.ui.core.internal.RedirectHandler;
import com.adyen.checkout.ui.core.internal.util.ThemeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0003J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0016\u0010\u0017\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/adyen/checkout/ui/core/internal/DefaultRedirectHandler;", "Lcom/adyen/checkout/ui/core/internal/RedirectHandler;", "()V", "onRedirectListener", "Lkotlin/Function0;", "", "launchBrowser", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "launchNative", "launchNativeApi30", "launchNativeBeforeApi30", "launchUriRedirect", "url", "", "launchWithCustomTabs", "parseRedirectResult", "Lorg/json/JSONObject;", "data", "removeOnRedirectListener", "setOnRedirectListener", "listener", "Companion", "ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDefaultRedirectHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultRedirectHandler.kt\ncom/adyen/checkout/ui/core/internal/DefaultRedirectHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1#2:213\n215#3,2:214\n1549#4:216\n1620#4,3:217\n1549#4:220\n1620#4,3:221\n*S KotlinDebug\n*F\n+ 1 DefaultRedirectHandler.kt\ncom/adyen/checkout/ui/core/internal/DefaultRedirectHandler\n*L\n58#1:214,2\n99#1:216\n99#1:217,3\n106#1:220\n106#1:221,3\n*E\n"})
public final class DefaultRedirectHandler
implements RedirectHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Function0<Unit> onRedirectListener;
    @NotNull
    private static final String TAG = LogUtil.getTag();
    @NotNull
    private static final String PAYLOAD_PARAMETER = "payload";
    @NotNull
    private static final String REDIRECT_RESULT_PARAMETER = "redirectResult";
    @NotNull
    private static final String PAYMENT_RESULT_PARAMETER = "PaRes";
    @NotNull
    private static final String MD_PARAMETER = "MD";
    @NotNull
    private static final String QUERY_STRING_RESULT = "returnUrlQueryString";

    @Override
    @NotNull
    public JSONObject parseRedirectResult(@Nullable Uri data) {
        JSONObject extractedParams;
        String it;
        JSONObject jSONObject;
        Logger.d((String)TAG, (String)("parseRedirectResult - " + data));
        if (data == null) {
            throw new CheckoutException("Received a null redirect Uri", null, 2, null);
        }
        JSONObject $this$parseRedirectResult_u24lambda_u244 = jSONObject = new HashMap();
        boolean bl = false;
        String string2 = data.getQueryParameter(PAYLOAD_PARAMETER);
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            $this$parseRedirectResult_u24lambda_u244.put(PAYLOAD_PARAMETER, it);
        }
        String string3 = data.getQueryParameter(REDIRECT_RESULT_PARAMETER);
        if (string3 != null) {
            it = string3;
            boolean bl3 = false;
            $this$parseRedirectResult_u24lambda_u244.put(REDIRECT_RESULT_PARAMETER, it);
        }
        String string4 = data.getQueryParameter(PAYMENT_RESULT_PARAMETER);
        if (string4 != null) {
            String paymentResult = string4;
            boolean bl4 = false;
            String string5 = data.getQueryParameter(MD_PARAMETER);
            if (string5 != null) {
                String md = string5;
                boolean bl5 = false;
                $this$parseRedirectResult_u24lambda_u244.put(PAYMENT_RESULT_PARAMETER, paymentResult);
                $this$parseRedirectResult_u24lambda_u244.put(MD_PARAMETER, md);
            }
        }
        if ((extractedParams = jSONObject).isEmpty()) {
            String string6 = data.getEncodedQuery();
            if (string6 != null) {
                String it2 = string6;
                boolean bl6 = false;
                extractedParams.put(QUERY_STRING_RESULT, it2);
            }
        }
        if (extractedParams.isEmpty()) {
            throw new CheckoutException("Error parsing redirect result, could not any query parameters", null, 2, null);
        }
        try {
            JSONObject $this$parseRedirectResult_u24lambda_u247 = jSONObject = new JSONObject();
            boolean bl7 = false;
            Map $this$forEach$iv = (Map)extractedParams;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it3 = element$iv = iterator.next();
                boolean bl8 = false;
                $this$parseRedirectResult_u24lambda_u247.put((String)it3.getKey(), it3.getValue());
            }
            return jSONObject;
        }
        catch (JSONException e) {
            throw new CheckoutException("Error creating redirect result.", (Throwable)e);
        }
    }

    @Override
    public void launchUriRedirect(@NotNull Context context, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = url;
        if (charSequence == null || charSequence.length() == 0) {
            throw new ComponentException("Redirect URL is empty.", null, 2, null);
        }
        Uri uri = Uri.parse((String)url);
        Intrinsics.checkNotNull((Object)uri);
        if (this.launchNative(context, uri) || this.launchWithCustomTabs(context, uri) || this.launchBrowser(context, uri)) {
            Function0<Unit> function0 = this.onRedirectListener;
            if (function0 != null) {
                function0.invoke();
            }
            return;
        }
        Logger.e((String)TAG, (String)"Could not launch url");
        throw new ComponentException("Launching redirect failed.", null, 2, null);
    }

    private final boolean launchNative(Context context, Uri uri) {
        return Build.VERSION.SDK_INT >= 30 ? this.launchNativeApi30(context, uri) : this.launchNativeBeforeApi30(context, uri);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean launchNativeBeforeApi30(Context context, Uri uri) {
        boolean bl;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        PackageManager pm = context.getPackageManager();
        Intent intent = new Intent().setAction("android.intent.action.VIEW").addCategory("android.intent.category.BROWSABLE").setData(Uri.fromParts((String)"http", (String)"", null));
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setData(...)");
        Intent browserActivityIntent = intent;
        List list = pm.queryIntentActivities(browserActivityIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryIntentActivities(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ResolveInfo resolveInfo = (ResolveInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.resolvePackageName);
        }
        Set genericResolvedSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Intent intent2 = new Intent("android.intent.action.VIEW", uri).addCategory("android.intent.category.BROWSABLE");
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"addCategory(...)");
        Intent specializedActivityIntent = intent2;
        List list2 = pm.queryIntentActivities(specializedActivityIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"queryIntentActivities(...)");
        Iterable $this$map$iv2 = list2;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResolveInfo resolveInfo = (ResolveInfo)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(it.resolvePackageName);
        }
        Set resolvedSpecializedSet = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
        resolvedSpecializedSet.removeAll(genericResolvedSet);
        if (resolvedSpecializedSet.isEmpty()) {
            Logger.d((String)TAG, (String)"launchNativeBeforeApi30 - could not find native app to redirect with");
            return false;
        }
        specializedActivityIntent.addFlags(0x10000000);
        try {
            context.startActivity(specializedActivityIntent);
            Logger.d((String)TAG, (String)"launchNativeBeforeApi30 - redirect successful with native app");
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            Logger.d((String)TAG, (String)"launchNativeBeforeApi30 - could not find native app to redirect with");
            bl = false;
        }
        return bl;
    }

    @RequiresApi(value=30)
    private final boolean launchNativeApi30(Context context, Uri uri) {
        boolean bl;
        Intent intent = new Intent("android.intent.action.VIEW", uri).addCategory("android.intent.category.BROWSABLE").addFlags(0x10000400);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"addFlags(...)");
        Intent nativeAppIntent = intent;
        try {
            context.startActivity(nativeAppIntent);
            Logger.d((String)TAG, (String)"launchNativeApi30 - redirect successful with native app");
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            Logger.d((String)TAG, (String)"launchNativeApi30 - could not find native app to redirect with");
            bl = false;
        }
        return bl;
    }

    private final boolean launchWithCustomTabs(Context context, Uri uri) {
        boolean bl;
        CustomTabColorSchemeParams customTabColorSchemeParams = new CustomTabColorSchemeParams.Builder().setToolbarColor(ThemeUtil.INSTANCE.getPrimaryThemeColor(context)).build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabColorSchemeParams, (String)"build(...)");
        CustomTabColorSchemeParams defaultColors = customTabColorSchemeParams;
        try {
            new CustomTabsIntent.Builder().setShowTitle(true).setDefaultColorSchemeParams(defaultColors).build().launchUrl(context, uri);
            Logger.d((String)TAG, (String)"launchWithCustomTabs - redirect successful with custom tabs");
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            Logger.d((String)TAG, (String)"launchWithCustomTabs - device doesn't support custom tabs or chrome is disabled");
            bl = false;
        }
        return bl;
    }

    private final boolean launchBrowser(Context context, Uri uri) {
        boolean bl;
        try {
            Intent intent = new Intent().setAction("android.intent.action.VIEW").addCategory("android.intent.category.BROWSABLE").addFlags(0x10000000).setData(uri);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setData(...)");
            Intent browserActivityIntent = intent;
            context.startActivity(browserActivityIntent);
            Logger.d((String)TAG, (String)"launchBrowser - redirect successful with browser");
            bl = true;
        }
        catch (ActivityNotFoundException e) {
            Logger.d((String)TAG, (String)"launchBrowser - could not do redirect on browser or there's no browser");
            bl = false;
        }
        return bl;
    }

    @Override
    public void setOnRedirectListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.onRedirectListener = listener;
    }

    @Override
    public void removeOnRedirectListener() {
        this.onRedirectListener = null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adyen/checkout/ui/core/internal/DefaultRedirectHandler$Companion;", "", "()V", "MD_PARAMETER", "", "PAYLOAD_PARAMETER", "PAYMENT_RESULT_PARAMETER", "QUERY_STRING_RESULT", "REDIRECT_RESULT_PARAMETER", "TAG", "ui-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

