/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.sessions.core.internal.ui.model;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.internal.ui.model.SessionInstallmentConfiguration;
import com.adyen.checkout.components.core.internal.ui.model.SessionInstallmentOptionsParams;
import com.adyen.checkout.components.core.internal.ui.model.SessionParams;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.internal.util.LocaleUtil;
import com.adyen.checkout.sessions.core.CheckoutSession;
import com.adyen.checkout.sessions.core.SessionSetupConfiguration;
import com.adyen.checkout.sessions.core.SessionSetupInstallmentOptions;
import com.adyen.checkout.sessions.core.internal.data.model.SessionDetails;
import com.adyen.checkout.sessions.core.internal.data.model.SessionDetailsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\f\u0010\r\u001a\u00020\u0004*\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/adyen/checkout/sessions/core/internal/ui/model/SessionParamsFactory;", "", "()V", "create", "Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;", "checkoutSession", "Lcom/adyen/checkout/sessions/core/CheckoutSession;", "sessionDetails", "Lcom/adyen/checkout/sessions/core/internal/data/model/SessionDetails;", "getShopperLocale", "Ljava/util/Locale;", "shopperLocaleString", "", "mapToParams", "sessions-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nSessionParamsFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionParamsFactory.kt\ncom/adyen/checkout/sessions/core/internal/ui/model/SessionParamsFactory\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n*L\n1#1,68:1\n126#2:69\n153#2,3:70\n16#3,17:73\n*S KotlinDebug\n*F\n+ 1 SessionParamsFactory.kt\ncom/adyen/checkout/sessions/core/internal/ui/model/SessionParamsFactory\n*L\n41#1:69\n41#1:70,3\n63#1:73,17\n*E\n"})
public final class SessionParamsFactory {
    @NotNull
    public static final SessionParamsFactory INSTANCE = new SessionParamsFactory();

    private SessionParamsFactory() {
    }

    @NotNull
    public final SessionParams create(@NotNull CheckoutSession checkoutSession) {
        Intrinsics.checkNotNullParameter((Object)checkoutSession, (String)"checkoutSession");
        return this.mapToParams(SessionDetailsKt.mapToDetails(checkoutSession));
    }

    @NotNull
    public final SessionParams create(@NotNull SessionDetails sessionDetails) {
        Intrinsics.checkNotNullParameter((Object)sessionDetails, (String)"sessionDetails");
        return this.mapToParams(sessionDetails);
    }

    /*
     * WARNING - void declaration
     */
    private final SessionParams mapToParams(SessionDetails $this$mapToParams) {
        Map map;
        Environment environment = $this$mapToParams.getEnvironment();
        String string = $this$mapToParams.getClientKey();
        SessionSetupConfiguration sessionSetupConfiguration = $this$mapToParams.getSessionSetupConfiguration();
        Boolean bl = sessionSetupConfiguration != null ? sessionSetupConfiguration.getEnableStoreDetails() : null;
        Object object = $this$mapToParams.getSessionSetupConfiguration();
        if (object != null && (object = object.getInstallmentOptions()) != null) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object2 = object;
            Boolean bl2 = bl;
            String string2 = string;
            Environment environment2 = environment;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl3 = false;
                SessionSetupInstallmentOptions sessionSetupInstallmentOptions = (SessionSetupInstallmentOptions)((Object)it.getValue());
                SessionSetupInstallmentOptions sessionSetupInstallmentOptions2 = (SessionSetupInstallmentOptions)((Object)it.getValue());
                SessionSetupInstallmentOptions sessionSetupInstallmentOptions3 = (SessionSetupInstallmentOptions)((Object)it.getValue());
                collection.add(TuplesKt.to(it.getKey(), (Object)new SessionInstallmentOptionsParams(sessionSetupInstallmentOptions != null ? sessionSetupInstallmentOptions.getPlans() : null, sessionSetupInstallmentOptions2 != null ? sessionSetupInstallmentOptions2.getPreselectedValue() : null, sessionSetupInstallmentOptions3 != null ? sessionSetupInstallmentOptions3.getValues() : null)));
            }
            collection = (List)destination$iv$iv;
            environment = environment2;
            string = string2;
            bl = bl2;
            map = MapsKt.toMap((Iterable)collection);
        } else {
            map = null;
        }
        SessionSetupConfiguration sessionSetupConfiguration2 = $this$mapToParams.getSessionSetupConfiguration();
        Boolean bl4 = sessionSetupConfiguration2 != null ? Boolean.valueOf(sessionSetupConfiguration2.getShowInstallmentAmount()) : null;
        Map map2 = map;
        SessionSetupConfiguration sessionSetupConfiguration3 = $this$mapToParams.getSessionSetupConfiguration();
        Locale locale = this.getShopperLocale($this$mapToParams.getShopperLocale());
        String string3 = $this$mapToParams.getReturnUrl();
        Amount amount = $this$mapToParams.getAmount();
        Boolean bl5 = sessionSetupConfiguration3 != null ? sessionSetupConfiguration3.getShowRemovePaymentMethodButton() : null;
        SessionInstallmentConfiguration sessionInstallmentConfiguration = new SessionInstallmentConfiguration(map2, bl4);
        Boolean bl6 = bl;
        String string4 = string;
        Environment environment3 = environment;
        return new SessionParams(environment3, string4, bl6, sessionInstallmentConfiguration, bl5, amount, string3, locale);
    }

    /*
     * WARNING - void declaration
     */
    private final Locale getShopperLocale(String shopperLocaleString) {
        Object object;
        Object $this$getShopperLocale_u24lambda_u241;
        if (shopperLocaleString == null) {
            return null;
        }
        Object object2 = this;
        try {
            $this$getShopperLocale_u24lambda_u241 = object2;
            boolean bl = false;
            $this$getShopperLocale_u24lambda_u241 = Result.constructor-impl((Object)LocaleUtil.fromLanguageTag((String)shopperLocaleString));
        }
        catch (Throwable bl) {
            $this$getShopperLocale_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$getShopperLocale_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            SessionParamsFactory sessionParamsFactory = INSTANCE;
            AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl2 = false;
                String string2 = "Failed to parse sessions locale " + shopperLocaleString;
                adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
            }
            object = null;
        }
        return (Locale)object;
    }
}

