/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.sessions.core.internal.data.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.internal.data.model.JsonUtilsKt;
import com.adyen.checkout.core.internal.data.model.ModelObject;
import com.adyen.checkout.core.internal.data.model.ModelUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/adyen/checkout/sessions/core/internal/data/model/SessionCancelOrderRequest;", "Lcom/adyen/checkout/core/internal/data/model/ModelObject;", "sessionData", "", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "(Ljava/lang/String;Lcom/adyen/checkout/components/core/OrderRequest;)V", "getOrder", "()Lcom/adyen/checkout/components/core/OrderRequest;", "getSessionData", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "sessions-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Parcelize
public final class SessionCancelOrderRequest
extends ModelObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sessionData;
    @Nullable
    private final OrderRequest order;
    @NotNull
    public static final Parcelable.Creator<SessionCancelOrderRequest> CREATOR;
    @NotNull
    private static final String SESSION_DATA = "sessionData";
    @NotNull
    private static final String ORDER = "order";
    @JvmField
    @NotNull
    public static final ModelObject.Serializer<SessionCancelOrderRequest> SERIALIZER;

    public SessionCancelOrderRequest(@NotNull String sessionData, @Nullable OrderRequest order) {
        Intrinsics.checkNotNullParameter((Object)sessionData, (String)SESSION_DATA);
        this.sessionData = sessionData;
        this.order = order;
    }

    @NotNull
    public final String getSessionData() {
        return this.sessionData;
    }

    @Nullable
    public final OrderRequest getOrder() {
        return this.order;
    }

    @NotNull
    public final String component1() {
        return this.sessionData;
    }

    @Nullable
    public final OrderRequest component2() {
        return this.order;
    }

    @NotNull
    public final SessionCancelOrderRequest copy(@NotNull String sessionData, @Nullable OrderRequest order) {
        Intrinsics.checkNotNullParameter((Object)sessionData, (String)SESSION_DATA);
        return new SessionCancelOrderRequest(sessionData, order);
    }

    public static /* synthetic */ SessionCancelOrderRequest copy$default(SessionCancelOrderRequest sessionCancelOrderRequest, String string, OrderRequest orderRequest, int n, Object object) {
        if ((n & 1) != 0) {
            string = sessionCancelOrderRequest.sessionData;
        }
        if ((n & 2) != 0) {
            orderRequest = sessionCancelOrderRequest.order;
        }
        return sessionCancelOrderRequest.copy(string, orderRequest);
    }

    @NotNull
    public String toString() {
        return "SessionCancelOrderRequest(sessionData=" + this.sessionData + ", order=" + this.order + ")";
    }

    public int hashCode() {
        int result2 = this.sessionData.hashCode();
        result2 = result2 * 31 + (this.order == null ? 0 : this.order.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SessionCancelOrderRequest)) {
            return false;
        }
        SessionCancelOrderRequest sessionCancelOrderRequest = (SessionCancelOrderRequest)((Object)other);
        if (!Intrinsics.areEqual((Object)this.sessionData, (Object)sessionCancelOrderRequest.sessionData)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.order, (Object)sessionCancelOrderRequest.order);
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.sessionData);
        out.writeParcelable((Parcelable)this.order, flags);
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<SessionCancelOrderRequest> {
            @NotNull
            public final SessionCancelOrderRequest[] newArray(int size) {
                return new SessionCancelOrderRequest[size];
            }

            @NotNull
            public final SessionCancelOrderRequest createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new SessionCancelOrderRequest(parcel.readString(), (OrderRequest)parcel.readParcelable(SessionCancelOrderRequest.class.getClassLoader()));
            }
        }
        CREATOR = new Creator();
        SERIALIZER = (ModelObject.Serializer)new ModelObject.Serializer<SessionCancelOrderRequest>(){

            @NotNull
            public JSONObject serialize(@NotNull SessionCancelOrderRequest modelObject) {
                Intrinsics.checkNotNullParameter((Object)((Object)modelObject), (String)"modelObject");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.putOpt("sessionData", (Object)modelObject.getSessionData());
                    jsonObject.putOpt("order", (Object)ModelUtils.serializeOpt((ModelObject)((ModelObject)modelObject.getOrder()), (ModelObject.Serializer)OrderRequest.SERIALIZER));
                }
                catch (JSONException e) {
                    throw new ModelSerializationException(SessionCancelOrderRequest.class, e);
                }
                return jsonObject;
            }

            @NotNull
            public SessionCancelOrderRequest deserialize(@NotNull JSONObject jsonObject) {
                SessionCancelOrderRequest sessionCancelOrderRequest;
                Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
                try {
                    String string = JsonUtilsKt.getStringOrNull((JSONObject)jsonObject, (String)"sessionData");
                    if (string == null) {
                        string = "";
                    }
                    sessionCancelOrderRequest = new SessionCancelOrderRequest(string, (OrderRequest)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject("order"), (ModelObject.Serializer)OrderRequest.SERIALIZER));
                }
                catch (JSONException e) {
                    throw new ModelSerializationException(SessionCancelOrderRequest.class, e);
                }
                return sessionCancelOrderRequest;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/sessions/core/internal/data/model/SessionCancelOrderRequest$Companion;", "", "()V", "ORDER", "", "SERIALIZER", "Lcom/adyen/checkout/core/internal/data/model/ModelObject$Serializer;", "Lcom/adyen/checkout/sessions/core/internal/data/model/SessionCancelOrderRequest;", "SESSION_DATA", "sessions-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

