/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.sessions.core.internal.data.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.internal.data.model.JsonUtilsKt;
import com.adyen.checkout.core.internal.data.model.ModelObject;
import com.adyen.checkout.core.internal.data.model.ModelUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/adyen/checkout/sessions/core/internal/data/model/SessionBalanceResponse;", "Lcom/adyen/checkout/core/internal/data/model/ModelObject;", "sessionData", "", "balance", "Lcom/adyen/checkout/components/core/Amount;", "transactionLimit", "(Ljava/lang/String;Lcom/adyen/checkout/components/core/Amount;Lcom/adyen/checkout/components/core/Amount;)V", "getBalance", "()Lcom/adyen/checkout/components/core/Amount;", "getSessionData", "()Ljava/lang/String;", "getTransactionLimit", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "sessions-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Parcelize
public final class SessionBalanceResponse
extends ModelObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sessionData;
    @NotNull
    private final Amount balance;
    @Nullable
    private final Amount transactionLimit;
    @NotNull
    public static final Parcelable.Creator<SessionBalanceResponse> CREATOR;
    @NotNull
    private static final String SESSION_DATA = "sessionData";
    @NotNull
    private static final String BALANCE = "balance";
    @NotNull
    private static final String TRANSACTION_LIMIT = "transactionLimit";
    @JvmField
    @NotNull
    public static final ModelObject.Serializer<SessionBalanceResponse> SERIALIZER;

    public SessionBalanceResponse(@NotNull String sessionData, @NotNull Amount balance, @Nullable Amount transactionLimit) {
        Intrinsics.checkNotNullParameter((Object)sessionData, (String)SESSION_DATA);
        Intrinsics.checkNotNullParameter((Object)balance, (String)BALANCE);
        this.sessionData = sessionData;
        this.balance = balance;
        this.transactionLimit = transactionLimit;
    }

    @NotNull
    public final String getSessionData() {
        return this.sessionData;
    }

    @NotNull
    public final Amount getBalance() {
        return this.balance;
    }

    @Nullable
    public final Amount getTransactionLimit() {
        return this.transactionLimit;
    }

    @NotNull
    public final String component1() {
        return this.sessionData;
    }

    @NotNull
    public final Amount component2() {
        return this.balance;
    }

    @Nullable
    public final Amount component3() {
        return this.transactionLimit;
    }

    @NotNull
    public final SessionBalanceResponse copy(@NotNull String sessionData, @NotNull Amount balance, @Nullable Amount transactionLimit) {
        Intrinsics.checkNotNullParameter((Object)sessionData, (String)SESSION_DATA);
        Intrinsics.checkNotNullParameter((Object)balance, (String)BALANCE);
        return new SessionBalanceResponse(sessionData, balance, transactionLimit);
    }

    public static /* synthetic */ SessionBalanceResponse copy$default(SessionBalanceResponse sessionBalanceResponse, String string, Amount amount, Amount amount2, int n, Object object) {
        if ((n & 1) != 0) {
            string = sessionBalanceResponse.sessionData;
        }
        if ((n & 2) != 0) {
            amount = sessionBalanceResponse.balance;
        }
        if ((n & 4) != 0) {
            amount2 = sessionBalanceResponse.transactionLimit;
        }
        return sessionBalanceResponse.copy(string, amount, amount2);
    }

    @NotNull
    public String toString() {
        return "SessionBalanceResponse(sessionData=" + this.sessionData + ", balance=" + this.balance + ", transactionLimit=" + this.transactionLimit + ")";
    }

    public int hashCode() {
        int result2 = this.sessionData.hashCode();
        result2 = result2 * 31 + this.balance.hashCode();
        result2 = result2 * 31 + (this.transactionLimit == null ? 0 : this.transactionLimit.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SessionBalanceResponse)) {
            return false;
        }
        SessionBalanceResponse sessionBalanceResponse = (SessionBalanceResponse)((Object)other);
        if (!Intrinsics.areEqual((Object)this.sessionData, (Object)sessionBalanceResponse.sessionData)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.balance, (Object)sessionBalanceResponse.balance)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.transactionLimit, (Object)sessionBalanceResponse.transactionLimit);
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.sessionData);
        out.writeParcelable((Parcelable)this.balance, flags);
        out.writeParcelable((Parcelable)this.transactionLimit, flags);
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<SessionBalanceResponse> {
            @NotNull
            public final SessionBalanceResponse[] newArray(int size) {
                return new SessionBalanceResponse[size];
            }

            @NotNull
            public final SessionBalanceResponse createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new SessionBalanceResponse(parcel.readString(), (Amount)parcel.readParcelable(SessionBalanceResponse.class.getClassLoader()), (Amount)parcel.readParcelable(SessionBalanceResponse.class.getClassLoader()));
            }
        }
        CREATOR = new Creator();
        SERIALIZER = (ModelObject.Serializer)new ModelObject.Serializer<SessionBalanceResponse>(){

            @NotNull
            public JSONObject serialize(@NotNull SessionBalanceResponse modelObject) {
                JSONObject jSONObject;
                Intrinsics.checkNotNullParameter((Object)((Object)modelObject), (String)"modelObject");
                JSONObject $this$serialize_u24lambda_u240 = jSONObject = new JSONObject();
                boolean bl = false;
                try {
                    $this$serialize_u24lambda_u240.putOpt("sessionData", (Object)modelObject.getSessionData());
                    $this$serialize_u24lambda_u240.putOpt("balance", (Object)ModelUtils.serializeOpt((ModelObject)((ModelObject)modelObject.getBalance()), (ModelObject.Serializer)Amount.SERIALIZER));
                    $this$serialize_u24lambda_u240.putOpt("transactionLimit", (Object)ModelUtils.serializeOpt((ModelObject)((ModelObject)modelObject.getTransactionLimit()), (ModelObject.Serializer)Amount.SERIALIZER));
                }
                catch (JSONException e) {
                    throw new ModelSerializationException(SessionBalanceResponse.class, e);
                }
                return jSONObject;
            }

            @NotNull
            public SessionBalanceResponse deserialize(@NotNull JSONObject jsonObject) {
                Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
                String string = JsonUtilsKt.getStringOrNull((JSONObject)jsonObject, (String)"sessionData");
                if (string == null) {
                    string = "";
                }
                Amount amount = (Amount)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject("balance"), (ModelObject.Serializer)Amount.SERIALIZER);
                if (amount == null) {
                    throw new CheckoutException("Balance not found", null, 2, null);
                }
                return new SessionBalanceResponse(string, amount, (Amount)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject("transactionLimit"), (ModelObject.Serializer)Amount.SERIALIZER));
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adyen/checkout/sessions/core/internal/data/model/SessionBalanceResponse$Companion;", "", "()V", "BALANCE", "", "SERIALIZER", "Lcom/adyen/checkout/core/internal/data/model/ModelObject$Serializer;", "Lcom/adyen/checkout/sessions/core/internal/data/model/SessionBalanceResponse;", "SESSION_DATA", "TRANSACTION_LIMIT", "sessions-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

