/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.sessions.core.internal.data.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.paymentmethod.PaymentMethodDetails;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.internal.data.model.JsonUtilsKt;
import com.adyen.checkout.core.internal.data.model.ModelObject;
import com.adyen.checkout.core.internal.data.model.ModelUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/adyen/checkout/sessions/core/internal/data/model/SessionBalanceRequest;", "Lcom/adyen/checkout/core/internal/data/model/ModelObject;", "sessionData", "", "paymentMethod", "Lcom/adyen/checkout/components/core/paymentmethod/PaymentMethodDetails;", "amount", "Lcom/adyen/checkout/components/core/Amount;", "(Ljava/lang/String;Lcom/adyen/checkout/components/core/paymentmethod/PaymentMethodDetails;Lcom/adyen/checkout/components/core/Amount;)V", "getAmount", "()Lcom/adyen/checkout/components/core/Amount;", "getPaymentMethod", "()Lcom/adyen/checkout/components/core/paymentmethod/PaymentMethodDetails;", "getSessionData", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "sessions-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Parcelize
public final class SessionBalanceRequest
extends ModelObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sessionData;
    @Nullable
    private final PaymentMethodDetails paymentMethod;
    @Nullable
    private final Amount amount;
    @NotNull
    public static final Parcelable.Creator<SessionBalanceRequest> CREATOR;
    @NotNull
    private static final String SESSION_DATA = "sessionData";
    @NotNull
    private static final String PAYMENT_METHOD = "paymentMethod";
    @NotNull
    private static final String AMOUNT = "amount";
    @JvmField
    @NotNull
    public static final ModelObject.Serializer<SessionBalanceRequest> SERIALIZER;

    public SessionBalanceRequest(@NotNull String sessionData, @Nullable PaymentMethodDetails paymentMethod, @Nullable Amount amount) {
        Intrinsics.checkNotNullParameter((Object)sessionData, (String)SESSION_DATA);
        this.sessionData = sessionData;
        this.paymentMethod = paymentMethod;
        this.amount = amount;
    }

    @NotNull
    public final String getSessionData() {
        return this.sessionData;
    }

    @Nullable
    public final PaymentMethodDetails getPaymentMethod() {
        return this.paymentMethod;
    }

    @Nullable
    public final Amount getAmount() {
        return this.amount;
    }

    @NotNull
    public final String component1() {
        return this.sessionData;
    }

    @Nullable
    public final PaymentMethodDetails component2() {
        return this.paymentMethod;
    }

    @Nullable
    public final Amount component3() {
        return this.amount;
    }

    @NotNull
    public final SessionBalanceRequest copy(@NotNull String sessionData, @Nullable PaymentMethodDetails paymentMethod, @Nullable Amount amount) {
        Intrinsics.checkNotNullParameter((Object)sessionData, (String)SESSION_DATA);
        return new SessionBalanceRequest(sessionData, paymentMethod, amount);
    }

    public static /* synthetic */ SessionBalanceRequest copy$default(SessionBalanceRequest sessionBalanceRequest, String string, PaymentMethodDetails paymentMethodDetails, Amount amount, int n, Object object) {
        if ((n & 1) != 0) {
            string = sessionBalanceRequest.sessionData;
        }
        if ((n & 2) != 0) {
            paymentMethodDetails = sessionBalanceRequest.paymentMethod;
        }
        if ((n & 4) != 0) {
            amount = sessionBalanceRequest.amount;
        }
        return sessionBalanceRequest.copy(string, paymentMethodDetails, amount);
    }

    @NotNull
    public String toString() {
        return "SessionBalanceRequest(sessionData=" + this.sessionData + ", paymentMethod=" + this.paymentMethod + ", amount=" + this.amount + ")";
    }

    public int hashCode() {
        int result2 = this.sessionData.hashCode();
        result2 = result2 * 31 + (this.paymentMethod == null ? 0 : this.paymentMethod.hashCode());
        result2 = result2 * 31 + (this.amount == null ? 0 : this.amount.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SessionBalanceRequest)) {
            return false;
        }
        SessionBalanceRequest sessionBalanceRequest = (SessionBalanceRequest)((Object)other);
        if (!Intrinsics.areEqual((Object)this.sessionData, (Object)sessionBalanceRequest.sessionData)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)sessionBalanceRequest.paymentMethod)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.amount, (Object)sessionBalanceRequest.amount);
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.sessionData);
        out.writeParcelable((Parcelable)this.paymentMethod, flags);
        out.writeParcelable((Parcelable)this.amount, flags);
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<SessionBalanceRequest> {
            @NotNull
            public final SessionBalanceRequest[] newArray(int size) {
                return new SessionBalanceRequest[size];
            }

            @NotNull
            public final SessionBalanceRequest createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new SessionBalanceRequest(parcel.readString(), (PaymentMethodDetails)parcel.readParcelable(SessionBalanceRequest.class.getClassLoader()), (Amount)parcel.readParcelable(SessionBalanceRequest.class.getClassLoader()));
            }
        }
        CREATOR = new Creator();
        SERIALIZER = (ModelObject.Serializer)new ModelObject.Serializer<SessionBalanceRequest>(){

            @NotNull
            public JSONObject serialize(@NotNull SessionBalanceRequest modelObject) {
                Intrinsics.checkNotNullParameter((Object)((Object)modelObject), (String)"modelObject");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.putOpt("sessionData", (Object)modelObject.getSessionData());
                    jsonObject.putOpt("paymentMethod", (Object)ModelUtils.serializeOpt((ModelObject)((ModelObject)modelObject.getPaymentMethod()), (ModelObject.Serializer)PaymentMethodDetails.SERIALIZER));
                    jsonObject.putOpt("amount", (Object)ModelUtils.serializeOpt((ModelObject)((ModelObject)modelObject.getAmount()), (ModelObject.Serializer)Amount.SERIALIZER));
                }
                catch (JSONException e) {
                    throw new ModelSerializationException(SessionBalanceRequest.class, e);
                }
                return jsonObject;
            }

            @NotNull
            public SessionBalanceRequest deserialize(@NotNull JSONObject jsonObject) {
                SessionBalanceRequest sessionBalanceRequest;
                Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
                try {
                    String string = JsonUtilsKt.getStringOrNull((JSONObject)jsonObject, (String)"sessionData");
                    if (string == null) {
                        string = "";
                    }
                    sessionBalanceRequest = new SessionBalanceRequest(string, (PaymentMethodDetails)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject("paymentMethod"), (ModelObject.Serializer)PaymentMethodDetails.SERIALIZER), (Amount)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject("amount"), (ModelObject.Serializer)Amount.SERIALIZER));
                }
                catch (JSONException e) {
                    throw new ModelSerializationException(SessionBalanceRequest.class, e);
                }
                return sessionBalanceRequest;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adyen/checkout/sessions/core/internal/data/model/SessionBalanceRequest$Companion;", "", "()V", "AMOUNT", "", "PAYMENT_METHOD", "SERIALIZER", "Lcom/adyen/checkout/core/internal/data/model/ModelObject$Serializer;", "Lcom/adyen/checkout/sessions/core/internal/data/model/SessionBalanceRequest;", "SESSION_DATA", "sessions-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

