/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.sessions.core.internal;

import androidx.annotation.RestrictTo;
import androidx.lifecycle.SavedStateHandle;
import com.adyen.checkout.components.core.internal.SavedStateHandleContainer;
import com.adyen.checkout.components.core.internal.SavedStateHandleProperty;
import com.adyen.checkout.sessions.core.CheckoutSession;
import com.adyen.checkout.sessions.core.SessionModel;
import com.adyen.checkout.sessions.core.internal.data.model.SessionDetails;
import com.adyen.checkout.sessions.core.internal.data.model.SessionDetailsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR/\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R/\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\u00118B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u000e\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcom/adyen/checkout/sessions/core/internal/SessionSavedStateHandleContainer;", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleContainer;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "checkoutSession", "Lcom/adyen/checkout/sessions/core/CheckoutSession;", "(Landroidx/lifecycle/SavedStateHandle;Lcom/adyen/checkout/sessions/core/CheckoutSession;)V", "<set-?>", "", "isFlowTakenOver", "()Ljava/lang/Boolean;", "setFlowTakenOver", "(Ljava/lang/Boolean;)V", "isFlowTakenOver$delegate", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleProperty;", "getSavedStateHandle", "()Landroidx/lifecycle/SavedStateHandle;", "Lcom/adyen/checkout/sessions/core/internal/data/model/SessionDetails;", "sessionDetails", "getSessionDetails", "()Lcom/adyen/checkout/sessions/core/internal/data/model/SessionDetails;", "setSessionDetails", "(Lcom/adyen/checkout/sessions/core/internal/data/model/SessionDetails;)V", "sessionDetails$delegate", "getSessionModel", "Lcom/adyen/checkout/sessions/core/SessionModel;", "updateSessionData", "", "sessionData", "", "Companion", "sessions-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SessionSavedStateHandleContainer
implements SavedStateHandleContainer {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final SavedStateHandleProperty sessionDetails$delegate;
    @NotNull
    private final SavedStateHandleProperty isFlowTakenOver$delegate;
    @NotNull
    private static final String SESSION_KEY = "SESSION_KEY";
    @NotNull
    private static final String IS_SESSIONS_FLOW_TAKEN_OVER_KEY = "IS_SESSIONS_FLOW_TAKEN_OVER_KEY";

    public SessionSavedStateHandleContainer(@NotNull SavedStateHandle savedStateHandle, @NotNull CheckoutSession checkoutSession) {
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)checkoutSession, (String)"checkoutSession");
        this.savedStateHandle = savedStateHandle;
        this.sessionDetails$delegate = new SavedStateHandleProperty(SESSION_KEY);
        this.isFlowTakenOver$delegate = new SavedStateHandleProperty(IS_SESSIONS_FLOW_TAKEN_OVER_KEY);
        if (this.getSessionDetails() == null) {
            this.setSessionDetails(SessionDetailsKt.mapToDetails(checkoutSession));
        }
        if (this.isFlowTakenOver() == null) {
            this.setFlowTakenOver(false);
        }
    }

    @NotNull
    public SavedStateHandle getSavedStateHandle() {
        return this.savedStateHandle;
    }

    private final SessionDetails getSessionDetails() {
        return (SessionDetails)this.sessionDetails$delegate.getValue((SavedStateHandleContainer)this, $$delegatedProperties[0]);
    }

    private final void setSessionDetails(SessionDetails sessionDetails) {
        this.sessionDetails$delegate.setValue((SavedStateHandleContainer)this, $$delegatedProperties[0], (Object)sessionDetails);
    }

    @Nullable
    public final Boolean isFlowTakenOver() {
        return (Boolean)this.isFlowTakenOver$delegate.getValue((SavedStateHandleContainer)this, $$delegatedProperties[1]);
    }

    public final void setFlowTakenOver(@Nullable Boolean bl) {
        this.isFlowTakenOver$delegate.setValue((SavedStateHandleContainer)this, $$delegatedProperties[1], (Object)bl);
    }

    public final void updateSessionData(@NotNull String sessionData) {
        Intrinsics.checkNotNullParameter((Object)sessionData, (String)"sessionData");
        SessionDetails sessionDetails = this.getSessionDetails();
        this.setSessionDetails(sessionDetails != null ? SessionDetails.copy$default(sessionDetails, null, sessionData, null, null, null, null, null, null, null, 509, null) : null);
    }

    @NotNull
    public final SessionModel getSessionModel() {
        SessionDetails sessionDetails = this.getSessionDetails();
        if (sessionDetails == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return SessionDetailsKt.mapToModel(sessionDetails);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SessionSavedStateHandleContainer.class, "sessionDetails", "getSessionDetails()Lcom/adyen/checkout/sessions/core/internal/data/model/SessionDetails;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SessionSavedStateHandleContainer.class, "isFlowTakenOver", "isFlowTakenOver()Ljava/lang/Boolean;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/adyen/checkout/sessions/core/internal/SessionSavedStateHandleContainer$Companion;", "", "()V", "IS_SESSIONS_FLOW_TAKEN_OVER_KEY", "", "SESSION_KEY", "sessions-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

