/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.sessions.core;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.CheckoutConfiguration;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.PaymentMethodsApiResponse;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.sessions.core.SessionSetupResponse;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\nJ\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/adyen/checkout/sessions/core/CheckoutSession;", "", "sessionSetupResponse", "Lcom/adyen/checkout/sessions/core/SessionSetupResponse;", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "Lcom/adyen/checkout/components/core/Order;", "environment", "Lcom/adyen/checkout/core/Environment;", "clientKey", "", "(Lcom/adyen/checkout/sessions/core/SessionSetupResponse;Lcom/adyen/checkout/components/core/OrderRequest;Lcom/adyen/checkout/core/Environment;Ljava/lang/String;)V", "getClientKey", "()Ljava/lang/String;", "getEnvironment", "()Lcom/adyen/checkout/core/Environment;", "getOrder", "()Lcom/adyen/checkout/components/core/OrderRequest;", "getSessionSetupResponse", "()Lcom/adyen/checkout/sessions/core/SessionSetupResponse;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getConfiguration", "Lcom/adyen/checkout/components/core/CheckoutConfiguration;", "getPaymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "paymentMethodType", "hashCode", "", "toString", "sessions-core_release"})
@SourceDebugExtension(value={"SMAP\nCheckoutSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckoutSession.kt\ncom/adyen/checkout/sessions/core/CheckoutSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n295#2,2:42\n*S KotlinDebug\n*F\n+ 1 CheckoutSession.kt\ncom/adyen/checkout/sessions/core/CheckoutSession\n*L\n28#1:42,2\n*E\n"})
public final class CheckoutSession {
    @NotNull
    private final SessionSetupResponse sessionSetupResponse;
    @Nullable
    private final OrderRequest order;
    @NotNull
    private final Environment environment;
    @NotNull
    private final String clientKey;

    public CheckoutSession(@NotNull SessionSetupResponse sessionSetupResponse, @Nullable OrderRequest order, @NotNull Environment environment, @NotNull String clientKey) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionSetupResponse), (String)"sessionSetupResponse");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        this.sessionSetupResponse = sessionSetupResponse;
        this.order = order;
        this.environment = environment;
        this.clientKey = clientKey;
    }

    @NotNull
    public final SessionSetupResponse getSessionSetupResponse() {
        return this.sessionSetupResponse;
    }

    @Nullable
    public final OrderRequest getOrder() {
        return this.order;
    }

    @NotNull
    public final Environment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final String getClientKey() {
        return this.clientKey;
    }

    @Nullable
    public final PaymentMethod getPaymentMethod(@NotNull String paymentMethodType) {
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)paymentMethodType, (String)"paymentMethodType");
            PaymentMethodsApiResponse paymentMethodsApiResponse = this.sessionSetupResponse.getPaymentMethodsApiResponse();
            List list = paymentMethodsApiResponse != null ? paymentMethodsApiResponse.getPaymentMethods() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PaymentMethod it = (PaymentMethod)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)paymentMethodType)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final CheckoutConfiguration getConfiguration() {
        return new CheckoutConfiguration(this.environment, this.clientKey, null, null, null, null, 60, null);
    }

    @NotNull
    public final SessionSetupResponse component1() {
        return this.sessionSetupResponse;
    }

    @Nullable
    public final OrderRequest component2() {
        return this.order;
    }

    @NotNull
    public final Environment component3() {
        return this.environment;
    }

    @NotNull
    public final String component4() {
        return this.clientKey;
    }

    @NotNull
    public final CheckoutSession copy(@NotNull SessionSetupResponse sessionSetupResponse, @Nullable OrderRequest order, @NotNull Environment environment, @NotNull String clientKey) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionSetupResponse), (String)"sessionSetupResponse");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        return new CheckoutSession(sessionSetupResponse, order, environment, clientKey);
    }

    public static /* synthetic */ CheckoutSession copy$default(CheckoutSession checkoutSession, SessionSetupResponse sessionSetupResponse, OrderRequest orderRequest, Environment environment, String string, int n, Object object) {
        if ((n & 1) != 0) {
            sessionSetupResponse = checkoutSession.sessionSetupResponse;
        }
        if ((n & 2) != 0) {
            orderRequest = checkoutSession.order;
        }
        if ((n & 4) != 0) {
            environment = checkoutSession.environment;
        }
        if ((n & 8) != 0) {
            string = checkoutSession.clientKey;
        }
        return checkoutSession.copy(sessionSetupResponse, orderRequest, environment, string);
    }

    @NotNull
    public String toString() {
        return "CheckoutSession(sessionSetupResponse=" + this.sessionSetupResponse + ", order=" + this.order + ", environment=" + this.environment + ", clientKey=" + this.clientKey + ")";
    }

    public int hashCode() {
        int result2 = this.sessionSetupResponse.hashCode();
        result2 = result2 * 31 + (this.order == null ? 0 : this.order.hashCode());
        result2 = result2 * 31 + this.environment.hashCode();
        result2 = result2 * 31 + this.clientKey.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CheckoutSession)) {
            return false;
        }
        CheckoutSession checkoutSession = (CheckoutSession)other;
        if (!Intrinsics.areEqual((Object)((Object)this.sessionSetupResponse), (Object)((Object)checkoutSession.sessionSetupResponse))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.order, (Object)checkoutSession.order)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.environment, (Object)checkoutSession.environment)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.clientKey, (Object)checkoutSession.clientKey);
    }
}

