/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.ideal.internal.ui;

import androidx.lifecycle.LifecycleOwner;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.components.core.PaymentComponentData;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.components.core.internal.PaymentObserverRepository;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsEvent;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsManager;
import com.adyen.checkout.components.core.internal.analytics.GenericEvents;
import com.adyen.checkout.components.core.internal.ui.model.GenericComponentParams;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.components.core.paymentmethod.IdealPaymentMethod;
import com.adyen.checkout.components.core.paymentmethod.PaymentMethodDetails;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.ideal.IdealComponentState;
import com.adyen.checkout.ideal.internal.ui.IdealDelegate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001b\u001a\u00020\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J2\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0018\u0010&\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120(\u0012\u0004\u0012\u00020\u001f0'H\u0016J\b\u0010)\u001a\u00020\u001fH\u0016J\b\u0010*\u001a\u00020\u001fH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Lcom/adyen/checkout/ideal/internal/ui/DefaultIdealDelegate;", "Lcom/adyen/checkout/ideal/internal/ui/IdealDelegate;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "Lcom/adyen/checkout/components/core/Order;", "componentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;", "analyticsManager", "Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;", "(Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;Lcom/adyen/checkout/components/core/PaymentMethod;Lcom/adyen/checkout/components/core/OrderRequest;Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;)V", "getComponentParams", "()Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;", "componentStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/adyen/checkout/ideal/IdealComponentState;", "getComponentStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "submitChannel", "Lkotlinx/coroutines/channels/Channel;", "submitFlow", "Lkotlinx/coroutines/flow/Flow;", "getSubmitFlow", "()Lkotlinx/coroutines/flow/Flow;", "createComponentState", "getPaymentMethodType", "", "initialize", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "initializeAnalytics", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/PaymentComponentEvent;", "onCleared", "removeObserver", "ideal_release"})
@SourceDebugExtension(value={"SMAP\nDefaultIdealDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultIdealDelegate.kt\ncom/adyen/checkout/ideal/internal/ui/DefaultIdealDelegate\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n*L\n1#1,105:1\n16#2,17:106\n*S KotlinDebug\n*F\n+ 1 DefaultIdealDelegate.kt\ncom/adyen/checkout/ideal/internal/ui/DefaultIdealDelegate\n*L\n55#1:106,17\n*E\n"})
public final class DefaultIdealDelegate
implements IdealDelegate {
    @NotNull
    private final PaymentObserverRepository observerRepository;
    @NotNull
    private final PaymentMethod paymentMethod;
    @Nullable
    private final OrderRequest order;
    @NotNull
    private final GenericComponentParams componentParams;
    @NotNull
    private final AnalyticsManager analyticsManager;
    @NotNull
    private final StateFlow<IdealComponentState> componentStateFlow;
    @NotNull
    private final Channel<IdealComponentState> submitChannel;
    @NotNull
    private final Flow<IdealComponentState> submitFlow;

    public DefaultIdealDelegate(@NotNull PaymentObserverRepository observerRepository, @NotNull PaymentMethod paymentMethod, @Nullable OrderRequest order, @NotNull GenericComponentParams componentParams, @NotNull AnalyticsManager analyticsManager) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)analyticsManager, (String)"analyticsManager");
        this.observerRepository = observerRepository;
        this.paymentMethod = paymentMethod;
        this.order = order;
        this.componentParams = componentParams;
        this.analyticsManager = analyticsManager;
        this.componentStateFlow = (StateFlow)StateFlowKt.MutableStateFlow((Object)this.createComponentState());
        this.submitChannel = ChannelExtensionsKt.bufferedChannel();
        this.submitFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.submitChannel));
        this.submitChannel.trySend-JP2dKIU(this.getComponentStateFlow().getValue());
    }

    @NotNull
    public GenericComponentParams getComponentParams() {
        return this.componentParams;
    }

    @NotNull
    public StateFlow<IdealComponentState> getComponentStateFlow() {
        return this.componentStateFlow;
    }

    @NotNull
    public Flow<IdealComponentState> getSubmitFlow() {
        return this.submitFlow;
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.initializeAnalytics(coroutineScope);
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeAnalytics(CoroutineScope coroutineScope) {
        DefaultIdealDelegate defaultIdealDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "initializeAnalytics";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        this.analyticsManager.initialize((Object)this, coroutineScope);
        String string = this.paymentMethod.getType();
        if (string == null) {
            string = "";
        }
        AnalyticsEvent.Info renderedEvent = GenericEvents.rendered$default((GenericEvents)GenericEvents.INSTANCE, (String)string, null, null, null, (int)14, null);
        this.analyticsManager.trackEvent((AnalyticsEvent)renderedEvent);
        String string3 = this.paymentMethod.getType();
        if (string3 == null) {
            string3 = "";
        }
        AnalyticsEvent.Log submitEvent = GenericEvents.INSTANCE.submit(string3);
        this.analyticsManager.trackEvent((AnalyticsEvent)submitEvent);
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super PaymentComponentEvent<IdealComponentState>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers((Flow)this.getComponentStateFlow(), null, this.getSubmitFlow(), lifecycleOwner, coroutineScope, callback);
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    private final IdealComponentState createComponentState() {
        PaymentComponentData paymentComponentData = new PaymentComponentData((PaymentMethodDetails)new IdealPaymentMethod(this.paymentMethod.getType(), this.analyticsManager.getCheckoutAttemptId(), null), this.order, this.getComponentParams().getAmount(), null, null, null, null, null, null, null, null, null, null, null, 16376, null);
        return new IdealComponentState((PaymentComponentData<IdealPaymentMethod>)paymentComponentData, true, true);
    }

    @NotNull
    public String getPaymentMethodType() {
        String string = this.paymentMethod.getType();
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    public void onCleared() {
        this.removeObserver();
        this.analyticsManager.clear((Object)this);
    }
}

