/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.googlepay.internal.ui.model;

import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.Configuration;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.internal.ui.model.AnalyticsParams;
import com.adyen.checkout.components.core.internal.ui.model.ComponentParams;
import com.adyen.checkout.components.core.internal.ui.model.SessionParams;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.googlepay.AllowedAuthMethods;
import com.adyen.checkout.googlepay.AllowedCardNetworks;
import com.adyen.checkout.googlepay.BillingAddressParameters;
import com.adyen.checkout.googlepay.GooglePayConfiguration;
import com.adyen.checkout.googlepay.MerchantInfo;
import com.adyen.checkout.googlepay.ShippingAddressParameters;
import com.adyen.checkout.googlepay.internal.ui.model.GooglePayComponentParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u0011H\u0002J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0011H\u0002J\u0014\u0010\u0017\u001a\u00020\t*\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u0018\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0019\u001a\u00020\u000f*\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\u000f*\u00020\u000f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParamsMapper;", "", "overrideComponentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;", "overrideSessionParams", "Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;", "(Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;)V", "getAvailableCardNetworksFromApi", "", "", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "mapBrandToGooglePayNetwork", "brand", "mapToParams", "Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParams;", "googlePayConfiguration", "Lcom/adyen/checkout/googlepay/GooglePayConfiguration;", "sessionParams", "getAvailableAuthMethods", "getAvailableCardNetworks", "getGooglePayEnvironment", "", "getPreferredGatewayMerchantId", "mapToParamsInternal", "override", "Companion", "googlepay_release"})
@SourceDebugExtension(value={"SMAP\nGooglePayComponentParamsMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GooglePayComponentParamsMapper.kt\ncom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParamsMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1603#2,9:153\n1855#2:162\n1856#2:164\n1612#2:165\n1#3:163\n*S KotlinDebug\n*F\n+ 1 GooglePayComponentParamsMapper.kt\ncom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParamsMapper\n*L\n101#1:153,9\n101#1:162\n101#1:164\n101#1:165\n101#1:163\n*E\n"})
public final class GooglePayComponentParamsMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ComponentParams overrideComponentParams;
    @Nullable
    private final SessionParams overrideSessionParams;
    @NotNull
    private static final String TAG = LogUtil.getTag();
    @NotNull
    private static final Amount DEFAULT_AMOUNT = new Amount("USD", 0L);
    @NotNull
    private static final String DEFAULT_TOTAL_PRICE_STATUS = "FINAL";

    public GooglePayComponentParamsMapper(@Nullable ComponentParams overrideComponentParams, @Nullable SessionParams overrideSessionParams) {
        this.overrideComponentParams = overrideComponentParams;
        this.overrideSessionParams = overrideSessionParams;
    }

    @NotNull
    public final GooglePayComponentParams mapToParams(@NotNull GooglePayConfiguration googlePayConfiguration, @NotNull PaymentMethod paymentMethod, @Nullable SessionParams sessionParams) {
        Intrinsics.checkNotNullParameter((Object)googlePayConfiguration, (String)"googlePayConfiguration");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        GooglePayComponentParams googlePayComponentParams = this.override(this.mapToParamsInternal(googlePayConfiguration, paymentMethod), this.overrideComponentParams);
        SessionParams sessionParams2 = sessionParams;
        if (sessionParams2 == null) {
            sessionParams2 = this.overrideSessionParams;
        }
        return this.override(googlePayComponentParams, sessionParams2);
    }

    private final GooglePayComponentParams mapToParamsInternal(GooglePayConfiguration $this$mapToParamsInternal, PaymentMethod paymentMethod) {
        String string;
        Amount amount;
        Locale locale = $this$mapToParamsInternal.getShopperLocale();
        Environment environment = $this$mapToParamsInternal.getEnvironment();
        String string2 = $this$mapToParamsInternal.getClientKey();
        AnalyticsParams analyticsParams = new AnalyticsParams($this$mapToParamsInternal.getAnalyticsConfiguration());
        String string3 = this.getPreferredGatewayMerchantId($this$mapToParamsInternal, paymentMethod);
        List<String> list = this.getAvailableAuthMethods($this$mapToParamsInternal);
        List<String> list2 = this.getAvailableCardNetworks($this$mapToParamsInternal, paymentMethod);
        int n = this.getGooglePayEnvironment($this$mapToParamsInternal);
        Amount amount2 = $this$mapToParamsInternal.getAmount();
        if (amount2 == null) {
            amount2 = amount = DEFAULT_AMOUNT;
        }
        if ((string = $this$mapToParamsInternal.getTotalPriceStatus()) == null) {
            string = DEFAULT_TOTAL_PRICE_STATUS;
        }
        String string4 = string;
        String string5 = $this$mapToParamsInternal.getCountryCode();
        MerchantInfo merchantInfo = $this$mapToParamsInternal.getMerchantInfo();
        Boolean bl = $this$mapToParamsInternal.isAllowPrepaidCards();
        boolean bl2 = bl != null ? bl : false;
        Boolean bl3 = $this$mapToParamsInternal.isAllowCreditCards();
        Boolean bl4 = $this$mapToParamsInternal.isAssuranceDetailsRequired();
        Boolean bl5 = $this$mapToParamsInternal.isEmailRequired();
        boolean bl6 = bl5 != null ? bl5 : false;
        Boolean bl7 = $this$mapToParamsInternal.isExistingPaymentMethodRequired();
        boolean bl8 = bl7 != null ? bl7 : false;
        Boolean bl9 = $this$mapToParamsInternal.isShippingAddressRequired();
        boolean bl10 = bl9 != null ? bl9 : false;
        ShippingAddressParameters shippingAddressParameters = $this$mapToParamsInternal.getShippingAddressParameters();
        Boolean bl11 = $this$mapToParamsInternal.isBillingAddressRequired();
        boolean bl12 = bl11 != null ? bl11 : false;
        BillingAddressParameters billingAddressParameters = $this$mapToParamsInternal.getBillingAddressParameters();
        return new GooglePayComponentParams(locale, environment, string2, analyticsParams, false, amount, string3, n, string4, string5, merchantInfo, list, list2, bl2, bl3, bl4, bl6, bl8, bl10, shippingAddressParameters, bl12, billingAddressParameters);
    }

    private final String getPreferredGatewayMerchantId(GooglePayConfiguration $this$getPreferredGatewayMerchantId, PaymentMethod paymentMethod) {
        String string = $this$getPreferredGatewayMerchantId.getMerchantAccount();
        if (string == null) {
            Configuration configuration = paymentMethod.getConfiguration();
            string = configuration != null ? configuration.getGatewayMerchantId() : null;
            if (string == null) {
                throw new ComponentException("GooglePay merchantAccount not found. Update your API version or pass it manually inside your GooglePayConfiguration", null, 2, null);
            }
        }
        return string;
    }

    private final List<String> getAvailableAuthMethods(GooglePayConfiguration $this$getAvailableAuthMethods) {
        List<String> list = $this$getAvailableAuthMethods.getAllowedAuthMethods();
        if (list == null) {
            list = AllowedAuthMethods.INSTANCE.getAllAllowedAuthMethods$googlepay_release();
        }
        return list;
    }

    private final List<String> getAvailableCardNetworks(GooglePayConfiguration $this$getAvailableCardNetworks, PaymentMethod paymentMethod) {
        List<String> list = $this$getAvailableCardNetworks.getAllowedCardNetworks();
        if (list == null && (list = this.getAvailableCardNetworksFromApi(paymentMethod)) == null) {
            list = AllowedCardNetworks.INSTANCE.getAllAllowedCardNetworks$googlepay_release();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAvailableCardNetworksFromApi(PaymentMethod paymentMethod) {
        void $this$mapNotNullTo$iv$iv;
        List list = paymentMethod.getBrands();
        if (list == null) {
            return null;
        }
        List brands = list;
        Iterable $this$mapNotNull$iv = brands;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String brand = (String)element$iv$iv;
            boolean bl2 = false;
            String network = this.mapBrandToGooglePayNetwork(brand);
            if (network == null) {
                Logger.e((String)TAG, (String)("skipping brand " + brand + ", as it is not an allowed card network."));
            }
            if (network == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String mapBrandToGooglePayNetwork(String brand) {
        String string;
        if (Intrinsics.areEqual((Object)brand, (Object)"mc")) {
            string = "MASTERCARD";
        } else {
            List<String> list = AllowedCardNetworks.INSTANCE.getAllAllowedCardNetworks$googlepay_release();
            String string2 = brand.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            if (list.contains(string2)) {
                String string3 = brand.toUpperCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            } else {
                string = null;
            }
        }
        return string;
    }

    private final int getGooglePayEnvironment(GooglePayConfiguration $this$getGooglePayEnvironment) {
        return $this$getGooglePayEnvironment.getGooglePayEnvironment() != null ? $this$getGooglePayEnvironment.getGooglePayEnvironment() : (Intrinsics.areEqual((Object)$this$getGooglePayEnvironment.getEnvironment(), (Object)Environment.TEST) ? 3 : 1);
    }

    private final GooglePayComponentParams override(GooglePayComponentParams $this$override, ComponentParams overrideComponentParams) {
        if (overrideComponentParams == null) {
            return $this$override;
        }
        Amount amount = overrideComponentParams.getAmount();
        if (amount == null) {
            amount = DEFAULT_AMOUNT;
        }
        Amount amount2 = amount;
        return GooglePayComponentParams.copy$default($this$override, overrideComponentParams.getShopperLocale(), overrideComponentParams.getEnvironment(), overrideComponentParams.getClientKey(), overrideComponentParams.getAnalyticsParams(), overrideComponentParams.isCreatedByDropIn(), amount2, null, 0, null, null, null, null, null, false, null, null, false, false, false, null, false, null, 4194240, null);
    }

    private final GooglePayComponentParams override(GooglePayComponentParams $this$override, SessionParams sessionParams) {
        if (sessionParams == null) {
            return $this$override;
        }
        Amount amount = sessionParams.getAmount();
        if (amount == null) {
            amount = $this$override.getAmount();
        }
        return GooglePayComponentParams.copy$default($this$override, null, null, null, null, false, amount, null, 0, null, null, null, null, null, false, null, null, false, false, false, null, false, null, 0x3FFFDF, null);
    }

    static /* synthetic */ GooglePayComponentParams override$default(GooglePayComponentParamsMapper googlePayComponentParamsMapper, GooglePayComponentParams googlePayComponentParams, SessionParams sessionParams, int n, Object object) {
        if ((n & 1) != 0) {
            sessionParams = null;
        }
        return googlePayComponentParamsMapper.override(googlePayComponentParams, sessionParams);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParamsMapper$Companion;", "", "()V", "DEFAULT_AMOUNT", "Lcom/adyen/checkout/components/core/Amount;", "DEFAULT_TOTAL_PRICE_STATUS", "", "TAG", "googlepay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

