/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.googlepay.internal.ui;

import android.app.Activity;
import android.content.Intent;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LifecycleOwner;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.components.core.PaymentComponentData;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.components.core.internal.PaymentObserverRepository;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsRepository;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.components.core.paymentmethod.GooglePayPaymentMethod;
import com.adyen.checkout.components.core.paymentmethod.PaymentMethodDetails;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.data.model.ModelUtils;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.googlepay.GooglePayButtonParameters;
import com.adyen.checkout.googlepay.GooglePayComponentState;
import com.adyen.checkout.googlepay.internal.data.model.GooglePayPaymentMethodModel;
import com.adyen.checkout.googlepay.internal.ui.GooglePayDelegate;
import com.adyen.checkout.googlepay.internal.ui.model.GooglePayComponentParams;
import com.adyen.checkout.googlepay.internal.util.GooglePayUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.AutoResolveHelper;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.Wallet;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0001?B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u001e\u001a\u00020\u000f2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0016J2\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u0006\u0010,\u001a\u00020-2\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f03\u0012\u0004\u0012\u00020&02H\u0016J\b\u00104\u001a\u00020&H\u0016J\u0010\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020\u000fH\u0002J\b\u00107\u001a\u00020&H\u0016J\u0010\u00108\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020(H\u0016J\u0017\u0010=\u001a\u00020&2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0001\u00a2\u0006\u0002\b>R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015\u00a8\u0006@"}, d2={"Lcom/adyen/checkout/googlepay/internal/ui/DefaultGooglePayDelegate;", "Lcom/adyen/checkout/googlepay/internal/ui/GooglePayDelegate;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "componentParams", "Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParams;", "analyticsRepository", "Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepository;", "(Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;Lcom/adyen/checkout/components/core/PaymentMethod;Lcom/adyen/checkout/components/core/OrderRequest;Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParams;Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepository;)V", "_componentStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/adyen/checkout/googlepay/GooglePayComponentState;", "getComponentParams", "()Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParams;", "componentStateFlow", "Lkotlinx/coroutines/flow/Flow;", "getComponentStateFlow", "()Lkotlinx/coroutines/flow/Flow;", "exceptionChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/adyen/checkout/core/exception/CheckoutException;", "exceptionFlow", "getExceptionFlow", "submitChannel", "submitFlow", "getSubmitFlow", "createComponentState", "paymentData", "Lcom/google/android/gms/wallet/PaymentData;", "getGooglePayButtonParameters", "Lcom/adyen/checkout/googlepay/GooglePayButtonParameters;", "getPaymentMethodType", "", "handleActivityResult", "", "resultCode", "", "data", "Landroid/content/Intent;", "initialize", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/PaymentComponentEvent;", "onCleared", "onState", "state", "removeObserver", "setupAnalytics", "startGooglePayScreen", "activity", "Landroid/app/Activity;", "requestCode", "updateComponentState", "updateComponentState$googlepay_release", "Companion", "googlepay_release"})
@SourceDebugExtension(value={"SMAP\nDefaultGooglePayDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultGooglePayDelegate.kt\ncom/adyen/checkout/googlepay/internal/ui/DefaultGooglePayDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class DefaultGooglePayDelegate
implements GooglePayDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PaymentObserverRepository observerRepository;
    @NotNull
    private final PaymentMethod paymentMethod;
    @Nullable
    private final OrderRequest order;
    @NotNull
    private final GooglePayComponentParams componentParams;
    @NotNull
    private final AnalyticsRepository analyticsRepository;
    @NotNull
    private final MutableStateFlow<GooglePayComponentState> _componentStateFlow;
    @NotNull
    private final Flow<GooglePayComponentState> componentStateFlow;
    @NotNull
    private final Channel<CheckoutException> exceptionChannel;
    @NotNull
    private final Flow<CheckoutException> exceptionFlow;
    @NotNull
    private final Channel<GooglePayComponentState> submitChannel;
    @NotNull
    private final Flow<GooglePayComponentState> submitFlow;
    @NotNull
    private static final String TAG = LogUtil.getTag();

    public DefaultGooglePayDelegate(@NotNull PaymentObserverRepository observerRepository, @NotNull PaymentMethod paymentMethod, @Nullable OrderRequest order, @NotNull GooglePayComponentParams componentParams, @NotNull AnalyticsRepository analyticsRepository) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)analyticsRepository, (String)"analyticsRepository");
        this.observerRepository = observerRepository;
        this.paymentMethod = paymentMethod;
        this.order = order;
        this.componentParams = componentParams;
        this.analyticsRepository = analyticsRepository;
        this._componentStateFlow = StateFlowKt.MutableStateFlow((Object)DefaultGooglePayDelegate.createComponentState$default(this, null, 1, null));
        this.componentStateFlow = (Flow)this._componentStateFlow;
        this.exceptionChannel = ChannelExtensionsKt.bufferedChannel();
        this.exceptionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.exceptionChannel));
        this.submitChannel = ChannelExtensionsKt.bufferedChannel();
        this.submitFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.submitChannel));
    }

    @NotNull
    public GooglePayComponentParams getComponentParams() {
        return this.componentParams;
    }

    @Override
    @NotNull
    public Flow<GooglePayComponentState> getComponentStateFlow() {
        return this.componentStateFlow;
    }

    @Override
    @NotNull
    public Flow<CheckoutException> getExceptionFlow() {
        return this.exceptionFlow;
    }

    @NotNull
    public Flow<GooglePayComponentState> getSubmitFlow() {
        return this.submitFlow;
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.setupAnalytics(coroutineScope);
        FlowKt.launchIn((Flow)FlowKt.onEach(this.getComponentStateFlow(), (Function2)((Function2)new Function2<GooglePayComponentState, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultGooglePayDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        GooglePayComponentState it = (GooglePayComponentState)this.L$0;
                        DefaultGooglePayDelegate.access$onState(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull GooglePayComponentState p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    private final void setupAnalytics(CoroutineScope coroutineScope) {
        Logger.v((String)TAG, (String)"setupAnalytics");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultGooglePayDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultGooglePayDelegate.access$getAnalyticsRepository$p(this.this$0).setupAnalytics((Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void onState(GooglePayComponentState state) {
        if (state.isValid()) {
            this.submitChannel.trySend-JP2dKIU((Object)state);
        }
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super PaymentComponentEvent<GooglePayComponentState>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(this.getComponentStateFlow(), this.getExceptionFlow(), this.getSubmitFlow(), lifecycleOwner, coroutineScope, callback);
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    @VisibleForTesting
    public final void updateComponentState$googlepay_release(@Nullable PaymentData paymentData) {
        Logger.v((String)TAG, (String)"updateComponentState");
        GooglePayComponentState componentState = this.createComponentState(paymentData);
        this._componentStateFlow.tryEmit((Object)componentState);
    }

    private final GooglePayComponentState createComponentState(PaymentData paymentData) {
        boolean bl;
        PaymentData paymentData2 = paymentData;
        if (paymentData2 != null) {
            PaymentData it = paymentData2;
            boolean bl2 = false;
            bl = ((CharSequence)GooglePayUtils.INSTANCE.findToken(it)).length() > 0;
        } else {
            bl = false;
        }
        boolean isValid = bl;
        GooglePayPaymentMethod paymentMethod = GooglePayUtils.INSTANCE.createGooglePayPaymentMethod(paymentData, this.paymentMethod.getType(), this.analyticsRepository.getCheckoutAttemptId());
        PaymentComponentData paymentComponentData = new PaymentComponentData((PaymentMethodDetails)paymentMethod, this.order, this.getComponentParams().getAmount(), null, null, null, null, null, null, null, null, null, null, 8184, null);
        return new GooglePayComponentState((PaymentComponentData<GooglePayPaymentMethod>)paymentComponentData, isValid, true, paymentData);
    }

    static /* synthetic */ GooglePayComponentState createComponentState$default(DefaultGooglePayDelegate defaultGooglePayDelegate, PaymentData paymentData, int n, Object object) {
        if ((n & 1) != 0) {
            paymentData = null;
        }
        return defaultGooglePayDelegate.createComponentState(paymentData);
    }

    @Override
    public void startGooglePayScreen(@NotNull Activity activity, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Logger.d((String)TAG, (String)"startGooglePayScreen");
        PaymentsClient paymentsClient = Wallet.getPaymentsClient((Activity)activity, (Wallet.WalletOptions)GooglePayUtils.INSTANCE.createWalletOptions(this.getComponentParams()));
        Intrinsics.checkNotNullExpressionValue((Object)paymentsClient, (String)"getPaymentsClient(...)");
        PaymentsClient paymentsClient2 = paymentsClient;
        PaymentDataRequest paymentDataRequest = GooglePayUtils.INSTANCE.createPaymentDataRequest(this.getComponentParams());
        AutoResolveHelper.resolveTask((Task)paymentsClient2.loadPaymentData(paymentDataRequest), (Activity)activity, (int)requestCode);
    }

    @Override
    public void handleActivityResult(int resultCode, @Nullable Intent data) {
        Logger.d((String)TAG, (String)"handleActivityResult");
        switch (resultCode) {
            case -1: {
                if (data == null) {
                    this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Result data is null", null, 2, null));
                    return;
                }
                PaymentData paymentData = PaymentData.getFromIntent((Intent)data);
                this.updateComponentState$googlepay_release(paymentData);
                break;
            }
            case 0: {
                this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Payment canceled.", null, 2, null));
                break;
            }
            case 1: {
                Object object;
                Object object2;
                Status status;
                Status status2 = status = AutoResolveHelper.getStatusFromIntent((Intent)data);
                if (status2 != null) {
                    Status it = status2;
                    boolean bl = false;
                    object2 = ": " + it.getStatusMessage();
                } else {
                    object2 = object = null;
                }
                if (object2 == null) {
                    object = "";
                }
                String statusMessage = object;
                this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("GooglePay returned an error" + statusMessage, null, 2, null));
                break;
            }
        }
    }

    @Override
    @NotNull
    public GooglePayButtonParameters getGooglePayButtonParameters() {
        List<GooglePayPaymentMethodModel> allowedPaymentMethodsList = GooglePayUtils.INSTANCE.getAllowedPaymentMethods$googlepay_release(this.getComponentParams());
        JSONArray jSONArray = ModelUtils.serializeOptList(allowedPaymentMethodsList, GooglePayPaymentMethodModel.SERIALIZER);
        String string = jSONArray != null ? jSONArray.toString() : null;
        if (string == null) {
            string = "";
        }
        String allowedPaymentMethods = string;
        return new GooglePayButtonParameters(allowedPaymentMethods);
    }

    @NotNull
    public String getPaymentMethodType() {
        String string = this.paymentMethod.getType();
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    public void onCleared() {
        this.removeObserver();
    }

    public static final /* synthetic */ void access$onState(DefaultGooglePayDelegate $this, GooglePayComponentState state) {
        $this.onState(state);
    }

    public static final /* synthetic */ AnalyticsRepository access$getAnalyticsRepository$p(DefaultGooglePayDelegate $this) {
        return $this.analyticsRepository;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/googlepay/internal/ui/DefaultGooglePayDelegate$Companion;", "", "()V", "TAG", "", "googlepay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

