/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.cse.internal;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adyen/checkout/cse/internal/ValidationUtils;", "", "()V", "PUBLIC_KEY_PATTERN", "", "PUBLIC_KEY_SIZE", "", "isPublicKeyValid", "", "publicKey", "cse_release"})
public final class ValidationUtils {
    @NotNull
    public static final ValidationUtils INSTANCE = new ValidationUtils();
    @NotNull
    private static final String PUBLIC_KEY_PATTERN = "([A-F]|[0-9]){5}\\|([A-F]|[0-9]){512}";
    private static final int PUBLIC_KEY_SIZE = 518;

    private ValidationUtils() {
    }

    @JvmStatic
    public static final boolean isPublicKeyValid(@NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Pattern pubKeyPattern = Pattern.compile(PUBLIC_KEY_PATTERN);
        return pubKeyPattern.matcher(publicKey).find() && publicKey.length() == 518;
    }
}

