/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.cse.internal.test;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.cse.EncryptedCard;
import com.adyen.checkout.cse.EncryptionException;
import com.adyen.checkout.cse.UnencryptedCard;
import com.adyen.checkout.cse.internal.BaseCardEncryptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/adyen/checkout/cse/internal/test/TestCardEncryptor;", "Lcom/adyen/checkout/cse/internal/BaseCardEncryptor;", "()V", "shouldThrowException", "", "getShouldThrowException", "()Z", "setShouldThrowException", "(Z)V", "encrypt", "", "unencryptedCard", "Lcom/adyen/checkout/cse/UnencryptedCard;", "publicKey", "encryptBin", "bin", "encryptFields", "Lcom/adyen/checkout/cse/EncryptedCard;", "cse_release"})
@RestrictTo(value={RestrictTo.Scope.TESTS})
public final class TestCardEncryptor
implements BaseCardEncryptor {
    private boolean shouldThrowException;

    public final boolean getShouldThrowException() {
        return this.shouldThrowException;
    }

    public final void setShouldThrowException(boolean bl) {
        this.shouldThrowException = bl;
    }

    @Override
    @NotNull
    public EncryptedCard encryptFields(@NotNull UnencryptedCard unencryptedCard, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)unencryptedCard, (String)"unencryptedCard");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        if (this.shouldThrowException) {
            throw new EncryptionException("Failed for testing purposes", null);
        }
        return new EncryptedCard(unencryptedCard.getNumber(), unencryptedCard.getExpiryMonth(), unencryptedCard.getExpiryYear(), unencryptedCard.getCvc());
    }

    @Override
    @NotNull
    public String encrypt(@NotNull UnencryptedCard unencryptedCard, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)unencryptedCard, (String)"unencryptedCard");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        if (this.shouldThrowException) {
            throw new EncryptionException("Failed for testing purposes", null);
        }
        return unencryptedCard.toString();
    }

    @Override
    @NotNull
    public String encryptBin(@NotNull String bin, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        if (this.shouldThrowException) {
            throw new EncryptionException("Failed for testing purposes", null);
        }
        return bin;
    }
}

