/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.cse.internal;

import com.adyen.checkout.cse.EncryptionException;
import com.adyen.checkout.cse.internal.Base64String;
import com.adyen.checkout.cse.internal.JWEObject;
import com.adyen.checkout.cse.internal.ValidationUtils;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0005\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/adyen/checkout/cse/internal/JSONWebEncryptor;", "", "()V", "keyFactory", "Ljava/security/KeyFactory;", "encrypt", "Lcom/adyen/checkout/cse/internal/JWEObject;", "payload", "", "contentKey", "Ljavax/crypto/SecretKey;", "encryptedKey", "Lcom/adyen/checkout/cse/internal/Base64String;", "publicKey", "encryptContentEncryptionKey", "", "Ljava/security/PublicKey;", "generateContentEncryptionKey", "generateInitializationVector", "generatePublicKey", "getAESCipher", "Ljavax/crypto/Cipher;", "secretKey", "iv", "getAdditionalAuthenticationData", "encodedHeader", "getRSACipher", "serialize", "jweObject", "Companion", "cse_release"})
public final class JSONWebEncryptor {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final KeyFactory keyFactory;
    @NotNull
    private static final String RSA_OAEP_CIPHER = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    @NotNull
    private static final String AES_GCM_CIPHER = "AES/GCM/NoPadding";
    @NotNull
    private static final String RSA_ALGORITHM = "RSA";
    @NotNull
    private static final String AES_ALGORITHM = "AES";
    @NotNull
    private static final String OAEP_ALGORITHM = "OAEP";
    @NotNull
    private static final String MGF_NAME = "MGF1";
    private static final int BITES_IN_BYTE = 8;
    private static final int RADIX = 16;
    private static final int CONTENT_ENCRYPTION_KEY_BYTES = 32;
    private static final int INITIALIZATION_VECTOR_BYTES = 12;
    private static final int AUTH_TAG_LENGTH = 16;
    @NotNull
    private static final JSONObject HEADER;

    public JSONWebEncryptor() {
        KeyFactory keyFactory;
        JSONWebEncryptor jSONWebEncryptor = this;
        try {
            JSONWebEncryptor jSONWebEncryptor2 = jSONWebEncryptor;
            keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            Intrinsics.checkNotNull((Object)keyFactory);
        }
        catch (NoSuchAlgorithmException e) {
            JSONWebEncryptor jSONWebEncryptor3 = jSONWebEncryptor;
            throw new EncryptionException("RSA KeyFactory not found", e);
        }
        jSONWebEncryptor2.keyFactory = keyFactory;
    }

    @NotNull
    public final String encrypt(@NotNull String publicKey, @NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (!ValidationUtils.isPublicKeyValid(publicKey)) {
            throw new EncryptionException("Invalid public key", null);
        }
        PublicKey pubKey = this.generatePublicKey(publicKey);
        SecretKey contentKey = this.generateContentEncryptionKey();
        Base64String encryptedKey = new Base64String(this.encryptContentEncryptionKey(pubKey, contentKey));
        JWEObject jweObject = this.encrypt(payload, contentKey, encryptedKey);
        return this.serialize(jweObject);
    }

    private final PublicKey generatePublicKey(String publicKey) {
        PublicKey publicKey2;
        String[] stringArray = new String[]{"|"};
        List keyComponents = StringsKt.split$default((CharSequence)publicKey, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(new BigInteger((String)keyComponents.get(1), 16), new BigInteger((String)keyComponents.get(0), 16));
        try {
            publicKey2 = this.keyFactory.generatePublic(publicKeySpec);
            Intrinsics.checkNotNull((Object)publicKey2);
        }
        catch (InvalidKeySpecException e) {
            throw new EncryptionException("Problem reading public key", e);
        }
        return publicKey2;
    }

    private final SecretKey generateContentEncryptionKey() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[32];
        secureRandom.nextBytes(bytes);
        return new SecretKeySpec(bytes, AES_ALGORITHM);
    }

    private final byte[] encryptContentEncryptionKey(PublicKey publicKey, SecretKey contentKey) {
        byte[] byArray;
        Cipher cipher = this.getRSACipher(publicKey);
        try {
            byArray = cipher.doFinal(contentKey.getEncoded());
            Intrinsics.checkNotNull((Object)byArray);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException("The RSA key is invalid", e);
        }
        return byArray;
    }

    private final Cipher getRSACipher(PublicKey publicKey) {
        Cipher cipher;
        AlgorithmParameters algorithmParams = AlgorithmParameters.getInstance(OAEP_ALGORITHM);
        MGF1ParameterSpec mgfParamSpec = MGF1ParameterSpec.SHA256;
        OAEPParameterSpec paramSpec = new OAEPParameterSpec(mgfParamSpec.getDigestAlgorithm(), MGF_NAME, mgfParamSpec, PSource.PSpecified.DEFAULT);
        algorithmParams.init(paramSpec);
        try {
            cipher = Cipher.getInstance(RSA_OAEP_CIPHER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Problem instantiating RSA/ECB/OAEPWithSHA-256AndMGF1Padding Algorithm", e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException("Problem instantiating RSA/ECB/OAEPWithSHA-256AndMGF1Padding Padding", e);
        }
        Cipher cipher2 = cipher;
        cipher2.init(1, (Key)publicKey, algorithmParams);
        Intrinsics.checkNotNull((Object)cipher2);
        return cipher2;
    }

    private final JWEObject encrypt(String payload, SecretKey contentKey, Base64String encryptedKey) {
        String string = HEADER.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Base64String base64Header = new Base64String(StringsKt.encodeToByteArray((String)string));
        byte[] additionalData = this.getAdditionalAuthenticationData(base64Header);
        byte[] vector = this.generateInitializationVector();
        Cipher aesCipher = this.getAESCipher(contentKey, vector);
        aesCipher.updateAAD(additionalData);
        String string2 = payload;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] cipherOutput = aesCipher.doFinal(byArray);
        int tagIndex = cipherOutput.length - 16;
        Base64String base64String = new Base64String(vector);
        Intrinsics.checkNotNull((Object)cipherOutput);
        byte[] byArray2 = cipherOutput;
        int n = 0;
        Base64String base64String2 = new Base64String(ArraysKt.copyOfRange((byte[])byArray2, (int)n, (int)tagIndex));
        byArray2 = cipherOutput;
        n = cipherOutput.length;
        return new JWEObject(base64Header, encryptedKey, base64String, base64String2, new Base64String(ArraysKt.copyOfRange((byte[])byArray2, (int)tagIndex, (int)n)));
    }

    private final byte[] getAdditionalAuthenticationData(Base64String encodedHeader) {
        byte[] byArray = encodedHeader.getValue().getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    private final byte[] generateInitializationVector() {
        byte[] iv = new byte[12];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    private final Cipher getAESCipher(SecretKey secretKey, byte[] iv) {
        Cipher cipher;
        SecretKeySpec keySpec = new SecretKeySpec(secretKey.getEncoded(), AES_ALGORITHM);
        GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
        try {
            cipher = Cipher.getInstance(AES_GCM_CIPHER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Problem instantiating AES/GCM/NoPadding Algorithm", e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException("Problem instantiating AES/GCM/NoPadding Padding", e);
        }
        Cipher cipher2 = cipher;
        cipher2.init(1, (Key)keySpec, ivSpec);
        Intrinsics.checkNotNull((Object)cipher2);
        return cipher2;
    }

    private final String serialize(JWEObject jweObject) {
        String string = jweObject.getHeader() + "." + jweObject.getEncryptedKey() + "." + jweObject.getInitializationVector() + "." + jweObject.getCipherText() + "." + jweObject.getAuthTag();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        JSONObject jSONObject;
        Companion = new Companion(null);
        JSONObject $this$HEADER_u24lambda_u240 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$HEADER_u24lambda_u240.put("alg", (Object)"RSA-OAEP-256");
        $this$HEADER_u24lambda_u240.put("enc", (Object)"A256GCM");
        $this$HEADER_u24lambda_u240.put("version", (Object)"1");
        HEADER = jSONObject;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/adyen/checkout/cse/internal/JSONWebEncryptor$Companion;", "", "()V", "AES_ALGORITHM", "", "AES_GCM_CIPHER", "AUTH_TAG_LENGTH", "", "BITES_IN_BYTE", "CONTENT_ENCRYPTION_KEY_BYTES", "HEADER", "Lorg/json/JSONObject;", "INITIALIZATION_VECTOR_BYTES", "MGF_NAME", "OAEP_ALGORITHM", "RADIX", "RSA_ALGORITHM", "RSA_OAEP_CIPHER", "cse_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

