/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.cse.internal;

import com.adyen.checkout.cse.EncryptedCard;
import com.adyen.checkout.cse.EncryptionException;
import com.adyen.checkout.cse.UnencryptedCard;
import com.adyen.checkout.cse.internal.BaseCardEncryptor;
import com.adyen.checkout.cse.internal.BaseGenericEncryptor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/adyen/checkout/cse/internal/DefaultCardEncryptor;", "Lcom/adyen/checkout/cse/internal/BaseCardEncryptor;", "genericEncryptor", "Lcom/adyen/checkout/cse/internal/BaseGenericEncryptor;", "(Lcom/adyen/checkout/cse/internal/BaseGenericEncryptor;)V", "encrypt", "", "unencryptedCard", "Lcom/adyen/checkout/cse/UnencryptedCard;", "publicKey", "encryptBin", "bin", "encryptFields", "Lcom/adyen/checkout/cse/EncryptedCard;", "Companion", "cse_release"})
public final class DefaultCardEncryptor
implements BaseCardEncryptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseGenericEncryptor genericEncryptor;
    @NotNull
    private static final String CARD_NUMBER_KEY = "number";
    @NotNull
    private static final String EXPIRY_MONTH_KEY = "expiryMonth";
    @NotNull
    private static final String EXPIRY_YEAR_KEY = "expiryYear";
    @NotNull
    private static final String CVC_KEY = "cvc";
    @NotNull
    private static final String HOLDER_NAME_KEY = "holderName";
    @NotNull
    private static final String BIN_KEY = "binValue";

    public DefaultCardEncryptor(@NotNull BaseGenericEncryptor genericEncryptor) {
        Intrinsics.checkNotNullParameter((Object)genericEncryptor, (String)"genericEncryptor");
        this.genericEncryptor = genericEncryptor;
    }

    @Override
    @NotNull
    public EncryptedCard encryptFields(@NotNull UnencryptedCard unencryptedCard, @NotNull String publicKey) {
        EncryptedCard encryptedCard;
        Intrinsics.checkNotNullParameter((Object)unencryptedCard, (String)"unencryptedCard");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        try {
            String string;
            String string2;
            String string3 = unencryptedCard.getNumber();
            if (string3 != null) {
                String number = string3;
                boolean bl = false;
                string2 = this.genericEncryptor.encryptField(CARD_NUMBER_KEY, number, publicKey);
            } else {
                string2 = null;
            }
            String encryptedNumber = string2;
            String encryptedExpiryMonth = null;
            String encryptedExpiryYear = null;
            if (unencryptedCard.getExpiryMonth() != null && unencryptedCard.getExpiryYear() != null) {
                encryptedExpiryMonth = this.genericEncryptor.encryptField(EXPIRY_MONTH_KEY, unencryptedCard.getExpiryMonth(), publicKey);
                encryptedExpiryYear = this.genericEncryptor.encryptField(EXPIRY_YEAR_KEY, unencryptedCard.getExpiryYear(), publicKey);
            } else if (unencryptedCard.getExpiryMonth() == null && unencryptedCard.getExpiryYear() == null) {
                encryptedExpiryMonth = null;
                encryptedExpiryYear = null;
            } else {
                throw new EncryptionException("Both expiryMonth and expiryYear need to be set for encryption.", null);
            }
            String string4 = unencryptedCard.getCvc();
            if (string4 != null) {
                String cvc = string4;
                boolean bl = false;
                string = this.genericEncryptor.encryptField(CVC_KEY, cvc, publicKey);
            } else {
                string = null;
            }
            String encryptedSecurityCode = string;
            encryptedCard = new EncryptedCard(encryptedNumber, encryptedExpiryMonth, encryptedExpiryYear, encryptedSecurityCode);
        }
        catch (IllegalStateException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "No message.";
            }
            throw new EncryptionException(string, e);
        }
        return encryptedCard;
    }

    @Override
    @NotNull
    public String encrypt(@NotNull UnencryptedCard unencryptedCard, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)unencryptedCard, (String)"unencryptedCard");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CARD_NUMBER_KEY, (Object)unencryptedCard.getNumber()), TuplesKt.to((Object)EXPIRY_MONTH_KEY, (Object)unencryptedCard.getExpiryMonth()), TuplesKt.to((Object)EXPIRY_YEAR_KEY, (Object)unencryptedCard.getExpiryYear()), TuplesKt.to((Object)CVC_KEY, (Object)unencryptedCard.getCvc()), TuplesKt.to((Object)HOLDER_NAME_KEY, (Object)unencryptedCard.getCardHolderName())};
        return this.genericEncryptor.encryptFields(publicKey, pairArray);
    }

    @Override
    @NotNull
    public String encryptBin(@NotNull String bin, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return this.genericEncryptor.encryptField(BIN_KEY, bin, publicKey);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adyen/checkout/cse/internal/DefaultCardEncryptor$Companion;", "", "()V", "BIN_KEY", "", "CARD_NUMBER_KEY", "CVC_KEY", "EXPIRY_MONTH_KEY", "EXPIRY_YEAR_KEY", "HOLDER_NAME_KEY", "cse_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

