/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.cse.internal;

import com.adyen.checkout.cse.EncryptionException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/adyen/checkout/cse/internal/CompositeKey;", "", "inputKey", "Ljavax/crypto/SecretKey;", "(Ljavax/crypto/SecretKey;)V", "encKey", "getEncKey", "()Ljavax/crypto/SecretKey;", "macKey", "getMacKey", "truncatedMacLength", "", "getTruncatedMacLength", "()I", "cse_release"})
public final class CompositeKey {
    @NotNull
    private final SecretKey macKey;
    @NotNull
    private final SecretKey encKey;
    private final int truncatedMacLength;

    public CompositeKey(@NotNull SecretKey inputKey) {
        Intrinsics.checkNotNullParameter((Object)inputKey, (String)"inputKey");
        byte[] keyBytes = inputKey.getEncoded();
        switch (keyBytes.length) {
            case 32: {
                this.macKey = new SecretKeySpec(keyBytes, 0, 16, "HMACSHA256");
                this.encKey = new SecretKeySpec(keyBytes, 16, 16, "AES");
                this.truncatedMacLength = 16;
                break;
            }
            case 48: {
                this.macKey = new SecretKeySpec(keyBytes, 0, 24, "HMACSHA384");
                this.encKey = new SecretKeySpec(keyBytes, 24, 24, "AES");
                this.truncatedMacLength = 24;
                break;
            }
            case 64: {
                this.macKey = new SecretKeySpec(keyBytes, 0, 32, "HMACSHA512");
                this.encKey = new SecretKeySpec(keyBytes, 32, 32, "AES");
                this.truncatedMacLength = 32;
                break;
            }
            default: {
                throw new EncryptionException("Unsupported key length, must be 256, 384 or 512 bits", null);
            }
        }
    }

    @NotNull
    public final SecretKey getMacKey() {
        return this.macKey;
    }

    @NotNull
    public final SecretKey getEncKey() {
        return this.encKey;
    }

    public final int getTruncatedMacLength() {
        return this.truncatedMacLength;
    }
}

