/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.util;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.core.Environment;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/adyen/checkout/components/core/internal/util/ValidationUtils;", "", "()V", "EMAIL_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "EMAIL_REGEX", "", "getEMAIL_REGEX$annotations", "LIVE_CLIENT_KEY_PATTERN", "PHONE_PATTERN", "PHONE_REGEX", "TEST_CLIENT_KEY_PATTERN", "isClientKeyValid", "", "clientKey", "environment", "Lcom/adyen/checkout/core/Environment;", "isClientKeyValid$components_core_release", "isEmailValid", "emailAddress", "isPhoneNumberValid", "phoneNumber", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ValidationUtils {
    @NotNull
    public static final ValidationUtils INSTANCE = new ValidationUtils();
    @NotNull
    private static final String EMAIL_REGEX = "^(([a-z0-9!#$%&'*+\\-/=?^_`{|}~]+(\\.[a-z0-9!#$%&'*+\\-/=?^_`{|}~]+)*)|(\".+\"))@((\\[((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}])|((?!-)[a-z0-9-]{1,63}(?<!-)(\\.[a-z0-9-]{1,63}(?<!-))*\\.[a-z]{2,}))$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^(([a-z0-9!#$%&'*+\\-/=?^_`{|}~]+(\\.[a-z0-9!#$%&'*+\\-/=?^_`{|}~]+)*)|(\".+\"))@((\\[((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}])|((?!-)[a-z0-9-]{1,63}(?<!-)(\\.[a-z0-9-]{1,63}(?<!-))*\\.[a-z]{2,}))$", 2);
    @NotNull
    private static final String PHONE_REGEX = "^\\D*(\\d\\D*){9,14}$";
    private static final Pattern PHONE_PATTERN = Pattern.compile("^\\D*(\\d\\D*){9,14}$");
    private static final Pattern TEST_CLIENT_KEY_PATTERN = Pattern.compile("test_([a-zA-Z0-9]){32}");
    private static final Pattern LIVE_CLIENT_KEY_PATTERN = Pattern.compile("live_([a-zA-Z0-9]){32}");

    private ValidationUtils() {
    }

    private static /* synthetic */ void getEMAIL_REGEX$annotations() {
    }

    public final boolean isPhoneNumberValid(@NotNull String phoneNumber) {
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        return PHONE_PATTERN.matcher(phoneNumber).matches();
    }

    public final boolean isEmailValid(@NotNull String emailAddress) {
        Intrinsics.checkNotNullParameter((Object)emailAddress, (String)"emailAddress");
        return EMAIL_PATTERN.matcher(emailAddress).matches();
    }

    public final boolean isClientKeyValid$components_core_release(@NotNull String clientKey, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Environment environment2 = environment;
        return Intrinsics.areEqual((Object)environment2, (Object)Environment.TEST) ? TEST_CLIENT_KEY_PATTERN.matcher(clientKey).matches() : (((((Intrinsics.areEqual((Object)environment2, (Object)Environment.APSE) ? true : Intrinsics.areEqual((Object)environment2, (Object)Environment.AUSTRALIA)) ? true : Intrinsics.areEqual((Object)environment2, (Object)Environment.EUROPE)) ? true : Intrinsics.areEqual((Object)environment2, (Object)Environment.INDIA)) ? true : Intrinsics.areEqual((Object)environment2, (Object)Environment.UNITED_STATES)) ? LIVE_CLIENT_KEY_PATTERN.matcher(clientKey).matches() : false);
    }
}

