/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.util;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0004J\"\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/adyen/checkout/components/core/internal/util/DateUtils;", "", "()V", "DEFAULT_INPUT_DATE_FORMAT", "", "formatDateToString", "calendar", "Ljava/util/Calendar;", "pattern", "formatStringDate", "date", "shopperLocale", "Ljava/util/Locale;", "inputFormat", "matchesFormat", "", "format", "parseDateToView", "month", "year", "toServerDateFormat", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateUtils.kt\ncom/adyen/checkout/components/core/internal/util/DateUtils\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n16#2,17:97\n21#2,12:115\n21#2,12:127\n1#3:114\n*S KotlinDebug\n*F\n+ 1 DateUtils.kt\ncom/adyen/checkout/components/core/internal/util/DateUtils\n*L\n53#1:97,17\n75#1:115,12\n92#1:127,12\n*E\n"})
public final class DateUtils {
    @NotNull
    public static final DateUtils INSTANCE = new DateUtils();
    @NotNull
    private static final String DEFAULT_INPUT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    private DateUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String parseDateToView(@NotNull String month, @NotNull String year) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        return month + "/" + StringsKt.takeLast((String)year, (int)2);
    }

    @JvmStatic
    @NotNull
    public static final String toServerDateFormat(@NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        SimpleDateFormat serverDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        String string = serverDateFormat.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matchesFormat(@NotNull String date, @NotNull String format) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.US);
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(date);
            bl = true;
        }
        catch (ParseException e) {
            DateUtils dateUtils = this;
            AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl2 = false;
                String string2 = "Provided date " + date + " does not match the given format " + format;
                adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String formatStringDate(@NotNull String date, @NotNull Locale shopperLocale, @NotNull String inputFormat) {
        String string;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)shopperLocale, (String)"shopperLocale");
        Intrinsics.checkNotNullParameter((Object)inputFormat, (String)"inputFormat");
        try {
            String string2;
            Date parsedDate;
            SimpleDateFormat inputSimpleFormat = new SimpleDateFormat(inputFormat, shopperLocale);
            DateFormat outputSimpleFormat = DateFormat.getDateInstance(3, shopperLocale);
            Date date2 = parsedDate = inputSimpleFormat.parse(date);
            if (date2 != null) {
                Date it = date2;
                boolean bl = false;
                string2 = outputSimpleFormat.format(it);
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (ParseException e) {
            DateUtils parsedDate = this;
            AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog$iv;
                String fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string3 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string4 = "Provided date " + date + " does not match the given format " + inputFormat;
                adyenLogger.log(adyenLogLevel, string3, string4, (Throwable)e);
            }
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String formatStringDate$default(DateUtils dateUtils, String string, Locale locale, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = DEFAULT_INPUT_DATE_FORMAT;
        }
        return dateUtils.formatStringDate(string, locale, string2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String formatDateToString(@NotNull Calendar calendar, @NotNull String pattern) {
        String string;
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.US);
            string = formatter.format(calendar.getTime());
        }
        catch (IllegalArgumentException e) {
            DateUtils dateUtils = this;
            AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog$iv;
                String fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string3 = "Provided pattern " + pattern + " is invalid";
                adyenLogger.log(adyenLogLevel, string2, string3, (Throwable)e);
            }
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String formatDateToString$default(DateUtils dateUtils, Calendar calendar, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = DEFAULT_INPUT_DATE_FORMAT;
        }
        return dateUtils.formatDateToString(calendar, string);
    }
}

