/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.util;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.CheckoutCurrency;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.exception.CheckoutException;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcom/adyen/checkout/components/core/internal/util/AmountFormat;", "", "()V", "getFractionDigits", "", "currencyCode", "", "toBigDecimal", "Ljava/math/BigDecimal;", "amount", "Lcom/adyen/checkout/components/core/Amount;", "value", "", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nAmountFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmountFormat.kt\ncom/adyen/checkout/components/core/internal/util/AmountFormat\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n*L\n1#1,66:1\n21#2,12:67\n21#2,12:79\n*S KotlinDebug\n*F\n+ 1 AmountFormat.kt\ncom/adyen/checkout/components/core/internal/util/AmountFormat\n*L\n52#1:67,12\n61#1:79,12\n*E\n"})
public final class AmountFormat {
    @NotNull
    public static final AmountFormat INSTANCE = new AmountFormat();

    private AmountFormat() {
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal toBigDecimal(@NotNull Amount amount) {
        Intrinsics.checkNotNullParameter((Object)((Object)amount), (String)"amount");
        long l = amount.getValue();
        String string = amount.getCurrency();
        Intrinsics.checkNotNull((Object)string);
        return INSTANCE.toBigDecimal(l, string);
    }

    private final BigDecimal toBigDecimal(long value, String currencyCode) {
        int fractionDigits = this.getFractionDigits(currencyCode);
        BigDecimal bigDecimal = BigDecimal.valueOf(value, fractionDigits);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return bigDecimal;
    }

    /*
     * WARNING - void declaration
     */
    private final int getFractionDigits(String currencyCode) {
        CharSequence charSequence = currencyCode;
        Object object = new Regex("[^A-Z]");
        String string = "";
        charSequence = object.replace(charSequence, string);
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = ((String)charSequence).toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String normalizedCurrencyCode = string2;
        try {
            CheckoutCurrency checkoutCurrency = CheckoutCurrency.Companion.find(normalizedCurrencyCode);
            return checkoutCurrency.getFractionDigits();
        }
        catch (CheckoutException e) {
            int n;
            String string3;
            AdyenLogger adyenLogger;
            Object object2;
            String string4;
            object = this;
            Object level$iv = AdyenLogLevel.ERROR;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog$iv;
                String fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                object2 = level$iv;
                adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                string3 = normalizedCurrencyCode + " is an unsupported currency. Falling back to information from java.util.Currency.";
                adyenLogger.log(object2, string4, string3, (Throwable)e);
            }
            try {
                Currency currency = Currency.getInstance(normalizedCurrencyCode);
                n = RangesKt.coerceAtLeast((int)currency.getDefaultFractionDigits(), (int)0);
            }
            catch (IllegalArgumentException e2) {
                level$iv = this;
                AdyenLogLevel level$iv2 = AdyenLogLevel.ERROR;
                boolean $i$f$adyenLog2 = false;
                if (AdyenLogger.Companion.getLogger().shouldLog(level$iv2)) {
                    String tag$iv;
                    void $this$adyenLog$iv;
                    String fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                    Intrinsics.checkNotNull((Object)fullClassName$iv);
                    String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                    string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                    object2 = level$iv2;
                    adyenLogger = AdyenLogger.Companion.getLogger();
                    boolean bl = false;
                    string3 = "Could not determine fraction digits for " + normalizedCurrencyCode;
                    adyenLogger.log(object2, string4, string3, (Throwable)e2);
                }
                n = 0;
            }
            return n;
        }
    }
}

