/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.util;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.CheckoutCurrency;
import com.adyen.checkout.core.exception.CheckoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0006H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0005*\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000b"}, d2={"EMPTY_CURRENCY", "", "EMPTY_VALUE", "", "isEmpty", "", "Lcom/adyen/checkout/components/core/Amount;", "(Lcom/adyen/checkout/components/core/Amount;)Z", "isZero", "validate", "", "components-core_release"})
public final class AmountExtensionsKt {
    @NotNull
    public static final String EMPTY_CURRENCY = "NONE";
    public static final long EMPTY_VALUE = -1L;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final boolean isEmpty(@NotNull Amount $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isEmpty), (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isEmpty.getCurrency(), (Object)EMPTY_CURRENCY) || $this$isEmpty.getValue() == -1L;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final boolean isZero(@NotNull Amount $this$isZero) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isZero), (String)"<this>");
        return CheckoutCurrency.Companion.isSupported($this$isZero.getCurrency()) && $this$isZero.getValue() == 0L;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final void validate(@NotNull Amount $this$validate) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$validate), (String)"<this>");
        if (!CheckoutCurrency.Companion.isSupported($this$validate.getCurrency())) {
            throw new CheckoutException("Currency code is not valid.", null, 2, null);
        }
        if ($this$validate.getValue() < 0L) {
            throw new CheckoutException("Value cannot be less than 0.", null, 2, null);
        }
    }
}

