/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.analytics.data.remote;

import android.app.Application;
import android.os.Build;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsPlatformParams;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsSource;
import com.adyen.checkout.components.core.internal.analytics.data.remote.AnalyticsSetupProvider;
import com.adyen.checkout.components.core.internal.data.model.AnalyticsSetupRequest;
import com.adyen.checkout.components.core.internal.ui.model.AnalyticsParamsLevel;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/adyen/checkout/components/core/internal/analytics/data/remote/DefaultAnalyticsSetupProvider;", "Lcom/adyen/checkout/components/core/internal/analytics/data/remote/AnalyticsSetupProvider;", "application", "Landroid/app/Application;", "shopperLocale", "Ljava/util/Locale;", "isCreatedByDropIn", "", "analyticsLevel", "Lcom/adyen/checkout/components/core/internal/ui/model/AnalyticsParamsLevel;", "amount", "Lcom/adyen/checkout/components/core/Amount;", "source", "Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsSource;", "sessionId", "", "(Landroid/app/Application;Ljava/util/Locale;ZLcom/adyen/checkout/components/core/internal/ui/model/AnalyticsParamsLevel;Lcom/adyen/checkout/components/core/Amount;Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsSource;Ljava/lang/String;)V", "getComponentQueryParameter", "getFlavorQueryParameter", "getLevelQueryParameter", "analyticsParamsLevel", "provide", "Lcom/adyen/checkout/components/core/internal/data/model/AnalyticsSetupRequest;", "Companion", "components-core_release"})
public final class DefaultAnalyticsSetupProvider
implements AnalyticsSetupProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Application application;
    @NotNull
    private final Locale shopperLocale;
    private final boolean isCreatedByDropIn;
    @NotNull
    private final AnalyticsParamsLevel analyticsLevel;
    @Nullable
    private final Amount amount;
    @NotNull
    private final AnalyticsSource source;
    @Nullable
    private final String sessionId;
    @NotNull
    private static final String DROP_IN = "dropin";
    @NotNull
    private static final String COMPONENTS = "components";
    @NotNull
    private static final String ANALYTICS_LEVEL_INITIAL = "initial";
    @NotNull
    private static final String ANALYTICS_LEVEL_ALL = "all";

    public DefaultAnalyticsSetupProvider(@NotNull Application application, @NotNull Locale shopperLocale, boolean isCreatedByDropIn, @NotNull AnalyticsParamsLevel analyticsLevel, @Nullable Amount amount, @NotNull AnalyticsSource source, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)shopperLocale, (String)"shopperLocale");
        Intrinsics.checkNotNullParameter((Object)((Object)analyticsLevel), (String)"analyticsLevel");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.application = application;
        this.shopperLocale = shopperLocale;
        this.isCreatedByDropIn = isCreatedByDropIn;
        this.analyticsLevel = analyticsLevel;
        this.amount = amount;
        this.source = source;
        this.sessionId = sessionId;
    }

    @Override
    @NotNull
    public AnalyticsSetupRequest provide() {
        String string = AnalyticsPlatformParams.INSTANCE.getVersion();
        String string2 = AnalyticsPlatformParams.INSTANCE.getPlatform();
        String string3 = this.shopperLocale.toLanguageTag();
        String string4 = this.getComponentQueryParameter(this.source);
        String string5 = this.getFlavorQueryParameter(this.isCreatedByDropIn);
        String string6 = this.getLevelQueryParameter(this.analyticsLevel);
        String string7 = Build.BRAND;
        String string8 = Build.MODEL;
        String string9 = this.application.getPackageName();
        String string10 = String.valueOf(Build.VERSION.SDK_INT);
        int n = this.application.getResources().getDisplayMetrics().widthPixels;
        List<String> list = this.source.getPaymentMethods();
        Amount amount = this.amount;
        String string11 = this.sessionId;
        return new AnalyticsSetupRequest(string, "android", string2, string3, string4, string5, string6, string7, string8, string9, string10, null, n, list, amount, string11);
    }

    private final String getFlavorQueryParameter(boolean isCreatedByDropIn) {
        return isCreatedByDropIn ? DROP_IN : COMPONENTS;
    }

    private final String getComponentQueryParameter(AnalyticsSource source) {
        String string;
        AnalyticsSource analyticsSource = source;
        if (analyticsSource instanceof AnalyticsSource.DropIn) {
            string = DROP_IN;
        } else if (analyticsSource instanceof AnalyticsSource.PaymentComponent) {
            string = ((AnalyticsSource.PaymentComponent)source).getPaymentMethodType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String getLevelQueryParameter(AnalyticsParamsLevel analyticsParamsLevel) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[analyticsParamsLevel.ordinal()]) {
            case 1: {
                string = ANALYTICS_LEVEL_INITIAL;
                break;
            }
            case 2: {
                string = ANALYTICS_LEVEL_ALL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/adyen/checkout/components/core/internal/analytics/data/remote/DefaultAnalyticsSetupProvider$Companion;", "", "()V", "ANALYTICS_LEVEL_ALL", "", "ANALYTICS_LEVEL_INITIAL", "COMPONENTS", "DROP_IN", "components-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnalyticsParamsLevel.values().length];
            try {
                nArray[AnalyticsParamsLevel.INITIAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalyticsParamsLevel.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

