/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.analytics;

import android.app.Application;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsManager;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsSource;
import com.adyen.checkout.components.core.internal.analytics.DefaultAnalyticsManager;
import com.adyen.checkout.components.core.internal.analytics.data.DefaultAnalyticsRepository;
import com.adyen.checkout.components.core.internal.analytics.data.local.ErrorAnalyticsLocalDataStore;
import com.adyen.checkout.components.core.internal.analytics.data.local.InfoAnalyticsLocalDataStore;
import com.adyen.checkout.components.core.internal.analytics.data.local.LogAnalyticsLocalDataStore;
import com.adyen.checkout.components.core.internal.analytics.data.remote.AnalyticsTrackRequestProvider;
import com.adyen.checkout.components.core.internal.analytics.data.remote.DefaultAnalyticsRemoteDataStore;
import com.adyen.checkout.components.core.internal.analytics.data.remote.DefaultAnalyticsSetupProvider;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsService;
import com.adyen.checkout.components.core.internal.ui.model.AnalyticsParams;
import com.adyen.checkout.components.core.internal.ui.model.ComponentParams;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.internal.data.api.HttpClientFactory;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJR\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u0019"}, d2={"Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManagerFactory;", "", "()V", "provide", "Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;", "componentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;", "application", "Landroid/app/Application;", "source", "Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsSource;", "sessionId", "", "shopperLocale", "Ljava/util/Locale;", "environment", "Lcom/adyen/checkout/core/Environment;", "clientKey", "analyticsParams", "Lcom/adyen/checkout/components/core/internal/ui/model/AnalyticsParams;", "isCreatedByDropIn", "", "amount", "Lcom/adyen/checkout/components/core/Amount;", "Companion", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AnalyticsManagerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int INFO_SIZE = 50;
    private static final int LOG_SIZE = 5;
    private static final int ERROR_SIZE = 5;

    @NotNull
    public final AnalyticsManager provide(@NotNull ComponentParams componentParams, @NotNull Application application, @NotNull AnalyticsSource source, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.provide(componentParams.getShopperLocale(), componentParams.getEnvironment(), componentParams.getClientKey(), componentParams.getAnalyticsParams(), componentParams.isCreatedByDropIn(), componentParams.getAmount(), application, source, sessionId);
    }

    @NotNull
    public final AnalyticsManager provide(@NotNull Locale shopperLocale, @NotNull Environment environment, @NotNull String clientKey, @NotNull AnalyticsParams analyticsParams, boolean isCreatedByDropIn, @Nullable Amount amount, @NotNull Application application, @NotNull AnalyticsSource source, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)shopperLocale, (String)"shopperLocale");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        Intrinsics.checkNotNullParameter((Object)analyticsParams, (String)"analyticsParams");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new DefaultAnalyticsManager(new DefaultAnalyticsRepository(new InfoAnalyticsLocalDataStore(), new LogAnalyticsLocalDataStore(), new ErrorAnalyticsLocalDataStore(), new DefaultAnalyticsRemoteDataStore(new AnalyticsService(HttpClientFactory.INSTANCE.getAnalyticsHttpClient(environment), null, 2, null), clientKey, 50, 5, 5), new DefaultAnalyticsSetupProvider(application, shopperLocale, isCreatedByDropIn, analyticsParams.getLevel(), amount, source, sessionId), new AnalyticsTrackRequestProvider()), analyticsParams, null, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManagerFactory$Companion;", "", "()V", "ERROR_SIZE", "", "INFO_SIZE", "LOG_SIZE", "components-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

