/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.ComponentCallback;
import com.adyen.checkout.components.core.PaymentComponentState;
import com.adyen.checkout.components.core.internal.BaseComponentCallback;
import com.adyen.checkout.components.core.internal.ComponentEventHandler;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.exception.CheckoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u001e\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/adyen/checkout/components/core/internal/DefaultComponentEventHandler;", "T", "Lcom/adyen/checkout/components/core/PaymentComponentState;", "Lcom/adyen/checkout/components/core/internal/ComponentEventHandler;", "()V", "initialize", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "onCleared", "onPaymentComponentEvent", "event", "Lcom/adyen/checkout/components/core/internal/PaymentComponentEvent;", "componentCallback", "Lcom/adyen/checkout/components/core/internal/BaseComponentCallback;", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDefaultComponentEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultComponentEventHandler.kt\ncom/adyen/checkout/components/core/internal/DefaultComponentEventHandler\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n*L\n1#1,45:1\n16#2,17:46\n*S KotlinDebug\n*F\n+ 1 DefaultComponentEventHandler.kt\ncom/adyen/checkout/components/core/internal/DefaultComponentEventHandler\n*L\n32#1:46,17\n*E\n"})
public final class DefaultComponentEventHandler<T extends PaymentComponentState<?>>
implements ComponentEventHandler<T> {
    @Override
    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
    }

    @Override
    public void onCleared() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onPaymentComponentEvent(@NotNull PaymentComponentEvent<T> event, @NotNull BaseComponentCallback componentCallback) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)componentCallback, (String)"componentCallback");
        ComponentCallback componentCallback2 = componentCallback instanceof ComponentCallback ? (ComponentCallback)componentCallback : null;
        if (componentCallback2 == null) {
            throw new CheckoutException("Callback must be type of " + ComponentCallback.class.getCanonicalName(), null, 2, null);
        }
        ComponentCallback callback = componentCallback2;
        Object object = this;
        AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "Event received " + event;
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        object = event;
        if (object instanceof PaymentComponentEvent.ActionDetails) {
            callback.onAdditionalDetails(((PaymentComponentEvent.ActionDetails)event).getData());
        } else if (object instanceof PaymentComponentEvent.Error) {
            callback.onError(((PaymentComponentEvent.Error)event).getError());
        } else if (object instanceof PaymentComponentEvent.StateChanged) {
            callback.onStateChanged(((PaymentComponentEvent.StateChanged)event).getState());
        } else if (object instanceof PaymentComponentEvent.Submit) {
            callback.onSubmit(((PaymentComponentEvent.Submit)event).getState());
        } else if (object instanceof PaymentComponentEvent.PermissionRequest) {
            callback.onPermissionRequest(((PaymentComponentEvent.PermissionRequest)event).getRequiredPermission(), ((PaymentComponentEvent.PermissionRequest)event).getPermissionCallback());
        }
    }
}

