/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal;

import android.content.Context;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.AnalyticsConfiguration;
import com.adyen.checkout.components.core.internal.Configuration;
import com.adyen.checkout.components.core.internal.util.AmountExtensionsKt;
import com.adyen.checkout.components.core.internal.util.ValidationUtils;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.internal.util.LocaleUtil;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0017\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00002\u00020\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fB\u001f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\u000b\u0010(\u001a\u00028\u0000\u00a2\u0006\u0002\u0010)J\r\u0010*\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010)J\u0015\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010+J\u0013\u0010\u001a\u001a\u00028\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010,J\u0013\u0010&\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010-R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006."}, d2={"Lcom/adyen/checkout/components/core/internal/BaseConfigurationBuilder;", "ConfigurationT", "Lcom/adyen/checkout/components/core/internal/Configuration;", "BuilderT", "", "environment", "Lcom/adyen/checkout/core/Environment;", "clientKey", "", "(Lcom/adyen/checkout/core/Environment;Ljava/lang/String;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;Lcom/adyen/checkout/core/Environment;Ljava/lang/String;)V", "shopperLocale", "Ljava/util/Locale;", "(Ljava/util/Locale;Lcom/adyen/checkout/core/Environment;Ljava/lang/String;)V", "amount", "Lcom/adyen/checkout/components/core/Amount;", "getAmount", "()Lcom/adyen/checkout/components/core/Amount;", "setAmount", "(Lcom/adyen/checkout/components/core/Amount;)V", "analyticsConfiguration", "Lcom/adyen/checkout/components/core/AnalyticsConfiguration;", "getAnalyticsConfiguration", "()Lcom/adyen/checkout/components/core/AnalyticsConfiguration;", "setAnalyticsConfiguration", "(Lcom/adyen/checkout/components/core/AnalyticsConfiguration;)V", "getClientKey", "()Ljava/lang/String;", "setClientKey", "(Ljava/lang/String;)V", "getEnvironment", "()Lcom/adyen/checkout/core/Environment;", "setEnvironment", "(Lcom/adyen/checkout/core/Environment;)V", "getShopperLocale", "()Ljava/util/Locale;", "setShopperLocale", "(Ljava/util/Locale;)V", "build", "()Lcom/adyen/checkout/components/core/internal/Configuration;", "buildInternal", "(Lcom/adyen/checkout/components/core/Amount;)Lcom/adyen/checkout/components/core/internal/BaseConfigurationBuilder;", "(Lcom/adyen/checkout/components/core/AnalyticsConfiguration;)Lcom/adyen/checkout/components/core/internal/BaseConfigurationBuilder;", "(Ljava/util/Locale;)Lcom/adyen/checkout/components/core/internal/BaseConfigurationBuilder;", "components-core_release"})
public abstract class BaseConfigurationBuilder<ConfigurationT extends Configuration, BuilderT extends BaseConfigurationBuilder<ConfigurationT, BuilderT>> {
    @Nullable
    private Locale shopperLocale;
    @NotNull
    private Environment environment;
    @NotNull
    private String clientKey;
    @Nullable
    private AnalyticsConfiguration analyticsConfiguration;
    @Nullable
    private Amount amount;

    public BaseConfigurationBuilder(@Nullable Locale shopperLocale, @NotNull Environment environment, @NotNull String clientKey) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        this.shopperLocale = shopperLocale;
        this.environment = environment;
        this.clientKey = clientKey;
        if (!ValidationUtils.INSTANCE.isClientKeyValid$components_core_release(this.clientKey, this.environment)) {
            throw new CheckoutException("Client key is not valid.", null, 2, null);
        }
    }

    @Nullable
    protected final Locale getShopperLocale() {
        return this.shopperLocale;
    }

    protected final void setShopperLocale(@Nullable Locale locale) {
        this.shopperLocale = locale;
    }

    @NotNull
    protected final Environment getEnvironment() {
        return this.environment;
    }

    protected final void setEnvironment(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"<set-?>");
        this.environment = environment;
    }

    @NotNull
    protected final String getClientKey() {
        return this.clientKey;
    }

    protected final void setClientKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.clientKey = string;
    }

    @Nullable
    protected final AnalyticsConfiguration getAnalyticsConfiguration() {
        return this.analyticsConfiguration;
    }

    protected final void setAnalyticsConfiguration(@Nullable AnalyticsConfiguration analyticsConfiguration) {
        this.analyticsConfiguration = analyticsConfiguration;
    }

    @Nullable
    protected final Amount getAmount() {
        return this.amount;
    }

    protected final void setAmount(@Nullable Amount amount) {
        this.amount = amount;
    }

    public BaseConfigurationBuilder(@NotNull Environment environment, @NotNull String clientKey) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        this((Locale)null, environment, clientKey);
    }

    @Deprecated(message="You can omit the context parameter")
    public BaseConfigurationBuilder(@NotNull Context context, @NotNull Environment environment, @NotNull String clientKey) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        this((Locale)null, environment, clientKey);
    }

    @NotNull
    public final BuilderT setShopperLocale(@NotNull Locale shopperLocale) {
        Intrinsics.checkNotNullParameter((Object)shopperLocale, (String)"shopperLocale");
        this.shopperLocale = shopperLocale;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type BuilderT of com.adyen.checkout.components.core.internal.BaseConfigurationBuilder");
        return (BuilderT)this;
    }

    @NotNull
    public final BuilderT setAnalyticsConfiguration(@NotNull AnalyticsConfiguration analyticsConfiguration) {
        Intrinsics.checkNotNullParameter((Object)analyticsConfiguration, (String)"analyticsConfiguration");
        this.analyticsConfiguration = analyticsConfiguration;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type BuilderT of com.adyen.checkout.components.core.internal.BaseConfigurationBuilder");
        return (BuilderT)this;
    }

    @NotNull
    public BuilderT setAmount(@NotNull Amount amount) {
        Intrinsics.checkNotNullParameter((Object)((Object)amount), (String)"amount");
        AmountExtensionsKt.validate(amount);
        this.amount = amount;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type BuilderT of com.adyen.checkout.components.core.internal.BaseConfigurationBuilder");
        return (BuilderT)this;
    }

    @NotNull
    protected abstract ConfigurationT buildInternal();

    @NotNull
    public final ConfigurationT build() {
        Locale locale = this.shopperLocale;
        if (locale != null) {
            Locale it = locale;
            boolean bl = false;
            if (!LocaleUtil.isValidLocale((Locale)it)) {
                throw new CheckoutException("Invalid shopper locale: " + this.shopperLocale + ".", null, 2, null);
            }
        }
        return this.buildInternal();
    }
}

