/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.AnalyticsConfiguration;
import com.adyen.checkout.components.core.internal.Configuration;
import com.adyen.checkout.components.core.internal.util.CheckoutConfigurationMarker;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.internal.util.LocaleUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CheckoutConfigurationMarker
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 32\u00020\u0001:\u00013B\u000f\b\u0013\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BT\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0001H\u0007J\u0018\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u0001H\u0007J\b\u0010&\u001a\u00020'H\u0016J'\u0010(\u001a\u0004\u0018\u0001H)\"\b\b\u0000\u0010)*\u00020\u00012\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0+H\u0007\u00a2\u0006\u0002\u0010,J!\u0010-\u001a\u0004\u0018\u0001H)\"\b\b\u0000\u0010)*\u00020\u00012\u0006\u0010%\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\u0011H\u0002J\u0018\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020'H\u0016R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR%\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00064"}, d2={"Lcom/adyen/checkout/components/core/CheckoutConfiguration;", "Lcom/adyen/checkout/components/core/internal/Configuration;", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "environment", "Lcom/adyen/checkout/core/Environment;", "clientKey", "", "shopperLocale", "Ljava/util/Locale;", "amount", "Lcom/adyen/checkout/components/core/Amount;", "analyticsConfiguration", "Lcom/adyen/checkout/components/core/AnalyticsConfiguration;", "configurationBlock", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/adyen/checkout/core/Environment;Ljava/lang/String;Ljava/util/Locale;Lcom/adyen/checkout/components/core/Amount;Lcom/adyen/checkout/components/core/AnalyticsConfiguration;Lkotlin/jvm/functions/Function1;)V", "getAmount", "()Lcom/adyen/checkout/components/core/Amount;", "getAnalyticsConfiguration", "()Lcom/adyen/checkout/components/core/AnalyticsConfiguration;", "availableConfigurations", "", "getClientKey", "()Ljava/lang/String;", "getConfigurationBlock$annotations", "()V", "getEnvironment", "()Lcom/adyen/checkout/core/Environment;", "getShopperLocale", "()Ljava/util/Locale;", "addActionConfiguration", "configuration", "addConfiguration", "key", "describeContents", "", "getActionConfiguration", "T", "configClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lcom/adyen/checkout/components/core/internal/Configuration;", "getConfiguration", "(Ljava/lang/String;)Lcom/adyen/checkout/components/core/internal/Configuration;", "validateContents", "writeToParcel", "dest", "flags", "CREATOR", "components-core_release"})
@SourceDebugExtension(value={"SMAP\nCheckoutConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckoutConfiguration.kt\ncom/adyen/checkout/components/core/CheckoutConfiguration\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,155:1\n216#2,2:156\n*S KotlinDebug\n*F\n+ 1 CheckoutConfiguration.kt\ncom/adyen/checkout/components/core/CheckoutConfiguration\n*L\n135#1:156,2\n*E\n"})
public final class CheckoutConfiguration
implements Configuration {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @NotNull
    private final Environment environment;
    @NotNull
    private final String clientKey;
    @Nullable
    private final Locale shopperLocale;
    @Nullable
    private final Amount amount;
    @Nullable
    private final AnalyticsConfiguration analyticsConfiguration;
    @NotNull
    private final Function1<CheckoutConfiguration, Unit> configurationBlock;
    @NotNull
    private final Map<String, Configuration> availableConfigurations;

    public CheckoutConfiguration(@NotNull Environment environment, @NotNull String clientKey, @Nullable Locale shopperLocale, @Nullable Amount amount, @Nullable AnalyticsConfiguration analyticsConfiguration, @NotNull Function1<? super CheckoutConfiguration, Unit> configurationBlock) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        Intrinsics.checkNotNullParameter(configurationBlock, (String)"configurationBlock");
        this.environment = environment;
        this.clientKey = clientKey;
        this.shopperLocale = shopperLocale;
        this.amount = amount;
        this.analyticsConfiguration = analyticsConfiguration;
        this.configurationBlock = configurationBlock;
        this.availableConfigurations = new LinkedHashMap();
        CheckoutConfiguration checkoutConfiguration = this;
        this.configurationBlock.invoke((Object)checkoutConfiguration);
        this.validateContents();
    }

    public /* synthetic */ CheckoutConfiguration(Environment environment, String string, Locale locale, Amount amount, AnalyticsConfiguration analyticsConfiguration, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            locale = null;
        }
        if ((n & 8) != 0) {
            amount = null;
        }
        if ((n & 0x10) != 0) {
            analyticsConfiguration = null;
        }
        if ((n & 0x20) != 0) {
            function1 = 1.INSTANCE;
        }
        this(environment, string, locale, amount, analyticsConfiguration, (Function1<? super CheckoutConfiguration, Unit>)function1);
    }

    @Override
    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public String getClientKey() {
        return this.clientKey;
    }

    @Override
    @Nullable
    public Locale getShopperLocale() {
        return this.shopperLocale;
    }

    @Override
    @Nullable
    public Amount getAmount() {
        return this.amount;
    }

    @Override
    @Nullable
    public AnalyticsConfiguration getAnalyticsConfiguration() {
        return this.analyticsConfiguration;
    }

    private static /* synthetic */ void getConfigurationBlock$annotations() {
    }

    private final void validateContents() {
        Locale locale = this.getShopperLocale();
        if (locale != null) {
            Locale it = locale;
            boolean bl = false;
            if (!LocaleUtil.isValidLocale((Locale)it)) {
                throw new CheckoutException("Invalid shopper locale: " + this.getShopperLocale() + ".", null, 2, null);
            }
        }
    }

    @SuppressLint(value={"ParcelClassLoader"})
    private CheckoutConfiguration(Parcel parcel) {
        Serializable serializable = parcel.readSerializable();
        Locale locale = serializable instanceof Locale ? (Locale)serializable : null;
        Parcelable parcelable = parcel.readParcelable(Environment.class.getClassLoader());
        if (parcelable == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        serializable = (Environment)parcelable;
        String string = parcel.readString();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = string;
        Amount amount = (Amount)parcel.readParcelable(Amount.class.getClassLoader());
        Object object = (AnalyticsConfiguration)parcel.readParcelable(AnalyticsConfiguration.class.getClassLoader());
        Intrinsics.checkNotNull((Object)string3);
        this((Environment)serializable, string3, locale, amount, (AnalyticsConfiguration)object, null, 32, null);
        int size = parcel.readInt();
        int n = 0;
        while (n < size) {
            String key;
            int it = n++;
            boolean bl = false;
            if (parcel.readString() == null) {
                object = "Required value was null.";
                throw new IllegalArgumentException(object.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"requireNotNull(...)");
            Serializable serializable2 = parcel.readSerializable();
            Intrinsics.checkNotNull((Object)serializable2, (String)"null cannot be cast to non-null type java.lang.Class<com.adyen.checkout.components.core.internal.Configuration>");
            Class configClass = (Class)serializable2;
            Parcelable parcelable2 = parcel.readParcelable(configClass.getClassLoader());
            if (parcelable2 == null) {
                String string4 = "Required value was null.";
                throw new IllegalArgumentException(string4.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)parcelable2, (String)"requireNotNull(...)");
            Configuration config = (Configuration)parcelable2;
            this.availableConfigurations.put(key, config);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void addConfiguration(@NotNull String key, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.availableConfigurations.put(key, configuration);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void addActionConfiguration(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Map<String, Configuration> map2 = this.availableConfigurations;
        String string = configuration.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        map2.put(string, configuration);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final <T extends Configuration> T getConfiguration(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Configuration configuration = this.availableConfigurations.get(key);
        return (T)(configuration instanceof Configuration ? configuration : null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final <T extends Configuration> T getActionConfiguration(@NotNull Class<T> configClass) {
        Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
        Configuration configuration = this.availableConfigurations.get(configClass.getName());
        return (T)(configuration instanceof Configuration ? configuration : null);
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeSerializable((Serializable)this.getShopperLocale());
        dest.writeParcelable((Parcelable)this.getEnvironment(), flags);
        dest.writeString(this.getClientKey());
        dest.writeParcelable((Parcelable)this.getAmount(), flags);
        dest.writeParcelable((Parcelable)this.getAnalyticsConfiguration(), flags);
        dest.writeInt(this.availableConfigurations.size());
        Map<String, Configuration> $this$forEach$iv = this.availableConfigurations;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Configuration>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Configuration> element$iv;
            Map.Entry<String, Configuration> it = element$iv = iterator.next();
            boolean bl = false;
            dest.writeString(it.getKey());
            dest.writeSerializable((Serializable)it.getValue().getClass());
            dest.writeParcelable((Parcelable)it.getValue(), flags);
        }
    }

    public int describeContents() {
        return 1;
    }

    public /* synthetic */ CheckoutConfiguration(Parcel parcel, DefaultConstructorMarker $constructor_marker) {
        this(parcel);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/adyen/checkout/components/core/CheckoutConfiguration$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/adyen/checkout/components/core/CheckoutConfiguration;", "()V", "createFromParcel", "source", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/adyen/checkout/components/core/CheckoutConfiguration;", "components-core_release"})
    public static final class CREATOR
    implements Parcelable.Creator<CheckoutConfiguration> {
        private CREATOR() {
        }

        @NotNull
        public CheckoutConfiguration createFromParcel(@NotNull Parcel source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new CheckoutConfiguration(source, null);
        }

        @NotNull
        public CheckoutConfiguration[] newArray(int size) {
            return new CheckoutConfiguration[size];
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

