/*
 * Copyright (c) 2021 Adyen N.V.
 *
 * This file is open source and available under the MIT license. See the LICENSE file for more info.
 *
 * Created by josephj on 22/2/2021.
 */

package com.adyen.checkout.components.core.internal.data.api

import androidx.annotation.RestrictTo
import com.adyen.checkout.core.Environment

@RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
interface PublicKeyRepository {

    suspend fun fetchPublicKey(
        environment: Environment,
        clientKey: String
    ): Result<String>
}
