/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.util;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.core.Environment;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0002R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/adyen/checkout/components/core/internal/util/ValidationUtils;", "", "()V", "CLIENT_KEY_LIVE_PREFIX", "", "CLIENT_KEY_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CLIENT_KEY_REGEX", "CLIENT_KEY_TEST_PREFIX", "EMAIL_PATTERN", "EMAIL_REGEX", "getEMAIL_REGEX$annotations", "LIVE_ENVIRONMENTS", "", "Lcom/adyen/checkout/core/Environment;", "PHONE_PATTERN", "PHONE_REGEX", "doesClientKeyMatchEnvironment", "", "clientKey", "environment", "isClientKeyValid", "isEmailValid", "emailAddress", "isPhoneNumberValid", "phoneNumber", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ValidationUtils {
    @NotNull
    public static final ValidationUtils INSTANCE = new ValidationUtils();
    @NotNull
    private static final String EMAIL_REGEX = "^(([a-z0-9!#$%&'*+\\-/=?^_`{|}~]+(\\.[a-z0-9!#$%&'*+\\-/=?^_`{|}~]+)*)|(\".+\"))@((\\[((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}])|((?!-)[a-z0-9-]{1,63}(?<!-)(\\.[a-z0-9-]{1,63}(?<!-))*\\.[a-z]{2,}))$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^(([a-z0-9!#$%&'*+\\-/=?^_`{|}~]+(\\.[a-z0-9!#$%&'*+\\-/=?^_`{|}~]+)*)|(\".+\"))@((\\[((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}])|((?!-)[a-z0-9-]{1,63}(?<!-)(\\.[a-z0-9-]{1,63}(?<!-))*\\.[a-z]{2,}))$", 2);
    @NotNull
    private static final String PHONE_REGEX = "^\\D*(\\d\\D*){9,14}$";
    private static final Pattern PHONE_PATTERN = Pattern.compile("^\\D*(\\d\\D*){9,14}$");
    @NotNull
    private static final String CLIENT_KEY_REGEX = "([a-z]){4}\\_([A-z]|\\d){32}";
    private static final Pattern CLIENT_KEY_PATTERN = Pattern.compile("([a-z]){4}\\_([A-z]|\\d){32}");
    @NotNull
    private static final String CLIENT_KEY_TEST_PREFIX = "test_";
    @NotNull
    private static final String CLIENT_KEY_LIVE_PREFIX = "live_";
    @NotNull
    private static final List<Environment> LIVE_ENVIRONMENTS;

    private ValidationUtils() {
    }

    private static /* synthetic */ void getEMAIL_REGEX$annotations() {
    }

    public final boolean isPhoneNumberValid(@NotNull String phoneNumber) {
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        return PHONE_PATTERN.matcher(phoneNumber).matches();
    }

    public final boolean isEmailValid(@NotNull String emailAddress) {
        Intrinsics.checkNotNullParameter((Object)emailAddress, (String)"emailAddress");
        return EMAIL_PATTERN.matcher(emailAddress).matches();
    }

    public final boolean isClientKeyValid(@NotNull String clientKey) {
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        return CLIENT_KEY_PATTERN.matcher(clientKey).matches();
    }

    public final boolean doesClientKeyMatchEnvironment(@NotNull String clientKey, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        boolean isTestEnvironment = Intrinsics.areEqual((Object)environment, (Object)Environment.TEST);
        boolean isLiveEnvironment = LIVE_ENVIRONMENTS.contains(environment);
        return isLiveEnvironment && StringsKt.startsWith$default((String)clientKey, (String)CLIENT_KEY_LIVE_PREFIX, (boolean)false, (int)2, null) || isTestEnvironment && StringsKt.startsWith$default((String)clientKey, (String)CLIENT_KEY_TEST_PREFIX, (boolean)false, (int)2, null) || !isLiveEnvironment && !isTestEnvironment;
    }

    static {
        Object[] objectArray = new Environment[]{Environment.APSE, Environment.AUSTRALIA, Environment.EUROPE, Environment.INDIA, Environment.UNITED_STATES};
        LIVE_ENVIRONMENTS = CollectionsKt.listOf((Object[])objectArray);
    }
}

