/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.util;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/adyen/checkout/components/core/internal/util/DateUtils;", "", "()V", "DEFAULT_INPUT_DATE_FORMAT", "", "TAG", "formatStringDate", "date", "shopperLocale", "Ljava/util/Locale;", "inputFormat", "matchesFormat", "", "format", "parseDateToView", "month", "year", "toServerDateFormat", "calendar", "Ljava/util/Calendar;", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateUtils.kt\ncom/adyen/checkout/components/core/internal/util/DateUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class DateUtils {
    @NotNull
    public static final DateUtils INSTANCE = new DateUtils();
    @NotNull
    private static final String DEFAULT_INPUT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    @NotNull
    private static final String TAG = LogUtil.getTag();

    private DateUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String parseDateToView(@NotNull String month, @NotNull String year) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        return month + "/" + StringsKt.takeLast((String)year, (int)2);
    }

    @JvmStatic
    @NotNull
    public static final String toServerDateFormat(@NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        SimpleDateFormat serverDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        String string = serverDateFormat.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public final boolean matchesFormat(@NotNull String date, @NotNull String format) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.US);
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(date);
            bl = true;
        }
        catch (ParseException e) {
            Logger.e((String)TAG, (String)("Provided date " + date + " does not match the given format " + format));
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final String formatStringDate(@NotNull String date, @NotNull Locale shopperLocale, @NotNull String inputFormat) {
        String string;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)shopperLocale, (String)"shopperLocale");
        Intrinsics.checkNotNullParameter((Object)inputFormat, (String)"inputFormat");
        try {
            String string2;
            Date parsedDate;
            SimpleDateFormat inputSimpleFormat = new SimpleDateFormat(inputFormat, shopperLocale);
            DateFormat outputSimpleFormat = DateFormat.getDateInstance(3, shopperLocale);
            Date date2 = parsedDate = inputSimpleFormat.parse(date);
            if (date2 != null) {
                Date it = date2;
                boolean bl = false;
                string2 = outputSimpleFormat.format(it);
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (ParseException e) {
            Logger.e((String)TAG, (String)("Provided date " + date + " does not match the given format " + inputFormat));
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String formatStringDate$default(DateUtils dateUtils, String string, Locale locale, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = DEFAULT_INPUT_DATE_FORMAT;
        }
        return dateUtils.formatStringDate(string, locale, string2);
    }
}

