/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.util;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.CheckoutCurrency;
import com.adyen.checkout.core.exception.CheckoutException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/adyen/checkout/components/core/internal/util/CurrencyUtils;", "", "()V", "assertCurrency", "", "currencyCode", "", "formatAmount", "amount", "Lcom/adyen/checkout/components/core/Amount;", "locale", "Ljava/util/Locale;", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CurrencyUtils {
    @NotNull
    public static final CurrencyUtils INSTANCE = new CurrencyUtils();

    private CurrencyUtils() {
    }

    @NotNull
    public final String formatAmount(@NotNull Amount amount, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)((Object)amount), (String)"amount");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String currencyCode = amount.getCurrency();
        String string = currencyCode;
        if (string == null) {
            string = "";
        }
        CheckoutCurrency checkoutCurrency = CheckoutCurrency.Companion.find(string);
        Currency currency = Currency.getInstance(currencyCode);
        NumberFormat currencyFormat = DecimalFormat.getCurrencyInstance(locale);
        currencyFormat.setCurrency(currency);
        currencyFormat.setMinimumFractionDigits(checkoutCurrency.getFractionDigits());
        currencyFormat.setMaximumFractionDigits(checkoutCurrency.getFractionDigits());
        BigDecimal value = BigDecimal.valueOf(amount.getValue(), checkoutCurrency.getFractionDigits());
        String string2 = currencyFormat.format(value);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public final void assertCurrency(@Nullable String currencyCode) {
        if (!CheckoutCurrency.Companion.isSupported(currencyCode)) {
            throw new CheckoutException("Currency " + currencyCode + " not supported", null, 2, null);
        }
    }
}

