/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.util;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.CheckoutCurrency;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/adyen/checkout/components/core/internal/util/AmountFormat;", "", "()V", "TAG", "", "getFractionDigits", "", "currencyCode", "toBigDecimal", "Ljava/math/BigDecimal;", "amount", "Lcom/adyen/checkout/components/core/Amount;", "value", "", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AmountFormat {
    @NotNull
    public static final AmountFormat INSTANCE = new AmountFormat();
    @NotNull
    private static final String TAG = LogUtil.getTag();

    private AmountFormat() {
    }

    @JvmStatic
    @NotNull
    public static final BigDecimal toBigDecimal(@NotNull Amount amount) {
        Intrinsics.checkNotNullParameter((Object)((Object)amount), (String)"amount");
        long l = amount.getValue();
        String string = amount.getCurrency();
        Intrinsics.checkNotNull((Object)string);
        return INSTANCE.toBigDecimal(l, string);
    }

    private final BigDecimal toBigDecimal(long value, String currencyCode) {
        int fractionDigits = this.getFractionDigits(currencyCode);
        BigDecimal bigDecimal = BigDecimal.valueOf(value, fractionDigits);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return bigDecimal;
    }

    private final int getFractionDigits(String currencyCode) {
        CharSequence charSequence = currencyCode;
        Regex regex = new Regex("[^A-Z]");
        String string = "";
        charSequence = regex.replace(charSequence, string);
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = ((String)charSequence).toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String normalizedCurrencyCode = string2;
        try {
            CheckoutCurrency checkoutCurrency = CheckoutCurrency.Companion.find(normalizedCurrencyCode);
            return checkoutCurrency.getFractionDigits();
        }
        catch (CheckoutException e) {
            int n;
            Logger.e((String)TAG, (String)(normalizedCurrencyCode + " is an unsupported currency. Falling back to information from java.util.Currency."), (Throwable)e);
            try {
                Currency currency = Currency.getInstance(normalizedCurrencyCode);
                n = RangesKt.coerceAtLeast((int)currency.getDefaultFractionDigits(), (int)0);
            }
            catch (IllegalArgumentException e2) {
                Logger.e((String)TAG, (String)("Could not determine fraction digits for " + normalizedCurrencyCode), (Throwable)e2);
                n = 0;
            }
            return n;
        }
    }
}

