/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.data.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.internal.data.model.OrderPaymentMethod;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.internal.data.model.ModelObject;
import com.adyen.checkout.core.internal.data.model.ModelUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J%\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/adyen/checkout/components/core/internal/data/model/OrderStatusResponse;", "Lcom/adyen/checkout/core/internal/data/model/ModelObject;", "paymentMethods", "", "Lcom/adyen/checkout/components/core/internal/data/model/OrderPaymentMethod;", "remainingAmount", "Lcom/adyen/checkout/components/core/Amount;", "(Ljava/util/List;Lcom/adyen/checkout/components/core/Amount;)V", "getPaymentMethods", "()Ljava/util/List;", "getRemainingAmount", "()Lcom/adyen/checkout/components/core/Amount;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Parcelize
public final class OrderStatusResponse
extends ModelObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<OrderPaymentMethod> paymentMethods;
    @Nullable
    private final Amount remainingAmount;
    @NotNull
    public static final Parcelable.Creator<OrderStatusResponse> CREATOR;
    @NotNull
    private static final String PAYMENT_METHODS = "paymentMethods";
    @NotNull
    private static final String REMAINING_AMOUNT = "remainingAmount";
    @JvmField
    @NotNull
    public static final ModelObject.Serializer<OrderStatusResponse> SERIALIZER;

    public OrderStatusResponse(@NotNull List<OrderPaymentMethod> paymentMethods, @Nullable Amount remainingAmount) {
        Intrinsics.checkNotNullParameter(paymentMethods, (String)PAYMENT_METHODS);
        this.paymentMethods = paymentMethods;
        this.remainingAmount = remainingAmount;
    }

    @NotNull
    public final List<OrderPaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    @Nullable
    public final Amount getRemainingAmount() {
        return this.remainingAmount;
    }

    @NotNull
    public final List<OrderPaymentMethod> component1() {
        return this.paymentMethods;
    }

    @Nullable
    public final Amount component2() {
        return this.remainingAmount;
    }

    @NotNull
    public final OrderStatusResponse copy(@NotNull List<OrderPaymentMethod> paymentMethods, @Nullable Amount remainingAmount) {
        Intrinsics.checkNotNullParameter(paymentMethods, (String)PAYMENT_METHODS);
        return new OrderStatusResponse(paymentMethods, remainingAmount);
    }

    public static /* synthetic */ OrderStatusResponse copy$default(OrderStatusResponse orderStatusResponse, List list, Amount amount, int n, Object object) {
        if ((n & 1) != 0) {
            list = orderStatusResponse.paymentMethods;
        }
        if ((n & 2) != 0) {
            amount = orderStatusResponse.remainingAmount;
        }
        return orderStatusResponse.copy(list, amount);
    }

    @NotNull
    public String toString() {
        return "OrderStatusResponse(paymentMethods=" + this.paymentMethods + ", remainingAmount=" + this.remainingAmount + ")";
    }

    public int hashCode() {
        int result = ((Object)this.paymentMethods).hashCode();
        result = result * 31 + (this.remainingAmount == null ? 0 : this.remainingAmount.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OrderStatusResponse)) {
            return false;
        }
        OrderStatusResponse orderStatusResponse = (OrderStatusResponse)((Object)other);
        if (!Intrinsics.areEqual(this.paymentMethods, orderStatusResponse.paymentMethods)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)this.remainingAmount), (Object)((Object)orderStatusResponse.remainingAmount));
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Object object = this.paymentMethods;
        out.writeInt(object.size());
        Iterator<OrderPaymentMethod> iterator = object.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeToParcel(out, flags);
        }
        object = this.remainingAmount;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((Amount)((Object)object)).writeToParcel(out, flags);
        }
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<OrderStatusResponse> {
            @NotNull
            public final OrderStatusResponse[] newArray(int size) {
                return new OrderStatusResponse[size];
            }

            @NotNull
            public final OrderStatusResponse createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                for (int i = 0; i != n; ++i) {
                    arrayList.add(OrderPaymentMethod.CREATOR.createFromParcel(parcel));
                }
                Amount amount = (Amount)((Object)(parcel.readInt() == 0 ? null : Amount.CREATOR.createFromParcel(parcel)));
                List list = arrayList;
                return new OrderStatusResponse(list, amount);
            }
        }
        CREATOR = new Creator();
        SERIALIZER = (ModelObject.Serializer)new ModelObject.Serializer<OrderStatusResponse>(){

            @NotNull
            public JSONObject serialize(@NotNull OrderStatusResponse modelObject) {
                Intrinsics.checkNotNullParameter((Object)((Object)modelObject), (String)"modelObject");
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.putOpt("paymentMethods", (Object)ModelUtils.serializeOptList(modelObject.getPaymentMethods(), OrderPaymentMethod.SERIALIZER));
                    jsonObject.putOpt("remainingAmount", (Object)((Object)modelObject.getRemainingAmount()));
                }
                catch (JSONException e) {
                    throw new ModelSerializationException(OrderStatusResponse.class, e);
                }
                return jsonObject;
            }

            @NotNull
            public OrderStatusResponse deserialize(@NotNull JSONObject jsonObject) {
                OrderStatusResponse orderStatusResponse;
                Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
                try {
                    List list = ModelUtils.deserializeOptList((JSONArray)jsonObject.optJSONArray("paymentMethods"), OrderPaymentMethod.SERIALIZER);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    orderStatusResponse = new OrderStatusResponse(list, (Amount)ModelUtils.deserializeOpt((JSONObject)jsonObject.optJSONObject("remainingAmount"), Amount.SERIALIZER));
                }
                catch (JSONException e) {
                    throw new ModelSerializationException(OrderStatusResponse.class, e);
                }
                return orderStatusResponse;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/components/core/internal/data/model/OrderStatusResponse$Companion;", "", "()V", "PAYMENT_METHODS", "", "REMAINING_AMOUNT", "SERIALIZER", "Lcom/adyen/checkout/core/internal/data/model/ModelObject$Serializer;", "Lcom/adyen/checkout/components/core/internal/data/model/OrderStatusResponse;", "components-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

