/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.data.api;

import android.app.Application;
import android.content.Context;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.StoredPaymentMethod;
import com.adyen.checkout.components.core.internal.data.model.AnalyticsSource;
import com.adyen.checkout.components.core.internal.ui.model.AnalyticsParamsLevel;
import com.adyen.checkout.components.core.internal.ui.model.ComponentParams;
import com.adyen.checkout.components.core.internal.util.ContextExtensionsKt;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\rB3\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\t\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0011BW\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\t\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0017\u001a\u00020\t\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u001eJ\t\u0010/\u001a\u00020\u0013H\u00c6\u0003J\t\u00100\u001a\u00020\tH\u00c6\u0003J\t\u00101\u001a\u00020\u0016H\u00c6\u0003J\t\u00102\u001a\u00020\u000fH\u00c6\u0003J\t\u00103\u001a\u00020\tH\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003J\t\u00105\u001a\u00020\u001bH\u00c6\u0003J\u000f\u00106\u001a\b\u0012\u0004\u0012\u00020\t0\u001dH\u00c6\u0003J\u000b\u00107\u001a\u0004\u0018\u00010\tH\u00c6\u0003Jm\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\t2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020\u001bH\u00d6\u0001J\t\u0010=\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0017\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\"R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\"R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006>"}, d2={"Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepositoryData;", "", "application", "Landroid/app/Application;", "componentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "sessionId", "", "(Landroid/app/Application;Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;Lcom/adyen/checkout/components/core/PaymentMethod;Ljava/lang/String;)V", "storedPaymentMethod", "Lcom/adyen/checkout/components/core/StoredPaymentMethod;", "(Landroid/app/Application;Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;Lcom/adyen/checkout/components/core/StoredPaymentMethod;Ljava/lang/String;)V", "source", "Lcom/adyen/checkout/components/core/internal/data/model/AnalyticsSource;", "paymentMethodType", "(Landroid/app/Application;Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;Lcom/adyen/checkout/components/core/internal/data/model/AnalyticsSource;Ljava/lang/String;Ljava/lang/String;)V", "level", "Lcom/adyen/checkout/components/core/internal/ui/model/AnalyticsParamsLevel;", "packageName", "locale", "Ljava/util/Locale;", "clientKey", "amount", "Lcom/adyen/checkout/components/core/Amount;", "screenWidth", "", "paymentMethods", "", "(Lcom/adyen/checkout/components/core/internal/ui/model/AnalyticsParamsLevel;Ljava/lang/String;Ljava/util/Locale;Lcom/adyen/checkout/components/core/internal/data/model/AnalyticsSource;Ljava/lang/String;Lcom/adyen/checkout/components/core/Amount;ILjava/util/List;Ljava/lang/String;)V", "getAmount", "()Lcom/adyen/checkout/components/core/Amount;", "getClientKey", "()Ljava/lang/String;", "getLevel", "()Lcom/adyen/checkout/components/core/internal/ui/model/AnalyticsParamsLevel;", "getLocale", "()Ljava/util/Locale;", "getPackageName", "getPaymentMethods", "()Ljava/util/List;", "getScreenWidth", "()I", "getSessionId", "getSource", "()Lcom/adyen/checkout/components/core/internal/data/model/AnalyticsSource;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AnalyticsRepositoryData {
    @NotNull
    private final AnalyticsParamsLevel level;
    @NotNull
    private final String packageName;
    @NotNull
    private final Locale locale;
    @NotNull
    private final AnalyticsSource source;
    @NotNull
    private final String clientKey;
    @Nullable
    private final Amount amount;
    private final int screenWidth;
    @NotNull
    private final List<String> paymentMethods;
    @Nullable
    private final String sessionId;

    public AnalyticsRepositoryData(@NotNull AnalyticsParamsLevel level, @NotNull String packageName, @NotNull Locale locale, @NotNull AnalyticsSource source, @NotNull String clientKey, @Nullable Amount amount, int screenWidth, @NotNull List<String> paymentMethods, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        Intrinsics.checkNotNullParameter(paymentMethods, (String)"paymentMethods");
        this.level = level;
        this.packageName = packageName;
        this.locale = locale;
        this.source = source;
        this.clientKey = clientKey;
        this.amount = amount;
        this.screenWidth = screenWidth;
        this.paymentMethods = paymentMethods;
        this.sessionId = sessionId;
    }

    @NotNull
    public final AnalyticsParamsLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    @NotNull
    public final AnalyticsSource getSource() {
        return this.source;
    }

    @NotNull
    public final String getClientKey() {
        return this.clientKey;
    }

    @Nullable
    public final Amount getAmount() {
        return this.amount;
    }

    public final int getScreenWidth() {
        return this.screenWidth;
    }

    @NotNull
    public final List<String> getPaymentMethods() {
        return this.paymentMethods;
    }

    @Nullable
    public final String getSessionId() {
        return this.sessionId;
    }

    public AnalyticsRepositoryData(@NotNull Application application, @NotNull ComponentParams componentParams, @NotNull PaymentMethod paymentMethod, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)((Object)paymentMethod), (String)"paymentMethod");
        this(application, componentParams, new AnalyticsSource.PaymentComponent(componentParams.isCreatedByDropIn(), paymentMethod), paymentMethod.getType(), sessionId);
    }

    public /* synthetic */ AnalyticsRepositoryData(Application application, ComponentParams componentParams, PaymentMethod paymentMethod, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(application, componentParams, paymentMethod, string);
    }

    public AnalyticsRepositoryData(@NotNull Application application, @NotNull ComponentParams componentParams, @NotNull StoredPaymentMethod storedPaymentMethod, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)((Object)storedPaymentMethod), (String)"storedPaymentMethod");
        this(application, componentParams, new AnalyticsSource.PaymentComponent(componentParams.isCreatedByDropIn(), storedPaymentMethod), storedPaymentMethod.getType(), sessionId);
    }

    public /* synthetic */ AnalyticsRepositoryData(Application application, ComponentParams componentParams, StoredPaymentMethod storedPaymentMethod, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(application, componentParams, storedPaymentMethod, string);
    }

    private AnalyticsRepositoryData(Application application, ComponentParams componentParams, AnalyticsSource source, String paymentMethodType, String sessionId) {
        AnalyticsParamsLevel analyticsParamsLevel = componentParams.getAnalyticsParams().getLevel();
        String string = application.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        this(analyticsParamsLevel, string, componentParams.getShopperLocale(), source, componentParams.getClientKey(), componentParams.getAmount(), ContextExtensionsKt.getScreenWidthPixels((Context)application), CollectionsKt.listOfNotNull((Object)paymentMethodType), sessionId);
    }

    @NotNull
    public final AnalyticsParamsLevel component1() {
        return this.level;
    }

    @NotNull
    public final String component2() {
        return this.packageName;
    }

    @NotNull
    public final Locale component3() {
        return this.locale;
    }

    @NotNull
    public final AnalyticsSource component4() {
        return this.source;
    }

    @NotNull
    public final String component5() {
        return this.clientKey;
    }

    @Nullable
    public final Amount component6() {
        return this.amount;
    }

    public final int component7() {
        return this.screenWidth;
    }

    @NotNull
    public final List<String> component8() {
        return this.paymentMethods;
    }

    @Nullable
    public final String component9() {
        return this.sessionId;
    }

    @NotNull
    public final AnalyticsRepositoryData copy(@NotNull AnalyticsParamsLevel level, @NotNull String packageName, @NotNull Locale locale, @NotNull AnalyticsSource source, @NotNull String clientKey, @Nullable Amount amount, int screenWidth, @NotNull List<String> paymentMethods, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        Intrinsics.checkNotNullParameter(paymentMethods, (String)"paymentMethods");
        return new AnalyticsRepositoryData(level, packageName, locale, source, clientKey, amount, screenWidth, paymentMethods, sessionId);
    }

    public static /* synthetic */ AnalyticsRepositoryData copy$default(AnalyticsRepositoryData analyticsRepositoryData, AnalyticsParamsLevel analyticsParamsLevel, String string, Locale locale, AnalyticsSource analyticsSource, String string2, Amount amount, int n, List list, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            analyticsParamsLevel = analyticsRepositoryData.level;
        }
        if ((n2 & 2) != 0) {
            string = analyticsRepositoryData.packageName;
        }
        if ((n2 & 4) != 0) {
            locale = analyticsRepositoryData.locale;
        }
        if ((n2 & 8) != 0) {
            analyticsSource = analyticsRepositoryData.source;
        }
        if ((n2 & 0x10) != 0) {
            string2 = analyticsRepositoryData.clientKey;
        }
        if ((n2 & 0x20) != 0) {
            amount = analyticsRepositoryData.amount;
        }
        if ((n2 & 0x40) != 0) {
            n = analyticsRepositoryData.screenWidth;
        }
        if ((n2 & 0x80) != 0) {
            list = analyticsRepositoryData.paymentMethods;
        }
        if ((n2 & 0x100) != 0) {
            string3 = analyticsRepositoryData.sessionId;
        }
        return analyticsRepositoryData.copy(analyticsParamsLevel, string, locale, analyticsSource, string2, amount, n, list, string3);
    }

    @NotNull
    public String toString() {
        return "AnalyticsRepositoryData(level=" + this.level + ", packageName=" + this.packageName + ", locale=" + this.locale + ", source=" + this.source + ", clientKey=" + this.clientKey + ", amount=" + this.amount + ", screenWidth=" + this.screenWidth + ", paymentMethods=" + this.paymentMethods + ", sessionId=" + this.sessionId + ")";
    }

    public int hashCode() {
        int result = this.level.hashCode();
        result = result * 31 + this.packageName.hashCode();
        result = result * 31 + this.locale.hashCode();
        result = result * 31 + this.source.hashCode();
        result = result * 31 + this.clientKey.hashCode();
        result = result * 31 + (this.amount == null ? 0 : this.amount.hashCode());
        result = result * 31 + Integer.hashCode(this.screenWidth);
        result = result * 31 + ((Object)this.paymentMethods).hashCode();
        result = result * 31 + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnalyticsRepositoryData)) {
            return false;
        }
        AnalyticsRepositoryData analyticsRepositoryData = (AnalyticsRepositoryData)other;
        if (this.level != analyticsRepositoryData.level) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.packageName, (Object)analyticsRepositoryData.packageName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.locale, (Object)analyticsRepositoryData.locale)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.source, (Object)analyticsRepositoryData.source)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientKey, (Object)analyticsRepositoryData.clientKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.amount), (Object)((Object)analyticsRepositoryData.amount))) {
            return false;
        }
        if (this.screenWidth != analyticsRepositoryData.screenWidth) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paymentMethods, analyticsRepositoryData.paymentMethods)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sessionId, (Object)analyticsRepositoryData.sessionId);
    }
}

