/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal.data.api;

import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsPlatform;
import com.adyen.checkout.components.core.internal.data.model.AnalyticsSetupRequest;
import com.adyen.checkout.components.core.internal.data.model.AnalyticsSource;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\t\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002JO\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0016\u00a8\u0006\u0019"}, d2={"Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsMapper;", "", "()V", "getAnalyticsSetupRequest", "Lcom/adyen/checkout/components/core/internal/data/model/AnalyticsSetupRequest;", "packageName", "", "locale", "Ljava/util/Locale;", "source", "Lcom/adyen/checkout/components/core/internal/data/model/AnalyticsSource;", "amount", "Lcom/adyen/checkout/components/core/Amount;", "screenWidth", "", "paymentMethods", "", "sessionId", "getAnalyticsSetupRequest$components_core_release", "getComponentQueryParameter", "getComponentQueryParameter$components_core_release", "getFlavorQueryParameter", "getFlavorQueryParameter$components_core_release", "Companion", "Flavor", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AnalyticsMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DROP_IN_COMPONENT = "dropin";
    @NotNull
    private static final String ANDROID_CHANNEL = "android";
    @NotNull
    private static String actualPlatform = AnalyticsPlatform.ANDROID.getValue();
    @NotNull
    private static String actualVersion = "5.2.0";

    @NotNull
    public final AnalyticsSetupRequest getAnalyticsSetupRequest$components_core_release(@NotNull String packageName, @NotNull Locale locale, @NotNull AnalyticsSource source, @Nullable Amount amount, long screenWidth, @NotNull List<String> paymentMethods, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(paymentMethods, (String)"paymentMethods");
        String string = actualVersion;
        String string2 = actualPlatform;
        String string3 = locale.toString();
        String string4 = this.getComponentQueryParameter$components_core_release(source);
        String string5 = this.getFlavorQueryParameter$components_core_release(source);
        String string6 = Build.BRAND;
        String string7 = Build.MODEL;
        String string8 = String.valueOf(Build.VERSION.SDK_INT);
        return new AnalyticsSetupRequest(string, ANDROID_CHANNEL, string2, string3, string4, string5, string6, string7, packageName, string8, null, screenWidth, paymentMethods, amount, sessionId);
    }

    @VisibleForTesting
    @NotNull
    public final String getFlavorQueryParameter$components_core_release(@NotNull AnalyticsSource source) {
        Flavor flavor;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        AnalyticsSource analyticsSource = source;
        if (analyticsSource instanceof AnalyticsSource.DropIn) {
            flavor = Flavor.DROP_IN;
        } else if (analyticsSource instanceof AnalyticsSource.PaymentComponent) {
            flavor = ((AnalyticsSource.PaymentComponent)source).isCreatedByDropIn$components_core_release() ? Flavor.DROP_IN : Flavor.COMPONENTS;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return flavor.getValue();
    }

    @VisibleForTesting
    @NotNull
    public final String getComponentQueryParameter$components_core_release(@NotNull AnalyticsSource source) {
        String string;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        AnalyticsSource analyticsSource = source;
        if (analyticsSource instanceof AnalyticsSource.DropIn) {
            string = DROP_IN_COMPONENT;
        } else if (analyticsSource instanceof AnalyticsSource.PaymentComponent) {
            string = ((AnalyticsSource.PaymentComponent)source).getPaymentMethodType$components_core_release();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\r\u0010\r\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsMapper$Companion;", "", "()V", "ANDROID_CHANNEL", "", "DROP_IN_COMPONENT", "actualPlatform", "actualVersion", "overrideForCrossPlatform", "", "platform", "Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsPlatform;", "version", "resetToDefaults", "resetToDefaults$components_core_release", "components-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final void overrideForCrossPlatform(@NotNull AnalyticsPlatform platform, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)((Object)platform), (String)"platform");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            actualPlatform = platform.getValue();
            actualVersion = version;
        }

        @VisibleForTesting
        public final void resetToDefaults$components_core_release() {
            actualPlatform = AnalyticsPlatform.ANDROID.getValue();
            actualVersion = "5.2.0";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsMapper$Flavor;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "DROP_IN", "COMPONENTS", "components-core_release"})
    private static final class Flavor
    extends Enum<Flavor> {
        @NotNull
        private final String value;
        public static final /* enum */ Flavor DROP_IN = new Flavor("dropin");
        public static final /* enum */ Flavor COMPONENTS = new Flavor("components");
        private static final /* synthetic */ Flavor[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Flavor(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static Flavor[] values() {
            return (Flavor[])$VALUES.clone();
        }

        public static Flavor valueOf(String value) {
            return Enum.valueOf(Flavor.class, value);
        }

        @NotNull
        public static EnumEntries<Flavor> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = flavorArray = new Flavor[]{Flavor.DROP_IN, Flavor.COMPONENTS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

