/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.internal;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.components.core.ComponentCallback;
import com.adyen.checkout.components.core.PaymentComponentState;
import com.adyen.checkout.components.core.internal.BaseComponentCallback;
import com.adyen.checkout.components.core.internal.ComponentEventHandler;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u001e\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/adyen/checkout/components/core/internal/DefaultComponentEventHandler;", "T", "Lcom/adyen/checkout/components/core/PaymentComponentState;", "Lcom/adyen/checkout/components/core/internal/ComponentEventHandler;", "()V", "initialize", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "onCleared", "onPaymentComponentEvent", "event", "Lcom/adyen/checkout/components/core/internal/PaymentComponentEvent;", "componentCallback", "Lcom/adyen/checkout/components/core/internal/BaseComponentCallback;", "Companion", "components-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DefaultComponentEventHandler<T extends PaymentComponentState<?>>
implements ComponentEventHandler<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = LogUtil.getTag();

    @Override
    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
    }

    @Override
    public void onCleared() {
    }

    @Override
    public void onPaymentComponentEvent(@NotNull PaymentComponentEvent<T> event, @NotNull BaseComponentCallback componentCallback) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)componentCallback, (String)"componentCallback");
        ComponentCallback componentCallback2 = componentCallback instanceof ComponentCallback ? (ComponentCallback)componentCallback : null;
        if (componentCallback2 == null) {
            throw new CheckoutException("Callback must be type of " + ComponentCallback.class.getCanonicalName(), null, 2, null);
        }
        ComponentCallback callback = componentCallback2;
        Logger.v((String)TAG, (String)("Event received " + event));
        PaymentComponentEvent<T> paymentComponentEvent = event;
        if (paymentComponentEvent instanceof PaymentComponentEvent.ActionDetails) {
            callback.onAdditionalDetails(((PaymentComponentEvent.ActionDetails)event).getData());
        } else if (paymentComponentEvent instanceof PaymentComponentEvent.Error) {
            callback.onError(((PaymentComponentEvent.Error)event).getError());
        } else if (paymentComponentEvent instanceof PaymentComponentEvent.StateChanged) {
            callback.onStateChanged(((PaymentComponentEvent.StateChanged)event).getState());
        } else if (paymentComponentEvent instanceof PaymentComponentEvent.Submit) {
            callback.onSubmit(((PaymentComponentEvent.Submit)event).getState());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/components/core/internal/DefaultComponentEventHandler$Companion;", "", "()V", "TAG", "", "components-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

