/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.components.core.action;

import com.adyen.checkout.components.core.action.AwaitAction;
import com.adyen.checkout.components.core.action.QrCodeAction;
import com.adyen.checkout.components.core.action.RedirectAction;
import com.adyen.checkout.components.core.action.SdkAction;
import com.adyen.checkout.components.core.action.Threeds2Action;
import com.adyen.checkout.components.core.action.Threeds2ChallengeAction;
import com.adyen.checkout.components.core.action.Threeds2FingerprintAction;
import com.adyen.checkout.components.core.action.VoucherAction;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.internal.data.model.ModelObject;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u0004\u0018\u00010\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u0004\u0018\u00010\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/adyen/checkout/components/core/action/Action;", "Lcom/adyen/checkout/core/internal/data/model/ModelObject;", "()V", "paymentData", "", "getPaymentData", "()Ljava/lang/String;", "setPaymentData", "(Ljava/lang/String;)V", "paymentMethodType", "getPaymentMethodType", "setPaymentMethodType", "type", "getType", "setType", "Companion", "components-core_release"})
public abstract class Action
extends ModelObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TYPE = "type";
    @NotNull
    public static final String PAYMENT_DATA = "paymentData";
    @NotNull
    public static final String PAYMENT_METHOD_TYPE = "paymentMethodType";
    @JvmField
    @NotNull
    public static final ModelObject.Serializer<Action> SERIALIZER = (ModelObject.Serializer)new ModelObject.Serializer<Action>(){

        @NotNull
        public JSONObject serialize(@NotNull Action modelObject) {
            Intrinsics.checkNotNullParameter((Object)((Object)modelObject), (String)"modelObject");
            String actionType = modelObject.getType();
            CharSequence charSequence = actionType;
            if (charSequence == null || charSequence.length() == 0) {
                throw new CheckoutException("Action type not found", null, 2, null);
            }
            return Action.Companion.getChildSerializer(actionType).serialize((ModelObject)modelObject);
        }

        @NotNull
        public Action deserialize(@NotNull JSONObject jsonObject) {
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            String actionType = jsonObject.optString("type");
            Intrinsics.checkNotNull((Object)actionType);
            if (((CharSequence)actionType).length() == 0) {
                throw new CheckoutException("Action type not found", null, 2, null);
            }
            ModelObject.Serializer<Action> serializer = Action.Companion.getChildSerializer(actionType);
            return (Action)serializer.deserialize(jsonObject);
        }
    };

    @Nullable
    public abstract String getType();

    public abstract void setType(@Nullable String var1);

    @Nullable
    public abstract String getPaymentData();

    public abstract void setPaymentData(@Nullable String var1);

    @Nullable
    public abstract String getPaymentMethodType();

    public abstract void setPaymentMethodType(@Nullable String var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/adyen/checkout/components/core/action/Action$Companion;", "", "()V", "PAYMENT_DATA", "", "PAYMENT_METHOD_TYPE", "SERIALIZER", "Lcom/adyen/checkout/core/internal/data/model/ModelObject$Serializer;", "Lcom/adyen/checkout/components/core/action/Action;", "TYPE", "getChildSerializer", "actionType", "components-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelObject.Serializer<Action> getChildSerializer(@NotNull String actionType) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
            switch (actionType) {
                case "redirect": {
                    object = RedirectAction.SERIALIZER;
                    break;
                }
                case "threeDS2Fingerprint": {
                    object = Threeds2FingerprintAction.SERIALIZER;
                    break;
                }
                case "threeDS2Challenge": {
                    object = Threeds2ChallengeAction.SERIALIZER;
                    break;
                }
                case "threeDS2": {
                    object = Threeds2Action.SERIALIZER;
                    break;
                }
                case "qrCode": {
                    object = QrCodeAction.SERIALIZER;
                    break;
                }
                case "voucher": {
                    object = VoucherAction.SERIALIZER;
                    break;
                }
                case "sdk": {
                    object = SdkAction.SERIALIZER;
                    break;
                }
                case "await": {
                    object = AwaitAction.SERIALIZER;
                    break;
                }
                default: {
                    throw new CheckoutException("Action type not found - " + actionType, null, 2, null);
                }
            }
            Object childSerializer = object;
            Intrinsics.checkNotNull(childSerializer, (String)"null cannot be cast to non-null type com.adyen.checkout.core.internal.data.model.ModelObject.Serializer<com.adyen.checkout.components.core.action.Action>");
            return childSerializer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

