/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.ui.validation;

import com.adyen.checkout.core.CardBrand;
import com.adyen.checkout.core.CardType;
import com.adyen.checkout.core.internal.util.StringUtil;
import com.adyen.checkout.core.ui.validation.CardSecurityCodeValidationResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/adyen/checkout/core/ui/validation/CardSecurityCodeValidator;", "", "()V", "AMEX_SECURITY_CODE_SIZE", "", "GENERAL_CARD_SECURITY_CODE_SIZE", "validateSecurityCode", "Lcom/adyen/checkout/core/ui/validation/CardSecurityCodeValidationResult;", "securityCode", "", "cardBrand", "Lcom/adyen/checkout/core/CardBrand;", "checkout-core_release"})
public final class CardSecurityCodeValidator {
    @NotNull
    public static final CardSecurityCodeValidator INSTANCE = new CardSecurityCodeValidator();
    private static final int GENERAL_CARD_SECURITY_CODE_SIZE = 3;
    private static final int AMEX_SECURITY_CODE_SIZE = 4;

    private CardSecurityCodeValidator() {
    }

    @NotNull
    public final CardSecurityCodeValidationResult validateSecurityCode(@NotNull String securityCode, @Nullable CardBrand cardBrand) {
        Intrinsics.checkNotNullParameter((Object)securityCode, (String)"securityCode");
        String normalizedSecurityCode = StringUtil.normalize(securityCode, new char[0]);
        int length = normalizedSecurityCode.length();
        return !StringUtil.INSTANCE.isDigitsAndSeparatorsOnly(normalizedSecurityCode, new char[0]) ? (CardSecurityCodeValidationResult)new CardSecurityCodeValidationResult.Invalid() : (Intrinsics.areEqual((Object)cardBrand, (Object)new CardBrand(CardType.AMERICAN_EXPRESS)) && length == 4 ? (CardSecurityCodeValidationResult)new CardSecurityCodeValidationResult.Valid() : (!Intrinsics.areEqual((Object)cardBrand, (Object)new CardBrand(CardType.AMERICAN_EXPRESS)) && length == 3 ? (CardSecurityCodeValidationResult)new CardSecurityCodeValidationResult.Valid() : (CardSecurityCodeValidationResult)new CardSecurityCodeValidationResult.Invalid()));
    }

    public static /* synthetic */ CardSecurityCodeValidationResult validateSecurityCode$default(CardSecurityCodeValidator cardSecurityCodeValidator, String string, CardBrand cardBrand, int n, Object object) {
        if ((n & 2) != 0) {
            cardBrand = null;
        }
        return cardSecurityCodeValidator.validateSecurityCode(string, cardBrand);
    }
}

