/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.ui.validation;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.core.internal.util.StringUtil;
import com.adyen.checkout.core.ui.validation.CardNumberValidationResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/adyen/checkout/core/ui/validation/CardNumberValidator;", "", "()V", "FIVE_DIGIT", "", "MAXIMUM_CARD_NUMBER_LENGTH", "MINIMUM_CARD_NUMBER_LENGTH", "RADIX", "isLuhnChecksumValid", "", "normalizedNumber", "", "validateCardNumber", "Lcom/adyen/checkout/core/ui/validation/CardNumberValidationResult;", "number", "enableLuhnCheck", "checkout-core_release"})
public final class CardNumberValidator {
    @NotNull
    public static final CardNumberValidator INSTANCE = new CardNumberValidator();
    private static final int RADIX = 10;
    private static final int FIVE_DIGIT = 5;
    private static final int MINIMUM_CARD_NUMBER_LENGTH = 12;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int MAXIMUM_CARD_NUMBER_LENGTH = 19;

    private CardNumberValidator() {
    }

    @NotNull
    public final CardNumberValidationResult validateCardNumber(@NotNull String number, boolean enableLuhnCheck) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        String normalizedNumber = StringUtil.normalize(number, new char[0]);
        int length = normalizedNumber.length();
        return !StringUtil.INSTANCE.isDigitsAndSeparatorsOnly(normalizedNumber, new char[0]) ? (CardNumberValidationResult)new CardNumberValidationResult.Invalid.IllegalCharacters() : (length > 19 ? (CardNumberValidationResult)new CardNumberValidationResult.Invalid.TooLong() : (length < 12 ? (CardNumberValidationResult)new CardNumberValidationResult.Invalid.TooShort() : (enableLuhnCheck && !this.isLuhnChecksumValid(normalizedNumber) ? (CardNumberValidationResult)new CardNumberValidationResult.Invalid.LuhnCheck() : (CardNumberValidationResult)new CardNumberValidationResult.Valid())));
    }

    private final boolean isLuhnChecksumValid(String normalizedNumber) {
        int s1 = 0;
        int s2 = 0;
        String string = new StringBuffer(normalizedNumber).reverse().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String reverse = string;
        int n = reverse.length();
        for (int i = 0; i < n; ++i) {
            int digit = Character.digit(reverse.charAt(i), 10);
            if (i % 2 == 0) {
                s1 += digit;
                continue;
            }
            s2 += 2 * digit;
            if (digit < 5) continue;
            s2 -= 9;
        }
        return (s1 + s2) % 10 == 0;
    }
}

