/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.ui.validation;

import androidx.annotation.VisibleForTesting;
import com.adyen.checkout.core.ui.model.ExpiryDate;
import com.adyen.checkout.core.ui.validation.CardExpiryDateValidationResult;
import java.util.Calendar;
import java.util.GregorianCalendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/adyen/checkout/core/ui/validation/CardExpiryDateValidator;", "", "()V", "MAXIMUM_EXPIRED_MONTHS", "", "MAXIMUM_YEARS_IN_FUTURE", "MONTHS_IN_YEAR", "dateExists", "", "expiryDate", "Lcom/adyen/checkout/core/ui/model/ExpiryDate;", "getExpiryCalendar", "Ljava/util/Calendar;", "isInMaxYearRange", "calendar", "isInMinMonthRange", "isValidMonth", "month", "validateExpiryDate", "Lcom/adyen/checkout/core/ui/validation/CardExpiryDateValidationResult;", "validateExpiryDate$checkout_core_release", "checkout-core_release"})
public final class CardExpiryDateValidator {
    @NotNull
    public static final CardExpiryDateValidator INSTANCE = new CardExpiryDateValidator();
    private static final int MONTHS_IN_YEAR = 12;
    private static final int MAXIMUM_YEARS_IN_FUTURE = 30;
    private static final int MAXIMUM_EXPIRED_MONTHS = 3;

    private CardExpiryDateValidator() {
    }

    @NotNull
    public final CardExpiryDateValidationResult validateExpiryDate(@NotNull ExpiryDate expiryDate) {
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        Calendar calendar = GregorianCalendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance(...)");
        return this.validateExpiryDate$checkout_core_release(expiryDate, calendar);
    }

    @VisibleForTesting
    @NotNull
    public final CardExpiryDateValidationResult validateExpiryDate$checkout_core_release(@NotNull ExpiryDate expiryDate, @NotNull Calendar calendar) {
        CardExpiryDateValidationResult cardExpiryDateValidationResult;
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        if (this.dateExists(expiryDate)) {
            boolean isInMaxYearRange = this.isInMaxYearRange(expiryDate, calendar);
            boolean isInMinMonthRange = this.isInMinMonthRange(expiryDate, calendar);
            cardExpiryDateValidationResult = isInMinMonthRange && isInMaxYearRange ? (CardExpiryDateValidationResult)new CardExpiryDateValidationResult.Valid() : (!isInMaxYearRange ? (CardExpiryDateValidationResult)new CardExpiryDateValidationResult.Invalid.TooFarInTheFuture() : (CardExpiryDateValidationResult)new CardExpiryDateValidationResult.Invalid.TooOld());
        } else {
            cardExpiryDateValidationResult = new CardExpiryDateValidationResult.Invalid.NonParseableDate();
        }
        return cardExpiryDateValidationResult;
    }

    private final boolean isInMaxYearRange(ExpiryDate expiryDate, Calendar calendar) {
        Calendar expiryDateCalendar = this.getExpiryCalendar(expiryDate);
        Object object = calendar.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.GregorianCalendar");
        GregorianCalendar maxFutureCalendar = (GregorianCalendar)object;
        maxFutureCalendar.add(1, 30);
        return expiryDateCalendar.get(1) <= maxFutureCalendar.get(1);
    }

    private final boolean isInMinMonthRange(ExpiryDate expiryDate, Calendar calendar) {
        Calendar expiryDateCalendar = this.getExpiryCalendar(expiryDate);
        Object object = calendar.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.GregorianCalendar");
        GregorianCalendar maxPastCalendar = (GregorianCalendar)object;
        maxPastCalendar.add(2, -3);
        return expiryDateCalendar.compareTo(maxPastCalendar) >= 0;
    }

    private final boolean dateExists(ExpiryDate expiryDate) {
        return this.isValidMonth(expiryDate.getExpiryMonth()) && expiryDate.getExpiryYear() > 0;
    }

    private final boolean isValidMonth(int month) {
        return 1 <= month ? month < 13 : false;
    }

    private final Calendar getExpiryCalendar(ExpiryDate expiryDate) {
        Calendar expiryCalendar = GregorianCalendar.getInstance();
        expiryCalendar.clear();
        expiryCalendar.set(expiryDate.getExpiryYear(), expiryDate.getExpiryMonth() - 1, 1);
        expiryCalendar.add(2, 1);
        expiryCalendar.add(5, -1);
        Intrinsics.checkNotNull((Object)expiryCalendar);
        return expiryCalendar;
    }
}

