/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.internal.util;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0003J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/adyen/checkout/core/internal/util/LogcatLogger;", "Lcom/adyen/checkout/core/AdyenLogger;", "()V", "minLogLevel", "Lcom/adyen/checkout/core/AdyenLogLevel;", "concatThrowable", "", "message", "throwable", "", "log", "", "level", "tag", "logToLogcat", "priority", "", "setLogLevel", "shouldLog", "", "Companion", "checkout-core_release"})
public final class LogcatLogger
implements AdyenLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AdyenLogLevel minLogLevel = AdyenLogLevel.NONE;
    private static final int MAX_TAG_LENGTH = 23;
    private static final int MAX_LOG_LENGTH = 2048;

    @Override
    public boolean shouldLog(@NotNull AdyenLogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return level.getPriority() >= this.minLogLevel.getPriority();
    }

    @Override
    public void setLogLevel(@NotNull AdyenLogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.minLogLevel = level;
    }

    @Override
    public void log(@NotNull AdyenLogLevel level, @NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (tag.length() <= 23 || Build.VERSION.SDK_INT >= 26) {
            string = tag;
        } else {
            String string2 = tag.substring(0, 23);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        String trimmedTag = string;
        String fullMessage = this.concatThrowable(message, throwable);
        if (fullMessage.length() < 2048) {
            this.logToLogcat(level.getPriority(), trimmedTag, fullMessage);
            return;
        }
        int i = 0;
        int divisions = fullMessage.length() / 2048;
        if (i <= divisions) {
            while (true) {
                String string3;
                if (i != divisions) {
                    String string4 = fullMessage.substring(i * 2048, (i + 1) * 2048);
                    string3 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                } else {
                    String string5 = fullMessage.substring(i * 2048);
                    string3 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                }
                String newMessage = string3;
                this.logToLogcat(level.getPriority(), trimmedTag + "-" + i, newMessage);
                if (i == divisions) break;
                ++i;
            }
        }
    }

    private final String concatThrowable(String message, Throwable throwable) {
        return throwable != null ? message + ": " + Log.getStackTraceString((Throwable)throwable) : message;
    }

    @SuppressLint(value={"NotAdyenLog"})
    private final void logToLogcat(int priority, String tag, String message) {
        int n = priority;
        if (n != AdyenLogLevel.NONE.getPriority()) {
            if (n == 7) {
                Log.wtf((String)tag, (String)message);
            } else {
                Log.println((int)priority, (String)tag, (String)message);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/adyen/checkout/core/internal/util/LogcatLogger$Companion;", "", "()V", "MAX_LOG_LENGTH", "", "MAX_TAG_LENGTH", "checkout-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

