/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.internal.data.model;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.core.exception.BadModelException;
import com.adyen.checkout.core.internal.data.model.ModelObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0005\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ1\u0010\r\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J2\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0012\"\b\b\u0000\u0010\u0006*\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000fH\u0007J\u0018\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J1\u0010\u0016\u001a\u0004\u0018\u00010\t\"\b\b\u0000\u0010\u0006*\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u0001H\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000fH\u0007\u00a2\u0006\u0002\u0010\u0018J2\u0010\u0019\u001a\u0004\u0018\u00010\u0014\"\b\b\u0000\u0010\u0006*\u00020\u00072\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/adyen/checkout/core/internal/data/model/ModelUtils;", "", "()V", "SERIALIZER_FIELD_NAME", "", "deserializeModel", "T", "Lcom/adyen/checkout/core/internal/data/model/ModelObject;", "jsonObject", "Lorg/json/JSONObject;", "modelClass", "Ljava/lang/Class;", "(Lorg/json/JSONObject;Ljava/lang/Class;)Lcom/adyen/checkout/core/internal/data/model/ModelObject;", "deserializeOpt", "serializer", "Lcom/adyen/checkout/core/internal/data/model/ModelObject$Serializer;", "(Lorg/json/JSONObject;Lcom/adyen/checkout/core/internal/data/model/ModelObject$Serializer;)Lcom/adyen/checkout/core/internal/data/model/ModelObject;", "deserializeOptList", "", "jsonArray", "Lorg/json/JSONArray;", "readModelSerializer", "serializeOpt", "modelObject", "(Lcom/adyen/checkout/core/internal/data/model/ModelObject;Lcom/adyen/checkout/core/internal/data/model/ModelObject$Serializer;)Lorg/json/JSONObject;", "serializeOptList", "modelList", "checkout-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ModelUtils {
    @NotNull
    public static final ModelUtils INSTANCE = new ModelUtils();
    @NotNull
    public static final String SERIALIZER_FIELD_NAME = "SERIALIZER";

    private ModelUtils() {
    }

    @JvmStatic
    @NotNull
    public static final <T extends ModelObject> T deserializeModel(@NotNull JSONObject jsonObject, @NotNull Class<T> modelClass) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        ModelObject.Serializer<?> serializer = INSTANCE.readModelSerializer(modelClass);
        Intrinsics.checkNotNull(serializer, (String)"null cannot be cast to non-null type com.adyen.checkout.core.internal.data.model.ModelObject.Serializer<T of com.adyen.checkout.core.internal.data.model.ModelUtils.deserializeModel>");
        ModelObject.Serializer<?> serializer2 = serializer;
        return (T)serializer2.deserialize(jsonObject);
    }

    @JvmStatic
    @Nullable
    public static final <T extends ModelObject> T deserializeOpt(@Nullable JSONObject jsonObject, @NotNull ModelObject.Serializer<T> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        JSONObject jSONObject = jsonObject;
        return jSONObject == null ? null : (T)serializer.deserialize(jSONObject);
    }

    @JvmStatic
    @Nullable
    public static final <T extends ModelObject> List<T> deserializeOptList(@Nullable JSONArray jsonArray, @NotNull ModelObject.Serializer<T> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        if (jsonArray == null) {
            return null;
        }
        List list = new ArrayList();
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject itemJson = jsonArray.optJSONObject(i);
            if (itemJson == null) continue;
            T item = serializer.deserialize(itemJson);
            list.add(item);
        }
        return Collections.unmodifiableList(list);
    }

    @JvmStatic
    @Nullable
    public static final <T extends ModelObject> JSONObject serializeOpt(@Nullable T modelObject, @NotNull ModelObject.Serializer<T> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        T t = modelObject;
        return t == null ? null : serializer.serialize(t);
    }

    @JvmStatic
    @Nullable
    public static final <T extends ModelObject> JSONArray serializeOptList(@Nullable List<? extends T> modelList, @NotNull ModelObject.Serializer<T> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        if (modelList == null || modelList.isEmpty()) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (ModelObject model : modelList) {
            jsonArray.put((Object)serializer.serialize(model));
        }
        return jsonArray;
    }

    private final ModelObject.Serializer<?> readModelSerializer(Class<?> modelClass) {
        ModelObject.Serializer serializer;
        try {
            Field field = modelClass.getField(SERIALIZER_FIELD_NAME);
            if ((field.getModifiers() & 8) == 0) {
                throw new BadModelException(modelClass, null);
            }
            if (!ModelObject.Serializer.class.isAssignableFrom(field.getType())) {
                throw new BadModelException(modelClass, null);
            }
            Object object = field.get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.adyen.checkout.core.internal.data.model.ModelObject.Serializer<*>");
            serializer = (ModelObject.Serializer)object;
        }
        catch (NoSuchFieldException e) {
            throw new BadModelException(modelClass, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BadModelException(modelClass, (Throwable)e);
        }
        return serializer;
    }
}

