/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.internal.data.api;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.internal.data.api.HttpClient;
import com.adyen.checkout.core.internal.data.api.HttpClientFactory;
import com.adyen.checkout.core.internal.data.api.OkHttpClient;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/adyen/checkout/core/internal/data/api/HttpClientFactory;", "", "()V", "defaultHeaders", "", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "okHttpClient$delegate", "Lkotlin/Lazy;", "getAnalyticsHttpClient", "Lcom/adyen/checkout/core/internal/data/api/HttpClient;", "environment", "Lcom/adyen/checkout/core/Environment;", "getHttpClient", "checkout-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class HttpClientFactory {
    @NotNull
    public static final HttpClientFactory INSTANCE = new HttpClientFactory();
    @NotNull
    private static final Map<String, String> defaultHeaders = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json"));
    @NotNull
    private static final Lazy okHttpClient$delegate = LazyKt.lazy((Function0)okHttpClient.2.INSTANCE);

    private HttpClientFactory() {
    }

    private final okhttp3.OkHttpClient getOkHttpClient() {
        Lazy lazy = okHttpClient$delegate;
        return (okhttp3.OkHttpClient)lazy.getValue();
    }

    @NotNull
    public final HttpClient getHttpClient(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        okhttp3.OkHttpClient okHttpClient2 = this.getOkHttpClient();
        String string = environment.getCheckoutShopperBaseUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new OkHttpClient(okHttpClient2, string, defaultHeaders);
    }

    @NotNull
    public final HttpClient getAnalyticsHttpClient(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        okhttp3.OkHttpClient okHttpClient2 = this.getOkHttpClient();
        String string = environment.getCheckoutAnalyticsBaseUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new OkHttpClient(okHttpClient2, string, defaultHeaders);
    }
}

