/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.internal.util;

import androidx.annotation.RestrictTo;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tJ\u001c\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u000b\u001a\u00020\b\"\u00020\tH\u0007\u00a8\u0006\f"}, d2={"Lcom/adyen/checkout/core/internal/util/StringUtil;", "", "()V", "isDigitsAndSeparatorsOnly", "", "value", "", "separators", "", "", "normalize", "additionalCharsToReplace", "checkout-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class StringUtil {
    @NotNull
    public static final StringUtil INSTANCE = new StringUtil();

    private StringUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String normalize(@NotNull String value, char ... additionalCharsToReplace) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)additionalCharsToReplace, (String)"additionalCharsToReplace");
        Regex regex = new Regex("[\\s" + new String(additionalCharsToReplace) + "]");
        CharSequence charSequence = value;
        String string = "";
        return regex.replace(charSequence, string);
    }

    public final boolean isDigitsAndSeparatorsOnly(@NotNull String value, char ... separators) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)separators, (String)"separators");
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            boolean isDigitOrSeparator;
            char c = value.charAt(i);
            boolean bl = Character.isDigit(c) || !(separators.length == 0) && ArraysKt.contains((char[])separators, (char)c) ? true : (isDigitOrSeparator = false);
            if (isDigitOrSeparator) continue;
            return false;
        }
        return true;
    }
}

