/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.internal.util;

import androidx.annotation.RestrictTo;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/adyen/checkout/core/internal/util/Sha256;", "", "()V", "SHA_256", "", "digest", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "hash", "", "byteArray", "hashString", "string", "checkout-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Sha256 {
    @NotNull
    public static final Sha256 INSTANCE = new Sha256();
    @NotNull
    private static final String SHA_256 = "SHA-256";
    private static final MessageDigest digest = MessageDigest.getInstance("SHA-256");

    private Sha256() {
    }

    private final byte[] hash(byte[] byteArray) {
        digest.reset();
        digest.update(byteArray);
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public final String hashString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return new String(this.hash(byArray), Charsets.UTF_8);
    }
}

